/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.conv.NumberListFormat;
import com.jclark.xsl.expr.DescendantsOrSelfNodeIterator;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.NumberListFormatTemplate;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import java.util.Hashtable;

class AnyLevelNumberAction
implements Action {
    private Pattern count;
    private Pattern from;
    private NumberListFormatTemplate formatTemplate;

    AnyLevelNumberAction(Pattern count, Pattern from, NumberListFormatTemplate formatTemplate) {
        this.count = count;
        this.from = from;
        this.formatTemplate = formatTemplate;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(ProcessContext context, Node node, Result result) throws XSLException {
        void var7_7;
        Cache cache;
        NumberListFormat format = this.formatTemplate.instantiate(context, node);
        Node root = node.getRoot();
        Hashtable<Node, Object> documentTable = (Hashtable<Node, Object>)context.get(this);
        if (documentTable == null) {
            documentTable = new Hashtable<Node, Object>();
            context.put(this, documentTable);
        }
        if (this.count != null) {
            cache = (Cache)documentTable.get(root);
            if (cache == null) {
                Node tem;
                cache = new Cache();
                documentTable.put(root, cache);
                int n = 0;
                DescendantsOrSelfNodeIterator iter = new DescendantsOrSelfNodeIterator(root);
                while ((tem = iter.next()) != null) {
                    if (this.from != null && this.from.matches(tem, context)) {
                        n = 0;
                        continue;
                    }
                    if (!this.count.matches(tem, context)) continue;
                    cache.append(tem, n++);
                }
            }
        } else if (node.getType() == 0) {
            Name name;
            Hashtable<Name, Cache> elementTable = (Hashtable<Name, Cache>)documentTable.get(root);
            if (elementTable == null) {
                elementTable = new Hashtable<Name, Cache>();
                documentTable.put(root, elementTable);
            }
            if ((cache = (Cache)elementTable.get(name = node.getName())) == null) {
                Node tem;
                cache = new Cache();
                elementTable.put(name, cache);
                int n = 0;
                DescendantsOrSelfNodeIterator iter = new DescendantsOrSelfNodeIterator(root);
                while ((tem = iter.next()) != null) {
                    if (this.from != null && this.from.matches(tem, context)) {
                        n = 0;
                        continue;
                    }
                    if (!name.equals(tem.getName()) || tem.getType() != 0) continue;
                    cache.append(tem, n++);
                }
            }
        } else {
            return;
        }
        result.characters(format.getPrefix(0));
        result.characters(format.formatNumber(0, var7_7.getNumber(node)));
        result.characters(format.getSuffix());
    }

    static final class Cache {
        Node[] nodes = new Node[10];
        int[] numbers;
        int used = 0;

        Cache() {
        }

        private void append(Node node, int n) {
            if (this.used == this.nodes.length) {
                Node[] oldNodes = this.nodes;
                this.nodes = new Node[oldNodes.length * 2];
                System.arraycopy(oldNodes, 0, this.nodes, 0, oldNodes.length);
                if (this.numbers != null) {
                    int[] oldNumbers = this.numbers;
                    this.numbers = new int[oldNumbers.length * 2];
                    System.arraycopy(oldNumbers, 0, this.numbers, 0, oldNumbers.length);
                }
            }
            this.nodes[this.used] = node;
            if (this.numbers != null) {
                this.numbers[this.used] = n;
            } else if (n != this.used) {
                this.numbers = new int[this.nodes.length];
                for (int i = 0; i < this.used; ++i) {
                    this.numbers[i] = i;
                }
                this.numbers[this.used] = n;
            }
            ++this.used;
        }

        private int numberOf(int i) {
            if (this.numbers == null) {
                return i + 1;
            }
            return this.numbers[i] + 1;
        }

        int getNumber(Node node) {
            int start = 0;
            int end = this.used;
            while (start != end) {
                int mid = start + end >> 1;
                int cmp = node.compareTo(this.nodes[mid]);
                if (cmp == 0) {
                    return this.numberOf(mid);
                }
                if (cmp < 0) {
                    end = mid;
                    continue;
                }
                start = mid;
            }
            if (start == 0) {
                return 0;
            }
            return this.numberOf(start - 1);
        }
    }
}

