/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.OutputMethodAttributeList;
import com.jclark.xsl.sax.OutputMethodDefaulter;
import com.jclark.xsl.sax.OutputMethodHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import com.jclark.xsl.sax.ResultTreeFragment;
import com.jclark.xsl.tr.OutputMethod;
import com.jclark.xsl.tr.Result;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ResultBase
implements Result,
AttributeList {
    private DocumentHandler documentHandler;
    private CommentHandler commentHandler;
    ErrorHandler errorHandler;
    private RawCharactersHandler rawCharactersHandler;
    private static final int INITIAL_BUF_SIZE = 8192;
    private char[] buf = new char[8192];
    private int bufUsed = 0;
    private Name[] attributeNames = new Name[10];
    private String[] attributeValues = new String[10];
    private int nAttributes;
    private Name pendingElementType;
    private NamespacePrefixMap pendingNamespacePrefixMap;
    OutputMethodHandler outputMethodHandler;

    ResultBase(OutputMethodHandler outputMethodHandler, ErrorHandler errorHandler) {
        this.outputMethodHandler = outputMethodHandler;
        this.documentHandler = null;
        this.errorHandler = errorHandler;
    }

    ResultBase(DocumentHandler documentHandler, ErrorHandler errorHandler) {
        this.outputMethodHandler = null;
        this.errorHandler = errorHandler;
        this.setDocumentHandler(documentHandler);
    }

    private void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        this.commentHandler = handler instanceof CommentHandler ? (CommentHandler)((Object)handler) : null;
        this.rawCharactersHandler = handler instanceof RawCharactersHandler ? (RawCharactersHandler)((Object)handler) : null;
    }

    public void flush() throws XSLException {
        if (this.pendingElementType != null) {
            this.startElementContent(this.pendingElementType, this.pendingNamespacePrefixMap);
            this.pendingElementType = null;
        } else if (this.bufUsed > 0) {
            try {
                this.documentHandler.characters(this.buf, 0, this.bufUsed);
                this.bufUsed = 0;
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    public void rawCharacters(String str) throws XSLException {
        if (this.rawCharactersHandler == null) {
            this.characters(str);
        } else {
            this.flush();
            try {
                this.rawCharactersHandler.rawCharacters(str);
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    public void characters(String str) throws XSLException {
        int strLength;
        if (this.pendingElementType != null) {
            this.flush();
        }
        if (this.bufUsed + (strLength = str.length()) > this.buf.length) {
            int newLen;
            char[] oldBuf = this.buf;
            for (newLen = oldBuf.length * 2; newLen < this.bufUsed + strLength; newLen *= 2) {
            }
            this.buf = new char[newLen];
            if (this.bufUsed > 0) {
                System.arraycopy(oldBuf, 0, this.buf, 0, this.bufUsed);
            }
        }
        str.getChars(0, strLength, this.buf, this.bufUsed);
        this.bufUsed += strLength;
    }

    public void comment(String str) throws XSLException {
        if (this.commentHandler != null) {
            this.flush();
            try {
                this.commentHandler.comment(ResultBase.fixComment(str));
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }

    private static final String fixComment(String str) {
        int i = str.indexOf(45);
        while (i++ >= 0) {
            int len = str.length();
            if (i == len) {
                return str + " ";
            }
            if (str.charAt(i) == '-') {
                str = str.substring(0, i) + " " + str.substring(i);
            }
            i = str.indexOf(45, i);
        }
        return str;
    }

    public void processingInstruction(String target, String data) throws XSLException {
        try {
            this.flush();
            this.documentHandler.processingInstruction(target, ResultBase.fixProcessingInstruction(data));
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    private static final String fixProcessingInstruction(String str) {
        int len;
        int i = str.indexOf(63);
        while (i++ >= 0 && i != (len = str.length())) {
            if (str.charAt(i) == '>') {
                str = str.substring(0, i) + " " + str.substring(i);
            }
            i = str.indexOf(63, i);
        }
        return str;
    }

    public void startElement(Name elementType, NamespacePrefixMap nsMap) throws XSLException {
        this.flush();
        this.pendingElementType = elementType;
        this.pendingNamespacePrefixMap = nsMap;
        this.nAttributes = 0;
    }

    public void endElement(Name elementType) throws XSLException {
        this.flush();
        this.endElementContent(elementType);
    }

    protected final DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public int getLength() {
        return this.nAttributes;
    }

    protected final Name getAttributeName(int i) {
        return this.attributeNames[i];
    }

    public String getValue(int i) {
        return this.attributeValues[i];
    }

    public String getType(int i) {
        return "CDATA";
    }

    public String getType(String name) {
        return "CDATA";
    }

    public String getValue(String name) {
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            if (!name.equals(this.getName(i))) continue;
            return this.getValue(i);
        }
        return null;
    }

    protected abstract void startElementContent(Name var1, NamespacePrefixMap var2) throws XSLException;

    protected abstract void endElementContent(Name var1) throws XSLException;

    public void attribute(Name name, String value) throws XSLException {
        if (this.pendingElementType == null) {
            return;
        }
        for (int i = 0; i < this.nAttributes; ++i) {
            if (!this.attributeNames[i].equals(name)) continue;
            this.attributeValues[i] = value;
            return;
        }
        if (this.nAttributes == this.attributeNames.length) {
            this.attributeNames = ResultBase.grow(this.attributeNames);
            this.attributeValues = ResultBase.grow(this.attributeValues);
        }
        this.attributeNames[this.nAttributes] = name;
        this.attributeValues[this.nAttributes] = value;
        ++this.nAttributes;
    }

    static String[] grow(String[] v) {
        String[] old = v;
        v = new String[old.length * 2];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    static Name[] grow(Name[] v) {
        Name[] old = v;
        v = new Name[old.length * 2];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    public void start(OutputMethod outputMethod) throws XSLException {
        try {
            if (this.documentHandler == null) {
                Name name = outputMethod.getName();
                if (name == null) {
                    this.setDocumentHandler(new OutputMethodDefaulter(this, outputMethod));
                } else {
                    this.setOutputMethod(name, outputMethod);
                }
            }
            this.documentHandler.startDocument();
        }
        catch (IOException e) {
            throw new XSLException(e);
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    DocumentHandler setOutputMethod(Name name, OutputMethod method) throws IOException, SAXException {
        String nameString = name.getNamespace() != null ? name.getNamespace() + '^' + name.getLocalPart() : name.getLocalPart();
        this.setDocumentHandler(this.outputMethodHandler.createDocumentHandler(nameString, new OutputMethodAttributeList(method)));
        return this.documentHandler;
    }

    public void end() throws XSLException {
        try {
            this.flush();
            this.documentHandler.endDocument();
        }
        catch (SAXException e) {
            this.throwXSLException(e);
        }
    }

    protected void throwXSLException(SAXException e) throws XSLException {
        Exception wrapped = e.getException();
        if (wrapped != null) {
            throw new XSLException(wrapped);
        }
        throw new XSLException(e.getMessage());
    }

    public abstract void resultTreeFragment(ResultTreeFragment var1) throws XSLException;

    public void message(Node node, String str) throws XSLException {
        if (this.errorHandler != null) {
            String systemId = null;
            int lineNumber = -1;
            if (node != null) {
                URL url = node.getURL();
                if (url != null) {
                    systemId = url.toString();
                }
                lineNumber = node.getLineNumber();
            }
            try {
                this.errorHandler.warning(new SAXParseException(str, null, systemId, lineNumber, -1, null));
            }
            catch (SAXException e) {
                this.throwXSLException(e);
            }
        }
    }
}

