/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_XX__
#define __TIFFEP_TIVARS_XX__

#include "tiffep.h"

/* Calc independant defs */

/*
  This structure is used for storing a real or a complex number
*/
/* Calcs: 86 */
struct var_number_
{
  // Internal type
  gint type; // real or complex

  // TiFFEP encoding
  RealNumber_86 real_number;
  CplxNumber_86 cplx_number;
};
typedef struct var_number_ VarNum;
typedef struct var_number_ VarNumber;
typedef struct var_number_ VarConst; // do not use !

/*
  This structure is used for storing informations of an expression.
  Not determined yet !
*/
/* Calcs: 86 */
struct var_expr_
{
  // TI encoding

  // Internal type
  gint type;

  // TiFFEP encoding
};
typedef struct var_expr_ VarExpr;

/*
  This structure is used for storing informations of a vector.
*/
/* Calcs: 86 */
struct var_vector_
{
  // TI encoding
  byte nothing;     // always set to 1
  byte nelts;       // number of elements in the vector
  byte *elts;       // array of elements (Real or Complex)

  // Internal type
  gint type;

  // TiFFEP encoding
  GList *vector;     // vector of Real/Complex numbers
};
typedef struct var_list_ VarVector;

/*
  This structure is used for storing informations of a list.
*/
/* Calcs: 86 */
struct var_list_
{
  // TI encoding
  word nelts;       // number of elements in the vector
  byte *elts;       // array of elements (Real or Complex)

  // Internal type
  gint type;        // real or complex

  // TiFFEP encoding
  GList *list;     // list of Real/Complex numbers
};
typedef struct var_list_ VarList;

/*
  This structure is used for storing informations of a list.
*/
/* Calcs: 86 */
struct var_matrix_
{
  // TI encoding
  byte ncols;       // number of columns in the matrix
  byte nrows;       // number of rows in the matrix
  byte *elts;       // array of elements (Real or Complex)

  // Internal type
  gint type;        // real or complex

  // TiFFEP encoding
  GList *matrix;     // matrix of Real/Complex numbers
};
typedef struct var_matrix_ VarMatrix;


/* Calcs: 86 */
struct var_data_
{
	// Internal type
	gint type;        //
};
typedef struct var_data_ VarData;


/*
  This structure is used for storing a string object
*/
/* Calcs: 83, 85, 86, 89, 92, 92+ */
struct var_string_
{
  // Internal type
  gint type; // string or text (TYPE_STR/TYPE_TEXT)

  // TiFFEP encoding
  gchar *str;   // C-string
  gint curs_pos; // cursor position
};
typedef struct var_string_ VarString;


/* Calcs: ?? */
struct var_gdb_
{
	// Internal type
	gint type;        //
};
typedef struct var_gdb_ VarGdb;

/* Calcs: ?? */
struct var_figure_
{
	// Internal type
	gint type;        //
};
typedef struct var_figure_ VarFigure;

/* Calcs: ?? */
struct var_picture_
{
	// Internal type
	gint type;        //
};
typedef struct var_picture_ VarPict;

/* Calcs: ?? */
struct var_prgm_
{
  word size;
  byte *bitmap;
};
typedef struct var_prgm_ VarPrgm;

/* Calcs: ?? */
struct var_fnct_
{
	// Internal type
	gint type;        //
};
typedef struct var_fnct_ VarFnct;

/* Calcs: ?? */
struct var_macro_
{
	// Internal type
	gint type;        //
};
typedef struct var_macro_ VarMacro;

/* Calcs: ?? */
struct var_backup_
{
	// Internal type
	gint type;        //
};
typedef struct var_backup_ VarBackup;

#endif

