/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_TIVARS_85__
#define __TIFFEP_TIVARS_85__

#include "tiffep.h"

/* !!!
   Important note: var definition are the same for 85 and 86.
   So, any modification in ti_vars_86.h should be made here also.
   !!!
*/

/*************************/
/* Structure definitions */
/*************************/

/* TI85 calculators */

/*
  This structure is used for storing a real
*/
struct real_number_85_
{
  // TI encoding
  byte flags;
  byte exponent[2];
  byte mantissa[7];
};
typedef struct real_number_85_ RealNumber_85;

/*
  This structure is used for storing a complex number
*/
struct complex_number_85_
{
  RealNumber_85 real_part;
  RealNumber_85 imag_part;
};
typedef struct complex_number_85_ CplxNumber_85;

/*
  This structure is used for storing a real vector
*/
struct var_real_vector_85_
{
  // TI encoding
  byte nothing;     // always set to 1
  byte nelts;       // number of elements in the vector
  RealNumber_85 *elts;       // array of elements (Real)
};
typedef struct var_real_vector_85_ RealVector_85;

/*
  This structure is used for storing a complex vector
*/
struct var_cplx_vector_85_
{
  // TI encoding
  byte nothing;     // always set to 1
  byte nelts;       // number of elements in the vector
  CplxNumber_85 *elts; // array of elements (Complex)
};
typedef struct var_cplx_vector_85_ CplxVector_85;

/*
  This structure is used for storing a real list
*/
struct var_real_list_85_
{
  // TI encoding
  word nelts;       // number of elements in the list
  RealNumber_85 *elts; // array of elements (Real)
};
typedef struct var_real_vector_85_ RealList_85;

/*
  This structure is used for storing a complex list
*/
struct var_cplx_list_85_
{
  // TI encodind
  word nelts;       // number of elements in the list
  CplxNumber_85 *elts; // array of elements (Complex)
};
typedef struct var_cplx_vector_85_ CplxList_85;

/*
  This structure is used for storing a real matrix
*/
struct var_real_matrix_85_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_85 *elts; // array of elements (Real)
};
typedef struct var_real_matrix_85_ RealMatrix_85;

/*
  This structure is used for storing a complex list
*/
struct var_cplx_matrix_85_
{
  // TI encoding
  byte ncols;
  byte nrows;
  RealNumber_85 *elts; // array of elements (Real)
};
typedef struct var_cplx_matrix_85_ CplxMatrix_85;

/*
  This structure is used for storing a real constant
*/
typedef RealNumber_85 RealConstant_85;

/*
  This structure is used for storing a real constant
*/
typedef CplxNumber_85 CplxConstant_85;

/*
  This structure is used for storing a string
*/
struct var_string_85_
{
  // TI encoding
  word length;
  byte *string; //not zero terminated
};
typedef struct var_string_85_ String_85;

/*
  This structure is used for storing an equation
*/
typedef String_85 Equation_85;

/*
  This structure is used for storing a Graphic Data Base object
*/
struct var_gdb_function_85_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
  RealNumber_85 x_res;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_polar_85_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_85 theta_min;
  RealNumber_85 theta_max;
  RealNumber_85 theta_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_param_85_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_85 t_min;
  RealNumber_85 t_max;
  RealNumber_85 t_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

struct var_gdb_diffeq_85_
{
  // TI encoding
  word length;
  byte mode_settings;
  RealNumber_85 dif_tol;
  RealNumber_85 t_plot;
  RealNumber_85 t_min;
  RealNumber_85 t_max;
  RealNumber_85 t_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
  byte fld_off_x;
  byte fld_off_y;
  byte slp_fld_y;
  byte dir_fld_x;
  byte dir_fld_y;
  RealNumber_85 d_time;
  RealNumber_85 fld_res;
  RealNumber_85 e_step;

  byte n_fncts;
  byte *fnct_table;
  byte style[50];
};

union var_gdb_85_
{
  struct var_gdb_function_85_ fnct;
  struct var_gdb_polar_85_    polar;
  struct var_gdb_param_85_    param;
  struct var_gdb_diffeq_85_   diffeq;
};
typedef union var_gdb_85_ Gdb_85;

/*
  This structure is used for storing a picture object
*/
struct var_picture_85_
{
  // TI encoding
  word size;
  byte bitmap[1008];
};
typedef struct var_picture_85_ Picture_85;

/*
  This structure is used for storing a program object
*/
typedef String_85 Program_85;

/*
  This structure is used for storing a Window Settings object
*/
struct var_wndsettings_function_85_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
  byte unknown2[20]; // 2 reals, 1 complex ??
  RealNumber_85 x_res;
};

struct var_wndsettings_polar_85_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_85 theta_min;
  RealNumber_85 thetha_max;
  RealNumber_85 theta_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
};

struct var_wndsettings_param_85_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_85 t_min;
  RealNumber_85 t_max;
  RealNumber_85 t_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
};

struct var_wndsettings_diffeq_85_
{
  // TI encoding
  word unused;
  byte unknwown;
  RealNumber_85 diff_tol;
  RealNumber_85 t_plot;
  RealNumber_85 t_min;
  RealNumber_85 t_max;
  RealNumber_85 t_step;
  RealNumber_85 x_min;
  RealNumber_85 x_max;
  RealNumber_85 x_scl;
  RealNumber_85 y_min;
  RealNumber_85 y_max;
  RealNumber_85 y_scl;
  
  byte fld_off_x;
  byte fld_off_y;
  byte slp_fld_y;
  byte dir_fld_x;
  byte dir_fld_y;
  RealNumber_85 d_time;
  RealNumber_85 fld_res;
  RealNumber_85 e_step;
};

struct var_wndsettings_saved_85_
{
  // TI encoding
  word unused;
  RealNumber_85 z_theta_min;
  RealNumber_85 z_theta_max;
  RealNumber_85 z_theta_step;
  RealNumber_85 z_t_plot;
  RealNumber_85 z_t_min;
  RealNumber_85 z_t_max;
  RealNumber_85 z_t_step;
  RealNumber_85 z_x_min;
  RealNumber_85 z_x_max;
  RealNumber_85 z_x_scl;
  RealNumber_85 z_y_min;
  RealNumber_85 z_y_max;
  RealNumber_85 z_y_scl;
  RealNumber_85 z_x_res;
};

union var_wndsettings_85_
{
  struct var_wndsettings_function_85_ fnct;
  struct var_wndsettings_polar_85_    polar;
  struct var_wndsettings_param_85_    param;
  struct var_wndsettings_diffeq_85_   diffeq;
  struct var_wndsettings_saved_85_    zsto;
};
typedef union var_wndsettings_85_ WndSettings_85;


#endif

