/* RedoAction.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.undoredo;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;

/**
 * Action which reverts the last undo effected by the corresponding
 * undo manager. When the action is enabled, the
 * caption is taken from the current {@link UndoableChange} 
 * in the undo list of the associated {@link UndoManager}.
 */
public class RedoAction extends UndoRedoAction {

    /**
     * Create an action of this type. When the action is enabled, the
     * caption is taken from the current {@link UndoableChange} of the
     * associated {@link UndoManager}. Mnemonic
     * and accelerator key are taken from the description object as defined
     * by the parameters {@code bundle} and {@code key}.
     * @param manager Undo manager to which this action applies
     * @param bundle Resource bundle which contains the description for
     * this action.
     * @param key Key used for the description of this action in the bundle.
     * @param icon Small icon to be used for menu and standard button decoration (or null)
     * @param mediumIcon Medium size icon to be used for tool bar buttons (or null)
     * @param mediumDisabledIcon Medium size icon to be used for a disabled tool bar buttons (or null)
     */
    public RedoAction (UndoManager manager, ResourceBundle bundle, String key, 
		       Icon icon, Icon mediumIcon, Icon mediumDisabledIcon)  {
        super(manager, bundle, key, icon, mediumIcon, mediumDisabledIcon);
    }
    
    /**
     * Create an action of this type for use with the {@link be.ugent.caagt.swirl.menus.MenuBuilder}.
     */
    public RedoAction (UndoManager manager) {
        super(manager);
    }

    @Override
    protected String getCaption() {
        return manager.getRedoCaption();
    }

    /**
     * Redoes the current undoable change.
     */
    public void actionPerformed (ActionEvent e) {
        manager.redoLast ();
    }

    /**
     * Enables or disables the button according to whether
     * any changes remain to be redone or not.
     */
    public void undoStateChanged () {
        setEnabled (manager.canRedo ());
    }

}
