/* SwirlUtilities.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JMenu;

/**
 * General Swing or SWIRL related methods.
 */
public final class SwirlUtilities {
    
    /**
     * Returns the first child component with the given name, or null
     * if no such child can be found. Does not consider all descendants
     * but only direct children.<p>
     * If the container is a menu, then the children of the associated
     * popup menu are searched.
     */
    public static Component getChildWithName (Container container, String name) {
        if (container instanceof JMenu) {
            container = ((JMenu)container).getPopupMenu();
        }
        for (Component component : container.getComponents())
            if (name.equals(component.getName()))
                return component;
        return null;
    }
    
    /**
     * Returns the first descendant with the given name, or null if no
     * such descendant can be found. The search is performed depth first and parents are
     * processed before their children.<p>
     * If during the search a menu is encounterd, then the descendants of the associated
     * popup menu are searched.
     */
    public static Component getDescendantWithName (Container container, String name) {
        if (container instanceof JMenu) {
            container = ((JMenu)container).getPopupMenu();
        }
        for (Component component : container.getComponents())
            if (name.equals(component.getName()))
                return component;
            else if (component instanceof Container) {
                Component found = getDescendantWithName ((Container)component, name);
                if (found != null)
                    return found;
            }
        return null;
    }

}
