#include <iostream>

#include <sigcx/thread.h>
#include <sigcx/thread_tunnel.h>

using namespace std;
using namespace SigC;
using namespace SigCX;
using namespace SigCX::Threads;

class HelloWorld : public StandardDispatcher
{
  public:
    void greet(const string& msg) {
      cout << "Hello World! " << msg << endl;
    }
};

int main()
{
  HelloWorld hello;
  ThreadTunnel tunn(hello);
  
  tunnel<void, const string&>(slot(hello, &HelloWorld::greet), 
                              "Today is a nice day.", &tunn);

  Slot1<void, const string&> tunneled_slot = 
    open_tunnel(&tunn, slot(hello, &HelloWorld::greet));
  
  tunneled_slot("I say goodbye now.");
  
  tunnel(slot(dynamic_cast<Dispatcher&>(hello), &Dispatcher::exit), 
         &tunn, true);
}
