require 'sdl'

SDL.init( SDL::INIT_VIDEO|SDL::INIT_JOYSTICK )
screen = SDL::setVideoMode(640,480,16,SDL::SWSURFACE)

if SDL::Joystick.num == 0 then
  raise "joystick not found"
end

print SDL::Joystick.name(0),"\n"
joy=SDL::Joystick.open(0)

event=SDL::Event.new

while true 
  if  event.poll != 0 then
    if event.type==SDL::Event::QUIT then
      break
    end
    if event.type==SDL::Event::KEYDOWN then
      exit
    end
  end
  SDL::Joystick.updateAll
  screen.fillRect(0,0,640,480,0)
  screen.drawFilledCircle( joy.axis(0)/500+320, joy.axis(1)/500+200,10,0xff)
  for i in 0..joy.numButtons-1
    if joy.button(i) then
      screen.drawFilledCircle( i*30+30,50,10,0xff )
    else
      screen.drawCircle( i*30+30,50,10,0xff )
    end
  end
  screen.updateRect(0,0,0,0)
end

print "exit\n"
