/*
  File autogenerated by gengetopt version 2.12.2
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->import_format_given = 0 ;
  args_info->list_import_formats_given = 0 ;
  args_info->msg_parser_given = 0 ;
  args_info->msg_debug_given = 0 ;
  args_info->msg_warning_given = 0 ;
  args_info->msg_error_given = 0 ;
  args_info->msg_info_given = 0 ;
  args_info->msg_status_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->import_format_arg = gengetopt_strdup ("AUTODETECT");
  args_info->msg_parser_flag = 0;
  args_info->msg_debug_flag = 0;
  args_info->msg_warning_flag = 1;
  args_info->msg_error_flag = 1;
  args_info->msg_info_flag = 1;
  args_info->msg_status_flag = 1;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
"  ofxdump prints to stdout, in human readable form, everything the library \n   understands about a particular file or response, and sends errors to \n   stderr.  To know exactly what the library understands about of a particular\n   ofx response file, just call ofxdump on that file.\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("%s\n","  -h, --help                  Print help and exit");
  printf("%s\n","  -V, --version               Print version and exit");
  printf("%s\n","  -f, --import-format=STRING  Force the file format of the file(s) specified  \n                                (default=`AUTODETECT')");
  printf("%s\n","      --list-import-formats   List available import file formats \n                                'import-format' command");
  printf("%s\n","      --msg_parser            Output file parsing messages  (default=off)");
  printf("%s\n","      --msg_debug             Output messages meant for debuging  (default=off)");
  printf("%s\n","      --msg_warning           Output warning messages about abnormal conditions \n                                and unknown constructs  (default=on)");
  printf("%s\n","      --msg_error             Output error messages  (default=on)");
  printf("%s\n","      --msg_info              Output informational messages about the progress \n                                of the library  (default=on)");
  printf("%s\n","      --msg_status            Output status messages  (default=on)");
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->import_format_arg)
    {
      free (args_info->import_format_arg); /* free previous argument */
      args_info->import_format_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "import-format",	1, NULL, 'f' },
        { "list-import-formats",	0, NULL, 0 },
        { "msg_parser",	0, NULL, 0 },
        { "msg_debug",	0, NULL, 0 },
        { "msg_warning",	0, NULL, 0 },
        { "msg_error",	0, NULL, 0 },
        { "msg_info",	0, NULL, 0 },
        { "msg_status",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVf:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* Force the file format of the file(s) specified.  */
          if (local_args_info.import_format_given)
            {
              fprintf (stderr, "%s: `--import-format' (`-f') option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->import_format_given && ! override)
            continue;
          local_args_info.import_format_given = 1;
          args_info->import_format_given = 1;
          if (args_info->import_format_arg)
            free (args_info->import_format_arg); /* free previous string */
          args_info->import_format_arg = gengetopt_strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* List available import file formats 'import-format' command.  */
          if (strcmp (long_options[option_index].name, "list-import-formats") == 0)
          {
            if (local_args_info.list_import_formats_given)
              {
                fprintf (stderr, "%s: `--list-import-formats' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->list_import_formats_given && ! override)
              continue;
            local_args_info.list_import_formats_given = 1;
            args_info->list_import_formats_given = 1;
            break;
          }
          
          /* Output file parsing messages.  */
          else if (strcmp (long_options[option_index].name, "msg_parser") == 0)
          {
            if (local_args_info.msg_parser_given)
              {
                fprintf (stderr, "%s: `--msg_parser' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_parser_given && ! override)
              continue;
            local_args_info.msg_parser_given = 1;
            args_info->msg_parser_given = 1;
            args_info->msg_parser_flag = !(args_info->msg_parser_flag);
          }
          
          /* Output messages meant for debuging.  */
          else if (strcmp (long_options[option_index].name, "msg_debug") == 0)
          {
            if (local_args_info.msg_debug_given)
              {
                fprintf (stderr, "%s: `--msg_debug' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_debug_given && ! override)
              continue;
            local_args_info.msg_debug_given = 1;
            args_info->msg_debug_given = 1;
            args_info->msg_debug_flag = !(args_info->msg_debug_flag);
          }
          
          /* Output warning messages about abnormal conditions and unknown constructs.  */
          else if (strcmp (long_options[option_index].name, "msg_warning") == 0)
          {
            if (local_args_info.msg_warning_given)
              {
                fprintf (stderr, "%s: `--msg_warning' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_warning_given && ! override)
              continue;
            local_args_info.msg_warning_given = 1;
            args_info->msg_warning_given = 1;
            args_info->msg_warning_flag = !(args_info->msg_warning_flag);
          }
          
          /* Output error messages.  */
          else if (strcmp (long_options[option_index].name, "msg_error") == 0)
          {
            if (local_args_info.msg_error_given)
              {
                fprintf (stderr, "%s: `--msg_error' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_error_given && ! override)
              continue;
            local_args_info.msg_error_given = 1;
            args_info->msg_error_given = 1;
            args_info->msg_error_flag = !(args_info->msg_error_flag);
          }
          
          /* Output informational messages about the progress of the library.  */
          else if (strcmp (long_options[option_index].name, "msg_info") == 0)
          {
            if (local_args_info.msg_info_given)
              {
                fprintf (stderr, "%s: `--msg_info' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_info_given && ! override)
              continue;
            local_args_info.msg_info_given = 1;
            args_info->msg_info_given = 1;
            args_info->msg_info_flag = !(args_info->msg_info_flag);
          }
          
          /* Output status messages.  */
          else if (strcmp (long_options[option_index].name, "msg_status") == 0)
          {
            if (local_args_info.msg_status_given)
              {
                fprintf (stderr, "%s: `--msg_status' option given more than once%s\n", CMDLINE_PARSER_PACKAGE, (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->msg_status_given && ! override)
              continue;
            local_args_info.msg_status_given = 1;
            args_info->msg_status_given = 1;
            args_info->msg_status_flag = !(args_info->msg_status_flag);
          }
          

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
    }

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  return (EXIT_FAILURE);
}
