/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi.jrmp;

import java.lang.reflect.Constructor;

import mx4j.tools.adaptor.rmi.RMIAdaptorMBeanDescription;

/**
 * Management interface descriptions for the JRMPAdaptor MBean.
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class JRMPAdaptorMBeanDescription extends RMIAdaptorMBeanDescription
{
   public String getMBeanDescription()
   {
      return "Adaptor for the RMI/JRMP protocol";
   }

   public String getConstructorDescription(Constructor ctor)
   {
      if (ctor.toString().equals("public mx4j.tools.adaptor.rmi.jrmp.JRMPAdaptor()"))
      {
         return "Creates a new JRMP adaptor";
      }
      return super.getConstructorDescription(ctor);
   }

   public String getAttributeDescription(String attribute)
   {
      if (attribute.equals("Port"))
      {
         return "The RMI port where this adaptor is exported";
      }
      if (attribute.equals("SSLFactory"))
      {
         return "The ObjectName string of the SSL factory MBean used by this adaptor when using JRMP over SSL";
      }
      return super.getAttributeDescription(attribute);
   }
}
