#include <limits.h>
#include "ucs.h"

static int ucs_to_iso_pool[] = {
#include "ucs-to-iso-pool.h"
};

static unsigned int ucs_to_iso_tab[] = {
#include "ucs-to-iso.h"
};

int *
mb_ucs_to_isov(int ucs)
{
  unsigned int i;
  mb_bt_result_t res = mb_bt_search(ucs, ucs_to_iso_tab, &i);

  return res != mb_bt_failure ? &ucs_to_iso_pool[i] : NULL;
}

void
mb_ucs_to_isoc(int *pool, mb_char_t *ch)
{
  int *p;
  int set;

  for (p = pool ;; ++p) {
    switch (set = MB_WORD_DEC_SET(*p)) {
    case mb_94x94:
      ch->c = MB_WORD_DEC_C(*p);
      ch->set = mb_94x94;
      ch->fc = MB_WORD_DEC_FC(*p);
      ch->gn = mb_G0;
      ch->sn = mb_SL;
      return;
    default:
      break;
    }

    if (MB_U2I_ISLAST(*p))
      break;
  }

  switch (set) {
  case mb_96_0:
  case mb_96_1:
    ch->gn = mb_G1;
    ch->sn = mb_SR;
    break;
  case mb_128:
    return;
  default:
    ch->gn = mb_G0;
    ch->sn = mb_SL;
    break;
  }

  ch->set = set;
  ch->fc = MB_WORD_DEC_FC(*p);
  ch->c = MB_WORD_DEC_C(*p);
}

static unsigned int iso_to_ucs_tab[] = {
#include "iso-to-ucs.h"
};

void
mb_conv_iso_to_ucs(mb_char_t *ch, mb_info_t *info)
{
  if (ch->set != mb_128 || (ch->fc & MB_ESC_FC_MASK) != (0x47 & MB_ESC_FC_MASK)) {
    int set = ch->set, fc = ch->fc, iso;
    unsigned int value;
    mb_bt_result_t res;

  loop:
    iso = MB_WORD_ENC_3(ch->c, set, fc);
    res = mb_bt_search(iso, iso_to_ucs_tab, &value);

    if (res != mb_bt_failure) {
      ch->c = value;
      ch->set = mb_128;
      ch->fc = 0x47 & MB_ESC_FC_MASK;
      ch->gn = mb_G1;
      ch->sn = mb_SR;
    }
    else if (mb_iso_preconv(iso, &set, &fc))
      goto loop;
  }
}
