# Perl5 script to make a mapping table of JIS codepoints into registeration numbers.
# Invoke as:
#   perl jismap.pl /path/to/text-mapping-datas/*.TXT

require 5;

$j1_h = 'jis1flag.h' if (!defined($jis1_h));
$j2_h = 'jis2flag.h' if (!defined($jis2_h));

require 'ucs-to-iso-lib.pl';
require 'mbbtri.pl';

my ($jis1map, $jis2map);

(undef, undef, $jis1map, $jis2map) = &make_map;

my $jis1tree = &bt_new;
my $jis2tree = &bt_new;
my ($jis, $flag);

while (($jis, $flag) = each %$jis1map) {
  &bt_add($jis1tree, $jis, $flag);
}

while (($jis, $flag) = each %$jis2map) {
  &bt_add($jis2tree, $jis, $flag);
}

&bt_optimize($jis1tree);
&bt_make_c_header($jis1tree, $j1_h);
&bt_optimize($jis2tree);
&bt_make_c_header($jis2tree, $j2_h);

exit;
