/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Network.hh,v 1.3 2001/12/19 12:46:59 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef __NETWORK_HH_FLAG__
#define __NETWORK_HH_FLAG__

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/IPAddress.hh>

namespace libfwbuilder
{

class Network : public FWObject 
{
    private:
    
    IPAddress address;
    Netmask   netmask;
    
    public:
    
    Network();
    Network(Network &);

    const IPAddress &getAddress() const { return address; }
    const Netmask   &getNetmask() const { return netmask; }

    void setData(IPNetwork &n) { address=n.getAddress(); netmask=n.getNetmask(); }
    void setAddress(const IPAddress &o) { address=o; }
    void setNetmask(const Netmask &o)   { netmask=o; }
    
    virtual Network& operator=(const FWObject &o);
    virtual FWObject& duplicate(const FWObject *obj);
   
    Network::iterator& begin();
    Network::iterator& end();

    class iterator
    {
        friend class Network;

        public:
        
        Network::iterator& operator*();
        Network::iterator& operator++();
        bool operator==(const Network::iterator &x);
        
        private:
        
        explicit iterator();
    };
    
    virtual void       fromXML (xmlNodePtr parent);
    virtual xmlNodePtr toXML   (xmlNodePtr xml_parent_node);
    
    DECLARE_FWOBJECT_SUBTYPE(Network);
    
};

}

#endif // __NETWORK_HH_FLAG__




