
#include <fwbuilder/IntervalGroup.hh>
#include <fwbuilder/FWIntervalReference.hh>

using namespace std;
using namespace libfwbuilder;

const char *IntervalGroup::TYPENAME={"IntervalGroup"};

IntervalGroup::IntervalGroup() : Group() {}

IntervalGroup::~IntervalGroup() {}

bool  IntervalGroup::validateChild(FWObject *o)
{ 
    string otype=o->getTypeName();
    return (FWObject::validateChild(o) && 
	    (otype=="Interval" ||
	     otype=="IntervalGroup" ||
	     otype=="IntervalRef" ));
}

FWReference* IntervalGroup::createRef( FWObject* obj )
{
    return new FWIntervalReference(obj);
}

