/*

    Semaphore wrapper class
    Copyright (C) 2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <semaphore.h>


#ifndef SEMAPHORE_HH
    #define SEMAPHORE_HH

    class clSemaphore
    {
            sem_t semSemaphore;
        public:
            clSemaphore ()
                { sem_init(&semSemaphore, 0, 0); }
            clSemaphore (unsigned int uiSemValue)
                { sem_init(&semSemaphore, 0, uiSemValue); }
            ~clSemaphore ()
                { sem_destroy(&semSemaphore); }
            bool Initialize (unsigned int uiSemValue)
                { 
                    if (sem_init(&semSemaphore, 0, uiSemValue) < 0) 
                        return false;
                    return true;
                }
            void Wait ()
                { sem_wait(&semSemaphore); }
            bool TryWait ()
                { 
                    if (sem_trywait(&semSemaphore) < 0) return false;
                    return true;
                }
            bool Post ()
                {
                    if (sem_post(&semSemaphore) < 0) return false;
                    return true;
                }
            int GetValue ()
                {
                    int iSemValue;
                    sem_getvalue(&semSemaphore, &iSemValue);
                    return iSemValue;
                }
    };
    
#endif

