.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH drmModeGetResources  __drivermansuffix__ __vendorversion__
.SH NAME
drmModeGetResources \- retrieve current display configuration information
.SH SYNOPSIS
.nf
.B "#include <xf86drmMode.h>"

.BI "typedef struct _drmModeRes {"

.BI "	int count_fbs;"
.BI "	uint32_t *fbs;"

.BI "	int count_crtcs;"
.BI "	uint32_t *crtcs;"

.BI "	int count_connectors;"
.BI "	uint32_t *connectors;"

.BI "	int count_encoders;"
.BI "	uint32_t *encoders;"

.BI "	uint32_t min_width, max_width;"
.BI "	uint32_t min_height, max_height;"
.B "} drmModeRes, *drmModeResPtr;"

.B "drmModeResPtr drmModeGetResources(int fd);"
.fi
.SH DESCRIPTION
This function will allocate, populate, and return a drmModeRes structure
containing information about the current display configuration.

The
.I count_fbs
and
.I fbs
fields indicate the number of currently allocated framebuffer objects (i.e.
objects that can be attached to a given CRTC or sprite for display).

The
.I count_crtcs
and
.I crtcs
fields list the available CRTCs in the configuration.  A CRTC is simply
an object that can scan out a framebuffer to a display sink, and contains
mode timing and relative position information.  CRTCs drive encoders, which
are responsible for converting the pixel stream into a specific display
protocol (e.g. MIPI or HDMI).

The
.I count_connectors
and
.I connectors
fields list the available physical connectors on the system.  Note that
some of these may not be exposed from the chassis (e.g. LVDS or eDP).
Connectors are attached to encoders and contain information about the
attached display sink (e.g. width and height in mm, subpixel ordering, and
various other properties).

The
.I count_encoders
and
.I encoders
fields list the available encoders on the device.  Each encoder may be
associated with a CRTC, and may be used to drive a particular encoder.

The min and max height fields indicate the maximum size of a framebuffer
for this device (i.e. the scanout size limit).

.SH RETURN VALUE
Returns a drmModeRes structure pointer on success, 0 on failure.

.SH REPORTING BUGS
Bugs in this function should be reported to http://bugs.freedesktop.org under
the "Mesa" product, with "Other" or "libdrm" as the component.

.SH "SEE ALSO"
drmModeGetFB(__libmansuffix__), drmModeAddFB(__libmansuffix__), drmModeAddFB2(__libmansuffix__), drmModeRmFB(__libmansuffix__), drmModeDirtyFB(__libmansuffix__), drmModeGetCrtc(__libmansuffix__), drmModeSetCrtc(__libmansuffix__), drmModeGetEncoder(__libmansuffix__), drmModeGetConnector(__libmansuffix__)
