/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__STORAGEEXCEPTION_HPP)
#include <StorageException.hpp>
#endif

namespace   corelinux
{
   //
   // Default public constructor
   //

   StorageException::StorageException
      ( 
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      Exception("StorageException",file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }

   //
   // Implementation protected constructor
   //

   StorageException::StorageException
      ( 
         CharCptr why,
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      Exception(why,file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }
   //
   // Default protected constructor
   //

   StorageException::StorageException( void )
      :
      Exception()
   {
      NEVER_GET_HERE;
   }

   //
   // Copy constructor
   //

   StorageException::StorageException( StorageExceptionCref aRef )
      :
      Exception( aRef )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   StorageException::~StorageException( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   StorageExceptionRef StorageException::operator=
      ( 
         StorageExceptionCref aRef 
      )
   {
      Exception::operator=( aRef );
      return (*this);
   }

   //
   // Equality operator
   //

   bool  StorageException::operator==( StorageExceptionCref aRef ) const
   {
      return (this == &aRef);
   }

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/14 12:55:43 $
   $Locker:  $
*/


