#if   !defined(__MODELER_HPP)
#define  __MODELER_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <Vector.hpp>
#endif

#if   !defined(__OBJECT_HPP)
#include <Object.hpp>
#endif

CORELINUX_VECTOR(  DwordIdentifier ,  IdVector ) ;
CORELINUX_MAP( DwordIdentifier, IdVector, less<DwordIdentifier>, IdMap ) ;

/**
The Modeler encapsulates the associations between object parent
and child relationships.
*/

DECLARE_CLASS( Modeler );

class Modeler
{
public:

   //
   // Constructors and destructor
   //

                           /// Default constructor

                           Modeler( void );

                           /// Copy constructor

                           Modeler( ModelerCref );

                           /// Virtual destructor

   virtual                 ~Modeler( void );   

   //
   // Operator overloads
   //

            /// Assignment operator

            ModelerRef  operator=( ModelerCref );

            /// Equality operator

            bool        operator==( ModelerCref ) const;

   //
   // Accessors
   //
            /**
            Retrieves the count of parents for this identifier
            @param Identifier const reference
            @return Count - the number of parents
            */

            CORELINUX(Count)  getParentCount( DwordIdentifierCref ) const;

            /**
            Retrieves a vector of parents for this identifier
            @param Identifier const reference
            @return IdVector - std::vector of parents
            @exception Exception if id has no parents
            */

            IdVector          getParents( DwordIdentifierCref ) const
                                 throw(CORELINUX(Exception)) ;

   //
   // Mutators
   //
            /**
            Creates a parent relationship
            @param Identifier const reference to child
            @param Identifier const reference to parent
            */

            void  addParent( DwordIdentifierCref, DwordIdentifierCref );

            /**
            Removes a parent relationship
            @param Identifier const reference to child
            @param Identifier const reference to parent
            */
            void  removeParent( DwordIdentifierCref, DwordIdentifierCref );

            /**
            Removes all parent relationships
            @param Identifier const reference to child
            */

            void  removeParents( DwordIdentifierCref );

            /**
            Removes myself from any parent relationships
            @param Identifier const reference to object to dereference
            */

            void  removeChildren( DwordIdentifierCref );

protected:

private:

            IdMap    theParentsMap;    /// The Parent relationship map

};

#endif //   if !defined(__MODELER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.4 $
   $Date: 2000/08/31 22:47:56 $
   $Locker:  $
*/


