/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__SELECTCOLLEAGUE_HPP)
#include <SelectColleague.hpp>
#endif

#if   !defined(__LISTEVENTS_HPP)
#include <ListEvents.hpp>
#endif

#if   !defined(__LISTMEMENTOS_HPP)
#include <ListMementos.hpp>
#endif

using namespace corelinux;

// Constructor

SelectColleague::SelectColleague( ListMediatorPtr aPtr )
   :
   Colleague( MediatorPtr(aPtr) ),
   theCurrentList()
{
   ;  // do nothing
}

// Copy constructor 

SelectColleague::SelectColleague( SelectColleagueCref aColleague )
   :
   Colleague( aColleague ),
   theCurrentList( aColleague.theCurrentList )
{
   ;  // do nothing
}

// Destructor

SelectColleague::~SelectColleague( void )
{
   theCurrentList.clear();
}

// Assignment

SelectColleagueRef  SelectColleague::operator=( SelectColleagueCref aColleague )
{
   if( *this == aColleague )
   {
      ;  // do nothing
   }
   else
   {
      theCurrentList.clear();
      theCurrentList = aColleague.theCurrentList;
   }
   return ( *this );
}

// Equality

bool SelectColleague::operator==( SelectColleagueCref aColleague ) const
{
   return ( this == &aColleague );
}

// Get the events I generate

void  SelectColleague::getEventsGenerated( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &SelectionMade );
}

// Get the events I am interested in

void  SelectColleague::getInterestedEvents( EventIdentifiersRef aVector ) 
{
   aVector.push_back( &ListChanged );
}

// The goods

bool  SelectColleague::getSelection( void )
{
   bool  keepRunning(false);

   if( theCurrentList.size() != 0 )
   {
      keepRunning = true;
      int   x = 1;
      int   select = 0;

      cout  << endl;

      ListEntriesIterator begin=theCurrentList.begin();

      for( ; begin != theCurrentList.end(); ++begin, ++x )
      {
         cout << x << "\t" << (*begin) << endl;
      }

      --x;

      do
      {
         cout << endl;
         cout << "Enter the number for the entry you want to change, or 0 to quit : ";
         cin >> select;
      } while( select < 0 || select > x );

      if( select != 0  )
      {
         char  crap[2];

         cin.getline( crap, sizeof(crap) );  // peel off the new-line

         ListEvent   aEv(  SelectionMade, new SelectionMemento( theCurrentList[select - 1])  );
         Colleague::invokeMediator( (Event<Identifier>*)&aEv );
      }
      else
      {
         keepRunning = false;
      }
      


   }
   return keepRunning;
}

// Called when a event comes my way

void  SelectColleague::action( Event<Identifier> *aEvent ) 
{
   //
   // We deal with the selection and get the Select
   //

   ChangedListMementoRef   aChange = 
      dynamic_cast<ChangedListMementoRef>
         (
            dynamic_cast<ListEventPtr>(aEvent)->getMemento()
         );

   theCurrentList = aChange.getList();

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/07 04:03:02 $
   $Locker:  $
*/


