#if   !defined(__LISTCOLLEAGUE_HPP)
#define __LISTCOLLEAGUE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__COLLEAGUE_HPP)
#include <corelinux/Colleague.hpp>
#endif

#if   !defined(__VECTOR_HPP)
#include <corelinux/Vector.hpp>
#endif

DECLARE_CLASS( ListMediator );
DECLARE_CLASS( ListColleague );

/**
Does anybody read these things? Anyway, ListColleage is
the maintainer of the list, and is interested in changes
made to keep it current
*/

class ListColleague : public CORELINUX( Colleague )
{
   CORELINUX_VECTOR(  string ,  ListEntries );

public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        ListColleague( ListMediatorPtr );   

                        /// Copy constructor

                        ListColleague( ListColleagueCref );

                        /// Virtual destructor

   virtual              ~ListColleague( void );   

   //
   // Operator overloads
   //

            /// Assignment operator

            ListColleagueRef  operator=( ListColleagueCref );

            /// Equality test

            bool operator==( ListColleagueCref ) const;

   //
   // Accessors
   //
            /**
            Implementation defined to return the identifiers
            of the events that this Colleague generates
            @param EventIdentifiers vector reference
            */

   virtual  void  getEventsGenerated( CORELINUX( EventIdentifiersRef ) ) ;

            /**
            Implementation defined to return the identifiers
            of the events that this Colleague is interested in
            @param EventIdentifiers vector reference
            */

   virtual  void  getInterestedEvents( CORELINUX( EventIdentifiersRef ) ) ;

   //
   // Mutators
   //

            /**
            Called once to get the list ready. I'm sure there are more
            imaginitive ways. This is actually a by product of hurried
            example writing, violating many of my own standards. Well,
            my son had a baseball game I had to go to so I cut it
            short!
            */
            
            void  initialize( void );

            /**
            Called by the mediator when another Colleague has
            generated an event that this colleague instance
            is interested in.
            @param Event pointer to event
            */

   virtual  void  action( CORELINUX( Event<corelinux::Identifier> ) * ) ;


protected:

private:

         /// The infamous list

         ListEntries    theList;

};

#endif // if !defined(__LISTCOLLEAGUE_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.2 $
   $Date: 2000/08/31 22:49:01 $
   $Locker:  $
*/


