#ifndef CACHE_COMPONENT_MASTERMMAP_H
#define CACHE_COMPONENT_MASTERMMAP_H

/** @file
 * @author Enrico Zini <enrico@enricozini.org>
 * Master MMapped index component
 */

/*
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <apt-front/cache/component/base.h>
#include <tagcoll/MMapIndex.h>

namespace aptFront {
namespace cache {
namespace component {

class MasterMMap : public Implementation<MasterMMap>, public Tagcoll::MasterMMapIndex
{
public:
	MasterMMap() {}
	MasterMMap(const std::string& fname) : Tagcoll::MasterMMapIndex(fname) {}

	void init(const std::string& fname) { Tagcoll::MasterMMapIndex::init(fname); }
};

}
}
}

// vim:set ts=4 sw=4:
#endif
