#!/usr/bin/perl
#
# This script tracks the general mood in a channel.
# 
#
# Changelog:
# 19.03.2002
# *first release
#
# 20.03.2002
# *some regexp tweaking

use strict;

use vars qw($VERSION %IRSSI);

$VERSION = "20020321-5";
%IRSSI = (
        authors     => "Stefan 'tommie' Tomanek",
	contact     => "stefan\@pico.ruhr.de",
	name        => "mood",
	description => "Keeps track of the channel mood",
	license     => "GPLv2",
	url         => "",
	changed     => "$VERSION",
);

use Irssi;
use vars qw(%channels $eye $refresh);

sub find_smiley {
	my ($msg) = @_;
	my $eyes = '[:=8;]';
	my $noses = '[\-\o]?';
	my $sad = '[\(\<\[]';
	my $happy = '[\)\>\]D]';
	my %smiley = ($eyes.$noses.$happy         =>  10,
	              $sad.$noses.$eyes           =>  10,
                      $eyes.$noses.$sad           => -10,
		      $happy.$noses.$eyes         => -10,
		      $eyes.'\.+'.$noses.$sad     => -20,
		      $happy.$noses.'\.+'.$eyes   => -20,
		     );
	foreach (keys(%smiley)) {
		if ($msg =~ m/.*($_).*/) {
			return $smiley{$_};
		}
	}
	return 0;
}

sub event_event_privmsg {
	my ($server, $data, $nick, $address) = @_;
	my ($target, $msg) = split(/ :/, $data,2);
	change_mood($target, find_smiley($msg));
}

sub event_message_kick {
	my ($server, $channel, $nick, $kicker, $address, $reason) = @_;
	change_mood($channel, -20);
}

sub event_ban_new {
	my ($channel, $ban) = @_;
	my $name = $channel->{name};
	change_mood($name, -20);
}

sub event_ban_remove {
	my ($channel, $ban) = @_;
	my $name = $channel->{name};
	change_mood($name, 20);
}

sub event_netsplit_new {
	my ($netsplit) = @_;
	#FIXME Not Idea :)
	#Irssi::print $netsplit->{nick};
}

sub change_mood {
	my ($name, $points) = @_;
	if (not exists $channels{$name}) {
		$channels{$name} = 0;
	}
	$channels{$name} += $points;
	mood_refresh();
}

sub draw_smiley {
	my ($points) = @_;
	my $mouth = '/';
	my $nose = Irssi::settings_get_str('mood_nose');
	
	if    ($points > 20) { $mouth = 'D'; }
	elsif ($points >  0) { $mouth = ')'; }
	elsif ($points <-20) { $mouth = '<'; }
	elsif ($points <  0) { $mouth = '('; }
	return $eye.$nose.$mouth;
}

sub mood_show {
	my ($item, $get_size_only) = @_;
	my $win = Irssi::active_win()->{active};
	my $target = $win->{name};
	
	if (($win->{type}) and $win->{type} eq "CHANNEL") {
		my $format = "{sb ".draw_smiley($channels{$target})."}";
		$item->{min_size} = $item->{max_size} = 5;
		$item->default_handler($get_size_only, $format, 0, 1);
	}
}

sub mood_decay {
	my $cur_chan = Irssi::active_win()->{active}->{name};
	foreach (keys %channels) {
		if    ($channels{$_} < 0) {
			$channels{$_}++;
			mood_refresh() if (! draw_smiley($channels{$_}) eq draw_smiley($channels{$_}-1));
		} elsif ($channels{$_} > 0) {
			$channels{$_}--;
			mood_refresh() if (! draw_smiley($channels{$_}) eq draw_smiley($channels{$_}+1));
		}
	}
}

sub close_eyes {
	($refresh) && Irssi::timeout_remove($refresh);
	$eye = '|';
	mood_refresh();
	$refresh=Irssi::timeout_add(200, 'open_eyes' , undef);
}

sub open_eyes {
	($refresh) && Irssi::timeout_remove($refresh);
	$eye = ':';
	mood_refresh();
	my $min_delay = Irssi::settings_get_int('mood_blink');
	my $min_delay = 6000;
	my $next_close = int( rand()*6000 + $min_delay );
	$refresh=Irssi::timeout_add($next_close, 'close_eyes', undef);
}

sub mood_refresh {
	Irssi::statusbar_items_redraw('mood_bar');
}

Irssi::signal_add('event privmsg', 'event_event_privmsg');
Irssi::signal_add('message kick','event_message_kick');
Irssi::signal_add('ban new','event_ban_new');
Irssi::signal_add('ban remove','event_ban_remove');
Irssi::signal_add('netsplit new','event_netsplit_new');

Irssi::settings_add_int('misc', 'mood_blink', 6000);
Irssi::settings_add_str('misc', 'mood_nose', '-');

Irssi::statusbar_item_register('mood_bar', 0, 'mood_show');

Irssi::timeout_add(5000, 'mood_decay', undef);

open_eyes();
