% Build instructions
% [Guilhem Moulin](mailto:guilhem@fripost.org)

On Debian 10 (codename *Buster*) and later, installing [`interimap`(1)]
is a single command away:

    $ sudo apt install interimap

This document is for those who are running other systems, and/or who
wish to install from [source](https://git.guilhem.org/interimap).


Dependencies
============

[`interimap`(1)](interimap.1.html) depends on Perl ≥5.20 and the
following Perl modules:

  * [`Compress::Raw::Zlib`](https://perldoc.perl.org/Compress/Raw/Zlib.html) (*core module*)
  * [`Config::Tiny`](https://metacpan.org/pod/Config::Tiny)
  * [`DBI`](https://metacpan.org/pod/DBI)
  * [`DBD::SQLite`](https://metacpan.org/pod/DBD::SQLite)
  * [`Errno`](https://perldoc.perl.org/Errno.html) (*core module*)
  * [`Getopt::Long`](https://perldoc.perl.org/Getopt/Long.html) (*core module*)
  * [`MIME::Base64`](https://perldoc.perl.org/MIME/Base64.html) (*core module*) — if authentication is required
  * [`List::Util`](https://perldoc.perl.org/List/Util.html) (*core module*)
  * [`Net::SSLeay`](https://metacpan.org/pod/Net::SSLeay) ≥1.86_06
  * [`POSIX`](https://perldoc.perl.org/POSIX.html) (*core module*)
  * [`Socket`](https://perldoc.perl.org/Socket.html) (*core module*)
  * [`Time::HiRes`](https://perldoc.perl.org/Time/HiRes.html) (*core module*) — if `logfile` is set

On Debian GNU/Linux systems, the dependencies can be installed with the
following command:

    $ sudo apt install libconfig-tiny-perl libdbd-sqlite3-perl libnet-ssleay-perl

Additional packages are required in order to run the test suite:

    $ sudo apt install dovecot-imapd dovecot-lmtpd openssl procps sqlite3 xxd
<!-- -->
    $ make test

(The test suite also needs to bind to TCP ports 10024, 10143 and 10993
on the loopback interface.)

Generate documentation
======================

Yet another set of packages is needed to generate the documentation:

    $ sudo apt install jq pandoc

Run `` `make manual` `` (or just `` `make` ``) in order to generate the
manpages.  You'll find them at `doc/*.[1-9]`.  Use for instance `` `man
-l doc/interimap.1` `` in order to read your copy of the [`interimap`(1)]
manpage.

The HTML documentation can be built with `` `make html` ``.  HTML files
are generated alongside their Markdown source by default, but you can
choose another target directory using the `HTML_ROOTDIR` environment
variable (the value of which defaults to `./doc`).  Moreover the
[`libjs-bootstrap`](https://tracker.debian.org/libjs-bootstrap) is
needed by default for the local CSS file; this can be controlled with
the `CSS` environment variable (the value of which defaults to
`/usr/share/javascript/bootstrap/css/bootstrap.min.css`).

For instance, use

    $ env CSS="https://guilhem.org/static/css/bootstrap.min.css" \
		HTML_ROOTDIR="$XDG_RUNTIME_DIR/interimap" \
		make html

to generate the HTML documentation under directory `$XDG_RUNTIME_DIR/interimap`
(which needs to exist) using a remote CSS file.

The `doc` target generates all documentation, manpages as well as HTML
pages.


Build custom Debian packages
============================

Debian GNU/Linux users can also use [`gbp`(1)] from
[`git-buildpackage`](https://tracker.debian.org/pkg/git-buildpackage) in
order to build their own packages:

    $ git checkout debian/latest
    $ gbp buildpackage

Alternatively, for the development version:

    $ git checkout debian/latest
    $ git merge master
    $ gbp buildpackage --git-force-create --git-upstream-tree=BRANCH


[`interimap`(1)]: interimap.1.html
[`gbp`(1)]: https://manpages.debian.org/git-buildpackage/gbp.1.en.html
