<?php
/*
 * $Horde: imp/lib/MIME/Viewer/images.php,v 1.6.2.6 2003/01/03 13:23:13 jan Exp $
 *
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

require_once HORDE_BASE . '/lib/MIME/Viewer/images.php';

/**
 * The IMP_MIME_Viewer_images class allows images to be displayed
 * inline in a message.
 *
 * @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
 * @version $Revision: 1.6.2.6 $
 * @since   IMP 3.2
 * @package horde.mime.viewer
 */
class IMP_MIME_Viewer_images extends MIME_Viewer_images {

    /**
     * Render out the currently set contents.
     * The $mime_part class variable has the information to render
     * out, encapsulated in a MIME_Part object.
     */
    function render(&$mime)
    {
        global $imp;

        if (stristr($_SERVER['PHP_SELF'], 'view.php')) {
            return parent::render($mime);
        }

        /* If render() is called outside of view.php, we need to generate
           an image tag to view.php. */
        $subpart = $this->mime_part->subtype;

        /* These are extensions that IE/Mozilla support. */
        if ($subpart == 'jpeg' || $subpart == 'gif' ||
            $subpart == 'png' || $subpart == 'pjpeg' ||
            $subpart == 'x-png' || $subpart == 'bmp' ||
            $subpart == 'tiff') {
            $alt = $this->mime_part->name;
            if (empty($alt)) {
                $alt = $this->mime_part->description;
            }
            return '<img src="view.php?actionID=' . VIEW_ATTACH . '&index=' . $mime->index . '&mailbox=' . urlencode($imp['mailbox']) . '&id=' . $mime->imap_id . '" border="0" alt="' . $alt . '" title="' . $alt . '" />';
        } else {
            return '<i>' . _("Your browser does not support inline display of this image type") . '</i>.';
        }
    }

    /**
     * Return the content-type
     *
     * @return string  The content-type of the output.
     */
    function getType()
    {
        if (stristr($_SERVER['SCRIPT_NAME'], 'view.php')) {
            return parent::getType();
        } else {
            return 'text/html';
        }
    }

}
