/***********************************************************************/
/* Open Visualization Data Explorer                                    */
/* (C) Copyright IBM Corp. 1989,1999                                   */
/* ALL RIGHTS RESERVED                                                 */
/* This code licensed under the                                        */
/*    "IBM PUBLIC LICENSE - Open Visualization Data Explorer"          */
/***********************************************************************/

#ifndef _EWDefaultResources_h
#define _EWDefaultResources_h

#if !defined(DX_NEW_KEYLAYOUT)

String EditorWindow::DefaultResources[] =
{
    ".title:                                      Visual Program Editor",
    ".iconName:                                   VPE",
    ".minWidth:                                   480",
    ".minHeight:                                  400",
    "*workArea.width:                             850",
    "*workArea.height:                            650",				
    "*notebook.width:				  180",
    "*scrolledWindow*XmScrollBar.initialDelay:    2000",
    "*scrolledWindow*XmScrollBar.repeatDelay:     2000",

    "*fileMenu.labelString:                       File",
    "*fileMenu.mnemonic:                          F",
    "*vpeNewOption.labelString:                   New",
    "*vpeNewOption.mnemonic:                      N",
    "*vpeOpenOption.labelString:                  Open Program...",
    "*vpeOpenOption.mnemonic:                     O",
    "*vpeSaveOption.labelString:                  Save Program",
    "*vpeSaveOption.mnemonic:                     S",
    "*vpeSaveOption.accelerator:                  Ctrl<Key>S",
    "*vpeSaveOption.acceleratorText:              Ctrl+S",
    "*vpeSaveMacroOption.labelString:                  Save Macro",
    "*vpeSaveMacroOption.mnemonic:                     S",
    "*vpeSaveMacroOption.accelerator:                  Ctrl<Key>S",
    "*vpeSaveMacroOption.acceleratorText:              Ctrl+S",
    "*vpeSaveAsOption.labelString:                Save Program As...",
    "*vpeSaveMacroAsOption.labelString:                Save Macro As...",
    "*vpeSettingsCascade.labelString: 		  Program Settings",
    "*vpeSettingsCascade.mnemonic: 		  r",
    "*vpeSaveCfgOption.labelString:               Save As...",
    "*vpeSaveCfgOption.mnemonic:                  S",
    "*vpeOpenCfgOption.labelString:               Load...",
    "*vpeOpenCfgOption.mnemonic:                  L",
    "*vpeSaveAsOption.mnemonic:                   a",
    "*vpePrintProgramOption.labelString:          Print Program...",
    "*vpePrintProgramOption.mnemonic:             P",
    "*vpeLoadMDFOption.labelString:              Load Module Description(s)...",
    "*vpeLoadMDFOption.mnemonic:                  M",
    "*vpeLoadMacroOption.labelString:             Load Macro...",
    "*vpeLoadMacroOption.mnemonic:                L",
#ifdef DXUI_DEVKIT
    "*vpeSaveAsCCodeOption.labelString:           Save As C Code...",
    "*vpeSaveAsCCodeOption.mnemonic:              v",
#endif /* DXUI_DEVKIT */ 
    "*vpeCloseOption.labelString:                 Close",
    "*vpeCloseOption.mnemonic:                    C",
    "*vpeCloseOption.accelerator:                 Ctrl<Key>Q",
    "*vpeCloseOption.acceleratorText:             Ctrl+Q",

    "*editMenu.labelString:                       Edit",
    "*editMenu.mnemonic:                          E",
    "*vpeUndoOption.labelString:                  Undo",
    "*vpeUndoOption.accelerator:                  Ctrl<Key>U",
    "*vpeUndoOption.acceleratorText:              Ctrl+U",
    "*vpeValuesOption.labelString:                Configuration...",
    "*vpeValuesOption.mnemonic:                   C",
    "*vpeValuesOption.accelerator:                Ctrl<Key>F",
    "*vpeValuesOption.acceleratorText:            Ctrl+F",
    "*vpeFindToolOption.labelString:              Find Tool...",
    "*vpeFindToolOption.mnemonic:                 F",
    "*vpeEditTabsCascade.labelString: 		  Input/Output Tabs",
    "*vpeEditTabsCascade.mnemonic: 		  T",
    "*vpeAddInputTabOption.labelString:              Add Input Tab",
    "*vpeAddInputTabOption.mnemonic:                 A",
    "*vpeAddInputTabOption.accelerator:              Ctrl<Key>A",
    "*vpeAddInputTabOption.acceleratorText:          Ctrl+A",
    "*vpeRemoveInputTabOption.labelString:           Remove Input Tab",
    "*vpeRemoveInputTabOption.mnemonic:              R",
    "*vpeRemoveInputTabOption.accelerator:           Ctrl<Key>R",
    "*vpeRemoveInputTabOption.acceleratorText:       Ctrl+R",
    "*vpeAddOutputTabOption.labelString:             Add Output Tab",
    "*vpeAddOutputTabOption.mnemonic:                O",
    "*vpeRemoveOutputTabOption.labelString:          Remove Output Tab",
    "*vpeRemoveOutputTabOption.mnemonic:             T",
    "*vpeHideAllTabsOption.labelString:              Hide All Tabs",
    "*vpeHideAllTabsOption.mnemonic:                 H",
    "*vpeHideAllTabsOption.accelerator:              Ctrl<Key>H",
    "*vpeHideAllTabsOption.acceleratorText:          Ctrl+H",
    "*vpeRevealAllTabsOption.labelString:            Reveal All Tabs",
    "*vpeRevealAllTabsOption.mnemonic:               L",
    "*vpeRevealAllTabsOption.accelerator:            Ctrl<Key>L",
    "*vpeRevealAllTabsOption.acceleratorText:        Ctrl+L",
    "*vpeEditSelectCascade.labelString:		  Select/Deselect Tools",
    "*vpeEditSelectCascade.mnemonic:		  S",

#ifndef FORGET_GETSET 
    "*programVerifyCascade.labelString:		  Assign Get/Set Scope",
    "*programVerifyCascade.mnemonic:		  V",
    "*getSetConversion.labelString:		  Convert All Modules...",
    "*getSetConversion.mnemonic:		  C",
    "*setToGlobal.labelString:		     	  Set Selected Gets/Sets Global",
    "*setToGlobal.mnemonic:		     	  G",
    "*setToLocal.labelString:		          Set Selected Gets/Sets Local",
    "*setToLocal.mnemonic:		       	  L",
#endif

    "*vpeSelectAllOption.labelString:                Select All",
    "*vpeSelectAllOption.mnemonic:                   S",
    "*vpeSelectConnectedOption.labelString:          Select Connected",
    "*vpeSelectConnectedOption.mnemonic:             C",
    "*vpeSelectUnconnectedOption.labelString:        Select Unconnected",
    "*vpeSelectUnconnectedOption.mnemonic:           U",
    "*vpeSelectUpwardOption.labelString:             Select Upward",
    "*vpeSelectUpwardOption.mnemonic:                p",
    "*vpeSelectDownwardOption.labelString:           Select Downward",
    "*vpeSelectDownwardOption.mnemonic:              D",
    "*vpeDeselectAllOption.labelString:              Deselect All",
    "*vpeDeselectAllOption.mnemonic:                 e",
    "*vpeSelectUnselectedOption.labelString:         Select Unselected",
    "*vpeSelectUnselectedOption.mnemonic:            n",

    "*vpeOutputCacheabilityCascade.labelString:      Output Cacheability",
    "*vpeOutputCacheabilityCascade.mnemonic:         u",
    "*vpeOptimizeCacheability.labelString:           Optimize Cacheability",
    "*vpeOptimizeCacheability.mnemonic:              O",
    "*vpeEditOutputCacheabilityCascade.labelString:  Set Output Cacheability",
    "*vpeEditOutputCacheabilityCascade.mnemonic:     S",
    "*vpeCacheAllOutputsOption.labelString:          Cache All Results",
    "*vpeCacheAllOutputsOption.mnemonic:             A",
    "*vpeCacheLastOutputsOption.labelString:         Cache Last Result",
    "*vpeCacheLastOutputsOption.mnemonic:            L",
    "*vpeCacheNoOutputsOption.labelString:           Cache No Results",
    "*vpeCacheNoOutputsOption.mnemonic:              N",
    "*vpeShowOutputCacheabilityCascade.labelString:  Show Output Cacheability",
    "*vpeShowOutputCacheabilityCascade.mnemonic:     h", 
    "*vpeShowCacheAllOutputsOption.labelString:      All Results",
    "*vpeShowCacheAllOutputsOption.mnemonic:         A",
    "*vpeShowCacheLastOutputsOption.labelString:     Last Result",
    "*vpeShowCacheLastOutputsOption.mnemonic:        L",
    "*vpeShowCacheNoOutputsOption.labelString:       No Results",
    "*vpeShowCacheNoOutputsOption.mnemonic:          N",

    "*vpeCutOption.labelString:                      Cut",
    "*vpeCutOption.mnemonic:                         t",
    "*vpeCutOption.acceleratorText:                  Delete",
    "*vpeCutOption.accelerator:                      <Key>osfDelete",

    "*vpeCopyOption.labelString:                     Copy",
    "*vpeCopyOption.mnemonic:                        p",
    "*vpeCopyOption.acceleratorText:                 Shift+Delete",
    "*vpeCopyOption.accelerator:                     Shift<Key>osfDelete",

    "*vpePasteOption.labelString:                    Paste",
    "*vpePasteOption.mnemonic:                       e",
    "*vpePasteOption.acceleratorText:                Shift+Ins",
    "*vpePasteOption.accelerator:                    Shift<Key>osfInsert",

    "*vpeDeleteOption.labelString:                   Delete",
    "*vpeDeleteOption.mnemonic:                      D",
    "*vpeDeleteOption.acceleratorText:               Ctrl+Delete",
    "*vpeDeleteOption.accelerator:                   Ctrl<Key>osfDelete",

#ifdef aviion
    "*vpeCutOption.accelerator:                      <Key>Delete",
    "*vpeCopyOption.accelerator:                     Shift<Key>Delete",
    "*vpePasteOption.accelerator:                    Shift<Key>Insert",
    "*vpeDeleteOption.accelerator:                   Ctrl<Key>Delete",
#endif

    "*vpeAddDecorator.labelString:                Add Annotation",
    "*vpeAddDecorator.mnemonic:                   T",

    "*vpeInsertNetOption.labelString:             Insert Visual Program...",
    "*vpeInsertNetOption.mnemonic:                I",
    "*vpeCreateMacroOption.labelString:           Create Macro...",
    "*vpeCreateMacroOption.mnemonic:              M",
    "*vpePageCascade.labelString:                 Page",
    "*vpeCreatePageOption.labelString:            Create Empty Page",
    "*vpeCreatePageOption.mnemonic:               E",
    "*vpeSelectedPageOption.labelString:          Create with Selected Tools",
    "*vpeSelectedPageOption.mnemonic:             C",
    "*vpeMoveToPageOption.labelString:            Move Selected Tools...",
    "*vpeMoveToPageOption.mnemonic:               M",
    "*vpeChopPageOption.labelString:          	  Separate Selected Tools",
    "*vpeChopPageOption.mnemonic:          	  S",
    "*vpeFusePageOption.labelString:          	  Reconnect Selected Tools",
    "*vpeFusePageOption.mnemonic:          	  R",
    "*vpeDeletePageOption.labelString:            Delete Page",
    "*vpeDeletePageOption.mnemonic:               D",
    "*vpeConfigurePageOption.labelString:         Configure Page...",
    "*vpeConfigurePageOption.mnemonic:            f",
    "*vpeJavaCascade.labelString:                 Java",
    "*vpeJavifyNetOption.labelString:             Add Tools",
    "*vpeUnjavifyNetOption.labelString:           Remove Tools",
    "*vpeSaveWebPageOption.labelString:           Save As Web Page",
    "*vpeSaveAppletOption.labelString:            Net to Applet",
    "*vpeSaveBeanOption.labelString:              Net to Bean",
    "*vpeReflowGraphOption.labelString:           Layout Graph",
    "*vpeReflowGraphOption.mnemonic:              u",
    "*vpeReflowGraphOption.accelerator:           Ctrl<Key>K",
    "*vpeReflowGraphOption.acceleratorText:       Ctrl+K",
    "*vpeStraightenArcsOption.labelString:        Tidy Up the Arcs",
    "*vpeStraightenArcsOption.mnemonic:           y",
    "*vpeMacroNameOption.labelString:             Macro Name...",
    "*vpeMacroNameOption.mnemonic:                N",
    "*vpeCreateProcessGroupOption.labelString:    Execution Groups...",
    "*vpeCreateProcessGroupOption.mnemonic:       G",
    "*vpeCommentOption.labelString:               Comment...",
    "*vpeCommentOption.mnemonic:                  o",

    "*windowsMenu.labelString:                    Windows",
    "*windowsMenu.mnemonic:                       W",
    "*vpeNewControlPanelOption.labelString:        New Control Panel",
    "*vpeNewControlPanelOption.mnemonic:           P",
    "*vpeOpenControlPanelOption.labelString:  Open Selected Control Panel(s)",
    "*vpeOpenControlPanelOption.mnemonic:          S",
    "*vpeOpenAllControlPanelsOption.labelString:   Open All Control Panels",
    "*vpeOpenAllControlPanelsOption.mnemonic:      A",
    "*vpeOpenAllControlPanelsOption.accelerator:   Ctrl<Key>P",
    "*vpeOpenAllControlPanelsOption.acceleratorText: Ctrl+P",
    "*vpePanelCascade.labelString:                 Open Control Panel by Name",
    "*vpePanelCascade.mnemonic:                    N",
    "*vpePanelGroupCascade.labelString:            Open Control Panel by Group",
    "*vpePanelGroupCascade.mnemonic:               G",
    "*vpeOpenMacroOption.labelString:              Open Selected Macro(s)",
    "*vpeOpenMacroOption.mnemonic:                 M",
    "*vpeOpenImageOption.labelString:             Open Selected Image Window(s)",
    "*vpeOpenImageOption.mnemonic:                 I",
    "*vpeOpenColormapEditorOption.labelString:Open Selected Colormap Editor(s)",
    "*vpeOpenColormapEditorOption.mnemonic:        C",
    "*vpeOpenColormapEditorOption.accelerator:     Ctrl<Key>E",
    "*vpeOpenColormapEditorOption.acceleratorText: Ctrl+E",
    "*vpeMessageWindowOption.labelString:          Open Message Window",
    "*vpeMessageWindowOption.mnemonic:             e",

    "*optionsMenu.labelString:                    Options",
    "*optionsMenu.mnemonic:                       O",
    "*vpeToolPalettesOption.labelString:          Tool Palettes",
    "*vpeToolPalettesOption.mnemonic:             T",
    "*vpeToolPalettesOption.accelerator:          Ctrl<Key>T",
    "*vpeToolPalettesOption.acceleratorText:      Ctrl+T",
    "*vpeHitDetectionOption.labelString:          Prevent Overlap",
    "*vpeHitDetectionOption.mnemonic:             v",
    "*vpeHitDetectionOption.accelerator:          Ctrl<Key>V",
    "*vpeHitDetectionOption.acceleratorText:      Ctrl+V",
    "*vpePanelAccessOption.labelString:           Control Panel Access...",
    "*vpePanelAccessOption.mnemonic:              A",
    "*vpePanelGroupOption.labelString:            Control Panel Groups...",
    "*vpePanelGroupOption.mnemonic:               P",
    "*vpeShowExecutedOption.labelString:	  Select Executed",
    "*vpeShowExecutedOption.mnemonic:		  S",
    "*vpeGridOption.labelString:                  Grid...",
    "*vpeGridOption.mnemonic:                     G",

    "*fileMenuPulldown.tearOffModel:		  XmTEAR_OFF_DISABLED",
    "*editMenuPulldown.tearOffModel:		  XmTEAR_OFF_DISABLED",
    "*windowsMenuPulldown.tearOffModel:		  XmTEAR_OFF_DISABLED",

    "*vpeOnVisualProgramOption.labelString:       Application Comment...",
    "*vpeOnVisualProgramOption.mnemonic:          A",
#if (XmVersion > 1001)
    "*workAreaFrame*traversalOn:                  false",
    "*workAreaFrame*XmWorkspace*traversalOn:      true",
#endif
    ".mainWindow.commandWindowLocation: XmCOMMAND_ABOVE_WORKSPACE",
    ".mainWindow.packing: 		XmPACK_NONE",
    NULL
};

#else /* defined(DX_NEW_KEYLAYOUT) */

String EditorWindow::DefaultResources[] =
{
    ".title:                                      	Visual Program Editor",
    ".iconName:                                   	VPE",
    ".minWidth:                                   	480",
    ".minHeight:                                  	400",
    "*workArea.width:                             	850",
    "*workArea.height:                            	650",
    "*notebook.width:				  	180",
    "*scrolledWindow*XmScrollBar.initialDelay:    	2000",
    "*scrolledWindow*XmScrollBar.repeatDelay:     	2000",

    "*fileMenu.labelString:                       	File",
    "*fileMenu.mnemonic:                          	F",
    "*vpeNewOption.labelString:                   	New",
    "*vpeNewOption.mnemonic:                      	N",
    "*vpeNewOption.accelerator:				Ctrl <Key>N",
    "*vpeNewOption.acceleratorText:			Ctrl+N",
    "*vpeOpenOption.labelString:                  	Open Program...",
    "*vpeOpenOption.mnemonic:                     	O",
    "*vpeOpenOption.accelerator:			Ctrl <Key>O",
    "*vpeOpenOption.acceleratorText:			Ctrl+O",
    "*vpeSaveOption.labelString:                  	Save Program",
    "*vpeSaveOption.mnemonic:                     	S",
    "*vpeSaveOption.accelerator:                  	Ctrl<Key>S",
    "*vpeSaveOption.acceleratorText:              	Ctrl+S",
    "*vpeSaveMacroOption.labelString:			Save Macro",
    "*vpeSaveMacroOption.mnemonic:			S",
    "*vpeSaveMacroOption.accelerator:			Ctrl<Key>S",
    "*vpeSaveMacroOption.acceleratorText:		Ctrl+S",
    "*vpeSaveAsOption.labelString:                	Save Program As...",
    "*vpeSaveAsOption.mnemonic:				A",
    "*vpeSaveAsOption.accelerator:			Ctrl Shift <Key>S",
    "*vpeSaveAsOption.acceleratorText:			Ctrl+Shift+S",
    "*vpeSaveMacroAsOption.labelString:                	Save Macro As...",
    "*vpeSaveMacroAsOption.mnemonic:			A",
    "*vpeSaveMacroAsOption.accelerator:			Ctrl Shift <Key>S",
    "*vpeSaveMacroAsOption.acceleratorText:		Ctrl+Shift+S",
    "*vpeSettingsCascade.labelString: 		  	Program Settings",
    "*vpeSettingsCascade.mnemonic: 		  	r",
    "*vpeSaveCfgOption.labelString:               	Save As...",
    "*vpeSaveCfgOption.mnemonic:                  	S",
    "*vpeOpenCfgOption.labelString:               	Load...",
    "*vpeOpenCfgOption.mnemonic:                  	L",
    "*vpePrintProgramOption.labelString:          	Print Program...",
    "*vpePrintProgramOption.mnemonic:             	P",
    "*vpePrintProgramOption.accelerator:		Ctrl <Key>P",
    "*vpePrintProgramOption.acceleratorText:		Ctrl+P",
    "*vpeLoadMDFOption.labelString:              	Load Module Description(s)...",
    "*vpeLoadMDFOption.mnemonic:                  	M",
    "*vpeLoadMacroOption.labelString:             	Load Macro...",
    "*vpeLoadMacroOption.mnemonic:                	L",
#ifdef DXUI_DEVKIT
    "*vpeSaveAsCCodeOption.labelString:           Save As C Code...",
    "*vpeSaveAsCCodeOption.mnemonic:              v",
#endif // DXUI_DEVKIT
    "*vpeCloseOption.labelString:                 	Close",
    "*vpeCloseOption.mnemonic:                    	C",
    "*vpeCloseOption.accelerator:                 	Ctrl <Key>W",
    "*vpeCloseOption.acceleratorText:             	Ctrl+W",

    "*editMenu.labelString:                       	Edit",
    "*editMenu.mnemonic:                          	E",
    "*vpeUndoOption.labelString:                  	Undo",
    "*vpeUndoOption.accelerator:                  	Ctrl<Key>Z",
    "*vpeUndoOption.acceleratorText:              	Ctrl+Z",
    "*vpeValuesOption.labelString:                	Configuration...",
    "*vpeValuesOption.mnemonic:                   	R",
    "*vpeValuesOption.accelerator:                	Ctrl <Key>F",
    "*vpeValuesOption.acceleratorText:            	Ctrl+F",
    "*vpeFindToolOption.labelString:              	Find Tool...",
    "*vpeFindToolOption.mnemonic:                 	F",
    "*vpeEditTabsCascade.labelString: 		  	Input/Output Tabs",
    "*vpeEditTabsCascade.mnemonic: 		  	B",
    "*vpeAddInputTabOption.labelString:              	Add Input Tab",
    "*vpeAddInputTabOption.mnemonic:                 	A",
    "*vpeAddInputTabOption.accelerator:              	Ctrl <Key>A",
    "*vpeAddInputTabOption.acceleratorText:          	Ctrl+A",
    "*vpeRemoveInputTabOption.labelString:           	Remove Input Tab",
    "*vpeRemoveInputTabOption.mnemonic:              	R",
    "*vpeRemoveInputTabOption.accelerator:           	Ctrl <Key>R",
    "*vpeRemoveInputTabOption.acceleratorText:       	Ctrl+R",
    "*vpeAddOutputTabOption.labelString:             	Add Output Tab",
    "*vpeAddOutputTabOption.mnemonic:                	O",
    "*vpeRemoveOutputTabOption.labelString:          	Remove Output Tab",
    "*vpeRemoveOutputTabOption.mnemonic:             	T",
    "*vpeHideAllTabsOption.labelString:              	Hide All Tabs",
    "*vpeHideAllTabsOption.mnemonic:                 	H",
    "*vpeHideAllTabsOption.accelerator:              	Ctrl <Key>H",
    "*vpeHideAllTabsOption.acceleratorText:          	Ctrl+H",
    "*vpeRevealAllTabsOption.labelString:            	Reveal All Tabs",
    "*vpeRevealAllTabsOption.mnemonic:               	L",
    "*vpeRevealAllTabsOption.accelerator:            	Ctrl <Key>L",
    "*vpeRevealAllTabsOption.acceleratorText:        	Ctrl+L",
    "*vpeEditSelectCascade.labelString:		  	Select/Deselect Tools",
    "*vpeEditSelectCascade.mnemonic:		  	S",

#ifndef FORGET_GETSET
    "*programVerifyCascade.labelString:		  Assign Get/Set Scope",
    "*programVerifyCascade.mnemonic:		  V",
    "*getSetConversion.labelString:		  Convert All Modules...",
    "*getSetConversion.mnemonic:		  C",
    "*setToGlobal.labelString:		     	  Set Selected Gets/Sets Global",
    "*setToGlobal.mnemonic:		     	  G",
    "*setToLocal.labelString:		          Set Selected Gets/Sets Local",
    "*setToLocal.mnemonic:		       	  L",
#endif

    "*vpeSelectAllOption.labelString:                	Select All",
    "*vpeSelectAllOption.mnemonic:                   	S",
    "*vpeSelectAllOption.accelerator:			Ctrl Shift <Key>A",
    "*vpeSelectAllOption.acceleratorText:		Ctrl+Shift+A",
    "*vpeSelectConnectedOption.labelString:          	Select Connected",
    "*vpeSelectConnectedOption.mnemonic:             	C",
    "*vpeSelectUnconnectedOption.labelString:        	Select Unconnected",
    "*vpeSelectUnconnectedOption.mnemonic:           	U",
    "*vpeSelectUpwardOption.labelString:             	Select Upward",
    "*vpeSelectUpwardOption.mnemonic:                	P",
    "*vpeSelectDownwardOption.labelString:           	Select Downward",
    "*vpeSelectDownwardOption.mnemonic:              	D",
    "*vpeDeselectAllOption.labelString:              	Deselect All",
    "*vpeDeselectAllOption.mnemonic:                 	E",
    "*vpeDeselectAllOption.accelerator:			Ctrl Shift <Key>D",
    "*vpeDeselectAllOption.acceleratorText:		Ctrl+Shift+D",
    "*vpeSelectUnselectedOption.labelString:         	Select Unselected",
    "*vpeSelectUnselectedOption.mnemonic:            	N",
    "*vpeShowExecutedOption.labelString:	  	Select Executed",
    "*vpeShowExecutedOption.mnemonic:		  	X",

    "*vpeOutputCacheabilityCascade.labelString:      	Output Cacheability",
    "*vpeOutputCacheabilityCascade.mnemonic:         	y",
    "*vpeOptimizeCacheability.labelString:           	Optimize Cacheability",
    "*vpeOptimizeCacheability.mnemonic:              	O",
    "*vpeEditOutputCacheabilityCascade.labelString:  	Set Output Cacheability",
    "*vpeEditOutputCacheabilityCascade.mnemonic:     	S",
    "*vpeCacheAllOutputsOption.labelString:          	Cache All Results",
    "*vpeCacheAllOutputsOption.mnemonic:             	A",
    "*vpeCacheLastOutputsOption.labelString:         	Cache Last Result",
    "*vpeCacheLastOutputsOption.mnemonic:            	L",
    "*vpeCacheNoOutputsOption.labelString:           	Cache No Results",
    "*vpeCacheNoOutputsOption.mnemonic:              	N",
    "*vpeShowOutputCacheabilityCascade.labelString:  	Show Output Cacheability",
    "*vpeShowOutputCacheabilityCascade.mnemonic:     	h", 
    "*vpeShowCacheAllOutputsOption.labelString:      	All Results",
    "*vpeShowCacheAllOutputsOption.mnemonic:         	A",
    "*vpeShowCacheLastOutputsOption.labelString:     	Last Result",
    "*vpeShowCacheLastOutputsOption.mnemonic:        	L",
    "*vpeShowCacheNoOutputsOption.labelString:       	No Results",
    "*vpeShowCacheNoOutputsOption.mnemonic:          	N",

    "*vpeCutOption.labelString:                      	Cut",
    "*vpeCutOption.mnemonic:                         	T",
    "*vpeCutOption.acceleratorText:                  	Ctrl+X",
    "*vpeCutOption.accelerator:                      	Ctrl <Key>X",

    "*vpeCopyOption.labelString:                     	Copy",
    "*vpeCopyOption.mnemonic:                        	C",
    "*vpeCopyOption.acceleratorText:                 	Ctrl+C",
    "*vpeCopyOption.accelerator:                     	Ctrl <Key>C",

    "*vpePasteOption.labelString:                    	Paste",
    "*vpePasteOption.mnemonic:                       	P",
    "*vpePasteOption.acceleratorText:                	Ctrl+V",
    "*vpePasteOption.accelerator:                    	Ctrl <Key>V",

    "*vpeDeleteOption.labelString:                   	Delete",
    "*vpeDeleteOption.mnemonic:                      	D",
#if defined(intelnt)
    "*vpeDeleteOption.acceleratorText:			Ctrl+Backspace",
#else
    "*vpeDeleteOption.acceleratorText:               	Ctrl+Delete",
#endif
#if defined(macos) || defined(intelnt)
    "*vpeDeleteOption.accelerator:                   	Ctrl<Key>BackSpace",
#elif defined(aviion)
    "*vpeDeleteOption.accelerator:			Ctrl<Key>Delete",
#else
    "*vpeDeleteOption.accelerator:                   	Ctrl<Key>osfDelete",
#endif

    "*vpeAddDecorator.labelString:                	Add Annotation",
    "*vpeAddDecorator.mnemonic:                   	A",

    "*vpeInsertNetOption.labelString:             	Insert Visual Program...",
    "*vpeInsertNetOption.mnemonic:                	I",
    "*vpeCreateMacroOption.labelString:           	Create Macro...",
    "*vpeCreateMacroOption.mnemonic:              	M",
    "*vpePageCascade.labelString:                 	Page",
    "*vpePageCascade.mnemonic:				P",
    "*vpeCreatePageOption.labelString:            	Create Empty Page",
    "*vpeCreatePageOption.mnemonic:               	E",
    "*vpeSelectedPageOption.labelString:          	Create with Selected Tools",
    "*vpeSelectedPageOption.mnemonic:             	C",
    "*vpeMoveToPageOption.labelString:            	Move Selected Tools...",
    "*vpeMoveToPageOption.mnemonic:               	M",
    "*vpeChopPageOption.labelString:          	  	Separate Selected Tools",
    "*vpeChopPageOption.mnemonic:          	  	S",
    "*vpeFusePageOption.labelString:          	  	Reconnect Selected Tools",
    "*vpeFusePageOption.mnemonic:          	  	R",
    "*vpeDeletePageOption.labelString:            	Delete Page",
    "*vpeDeletePageOption.mnemonic:               	D",
    "*vpeConfigurePageOption.labelString:         	Configure Page...",
    "*vpeConfigurePageOption.mnemonic:            	F",

    "*vpeJavaCascade.labelString:                 	Java",
    "*vpeJavaCascade.mnemonic:				J",
    "*vpeJavifyNetOption.labelString:             	Add Tools",
    "*vpeUnjavifyNetOption.labelString:           	Remove Tools",
    "*vpeSaveWebPageOption.labelString:           	Save As Web Page",
    "*vpeSaveAppletOption.labelString:            	Net to Applet",
    "*vpeSaveBeanOption.labelString:              	Net to Bean",
    
    "*vpeReflowGraphOption.labelString:           	Layout Graph",
    "*vpeReflowGraphOption.mnemonic:              	u",
    "*vpeReflowGraphOption.accelerator:           	Ctrl<Key>K",
    "*vpeReflowGraphOption.acceleratorText:       	Ctrl+K",
    "*vpeStraightenArcsOption.labelString:        	Tidy Up the Arcs",
    "*vpeStraightenArcsOption.mnemonic:          	 y",

    "*vpeMacroNameOption.labelString:             	Macro Name...",
    "*vpeMacroNameOption.mnemonic:                	N",
    "*vpeCreateProcessGroupOption.labelString:    	Execution Groups...",
    "*vpeCreateProcessGroupOption.mnemonic:       	G",
    "*vpeCommentOption.labelString:               	Comment...",
    "*vpeCommentOption.mnemonic:                  	O",

    "*windowsMenu.labelString:                    	Windows",
    "*windowsMenu.mnemonic:                       	W",
    "*vpeNewControlPanelOption.labelString:        	New Control Panel",
    "*vpeNewControlPanelOption.mnemonic:           	P",
    "*vpeOpenControlPanelOption.labelString:  		Open Selected Control Panel(s)",
    "*vpeOpenControlPanelOption.mnemonic:          	S",
    "*vpeOpenAllControlPanelsOption.labelString:   	Open All Control Panels",
    "*vpeOpenAllControlPanelsOption.mnemonic:      	A",
    "*vpeOpenAllControlPanelsOption.accelerator:   	Ctrl Shift <Key>P",
    "*vpeOpenAllControlPanelsOption.acceleratorText: 	Ctrl+Shift+P",
    "*vpePanelCascade.labelString:                 	Open Control Panel by Name",
    "*vpePanelCascade.mnemonic:                    	N",
    "*vpePanelGroupCascade.labelString:            	Open Control Panel by Group",
    "*vpePanelGroupCascade.mnemonic:               	G",
    "*vpeOpenMacroOption.labelString:              	Open Selected Macro(s)",
    "*vpeOpenMacroOption.mnemonic:                 	R",
    "*vpeOpenImageOption.labelString:             	Open Selected Image Window(s)",
    "*vpeOpenImageOption.mnemonic:                 	I",
    "*vpeOpenColormapEditorOption.labelString:		Open Selected Colormap Editor(s)",
    "*vpeOpenColormapEditorOption.mnemonic:        	C",
    "*vpeOpenColormapEditorOption.accelerator:     	Ctrl Shift <Key>E",
    "*vpeOpenColormapEditorOption.acceleratorText: 	Ctrl+Shift+E",
    "*vpeMessageWindowOption.labelString:          	Open Message Window",
    "*vpeMessageWindowOption.mnemonic:             	M",
    "*vpeMessageWindowOption.accelerator:		Ctrl <Key>M",
    "*vpeMessageWindowOption.acceleratorText:		Ctrl+M",

    "*optionsMenu.labelString:                    	Options",
    "*optionsMenu.mnemonic:                       	O",
    "*vpeToolPalettesOption.labelString:          	Tool Palettes",
    "*vpeToolPalettesOption.mnemonic:             	T",
    "*vpeToolPalettesOption.accelerator:          	Ctrl<Key>T",
    "*vpeToolPalettesOption.acceleratorText:      	Ctrl+T",
    "*vpeHitDetectionOption.labelString:          	Prevent Overlap",
    "*vpeHitDetectionOption.mnemonic:             	v",
    "*vpePanelAccessOption.labelString:           	Control Panel Access...",
    "*vpePanelAccessOption.mnemonic:              	A",
    "*vpePanelGroupOption.labelString:            	Control Panel Groups...",
    "*vpePanelGroupOption.mnemonic:               	P",
    "*vpeGridOption.labelString:                  	Grid...",
    "*vpeGridOption.mnemonic:                     	G",

    "*fileMenuPulldown.tearOffModel:		  	XmTEAR_OFF_DISABLED",
    "*editMenuPulldown.tearOffModel:		  	XmTEAR_OFF_DISABLED",
    "*windowsMenuPulldown.tearOffModel:		  	XmTEAR_OFF_DISABLED",

    "*vpeOnVisualProgramOption.labelString:       	Application Comment...",
    "*vpeOnVisualProgramOption.mnemonic:          	A",
#if (XmVersion > 1001)
    "*workAreaFrame*traversalOn:                  false",
    "*workAreaFrame*XmWorkspace*traversalOn:      true",
#endif
    ".mainWindow.commandWindowLocation:	XmCOMMAND_ABOVE_WORKSPACE",
    ".mainWindow.packing: 		XmPACK_NONE",
    NULL
};

#endif

#endif // _EWDefaultResources_h

