/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

// ----------------------------------------------------------------------------------
//
// magickfilter, a Drip plugin making use of ImageMagick
//
// 09-02-2003 - Jarl van Katwijk
//
// ----------------------------------------------------------------------------------


#include "../config.h"
#include "../src/drip.h"
#include "../encoder/plugin-loader.hh"
#include <gmodule.h>

// Custom includes:
#include <stdio.h>
#include <magick/api.h>
#include "../encoder/conversion.hh"

#undef DEBUG
//#define DEBUG

static gboolean init_done = FALSE;                 // Plugin initialised flag
static gint width,height;                          // Input Width\Height sizes
static gint xoff,yoff,xlen,ylen;                   // Offset and lenght values
static gdouble framerate;                           // Framerate (25.00, 29.97, etc)
static gdouble        value1,value2,value3,value4;  // Plugin defined values - these are loaded\saved by Drip
static gdouble value5,value6,value7,value8,value9; 
static gdouble value10,value11,value12,value13,value14;
static gdouble value15,value16,value17,value18,value19;
static gdouble value20,value21,value22,value23,value24;
static gdouble value25,value26,value27,value28,value29;
static gdouble value30,value31,value32,value33,value34;
static gdouble value35,value36,value37,value38,value39;
static gdouble value40,value41,value42,value43,value44;
static gdouble value45,value46,value47,value48,value49;
static gdouble value50,value51,value52,value53,value54;
static gdouble value55,value56,value57,value58,value59;
static gdouble value60,value61,value62,value63,value64;
static gdouble value65,value66,value67,value68,value69,value70;

static guint8 *src_planes[3];                      // Input data planes (I420 colour space)
static guint8 *dst_planes[3];                      // Output data planes
// Custom vari's
static guchar* ToRGBbuffer;
static guchar* TempBuffer;
static ExceptionInfo exception;
/* gui widgets */
static GtkObject *rotate_adj;
static GtkObject *contrast_adj;
static GtkObject *equalize_adj;
static GtkObject *gamma1_adj,*gamma2_adj,*gamma3_adj;
static GtkObject *level1_adj,*level2_adj,*level3_adj;
static GtkObject *levelchannel1_adj,*levelchannel2_adj,*levelchannel3_adj,*levelchannel4_adj;
static GtkObject *modulate1_adj,*modulate2_adj,*modulate3_adj;
static GtkObject *negate_adj;
static GtkObject *normalize_adj;
static GtkObject *adaptivethreshold1_adj,*adaptivethreshold2_adj,*adaptivethreshold3_adj;
static GtkObject *addnoise_adj;
static GtkObject *blur1_adj,*blur2_adj;
static GtkObject *despeckle_adj;
static GtkObject *edge_adj;
static GtkObject *emboss1_adj,*emboss2_adj;
static GtkObject *enhance_adj;
static GtkObject *gaussianblur1_adj,*gaussianblur2_adj;
static GtkObject *median_adj;
static GtkObject *motionblur1_adj,*motionblur2_adj,*motionblur3_adj;
static GtkObject *reducenoise_adj;
static GtkObject *shade1_adj,*shade2_adj,*shade3_adj;
static GtkObject *sharpen1_adj,*sharpen2_adj;
static GtkObject *spread_adj;
static GtkObject *threshold_adj;
static GtkObject *thresholdchannel1_adj,*thresholdchannel2_adj,*thresholdchannel3_adj;
static GtkObject *unsharpmask1_adj,*unsharpmask2_adj,*unsharpmask3_adj,*unsharpmask4_adj;
static GtkObject *charcoal1_adj,*charcoal2_adj;
static GtkObject *implode_adj;
static GtkObject *oilpaint_adj;
static GtkObject *solarize_adj;
static GtkObject *swirl_adj;
static GtkObject *wave1_adj,*wave2_adj;
//static GtkObject *;


extern "C" {



/* Return type (SPU,AUDIO,VIDEO) of filter */
G_MODULE_EXPORT module_type_e magickfilter_type(void) {
    return VIDEO;
}


/* Return phase (PRE,NORMAL,POST) of filter */
G_MODULE_EXPORT module_phase_e magickfilter_phase(void) {
    return NORMAL;
}



/* == CALLBACKS == */
static void rotate_cb(GtkWidget *w, gpointer data) {
    value1 = GTK_ADJUSTMENT(rotate_adj)->value; 
}

static void contrast_cb(GtkWidget *w, gpointer data) {
    value2 = GTK_ADJUSTMENT(contrast_adj)->value;
}

static void equalize_cb(GtkWidget *w, gpointer data) {
    value61 = GTK_ADJUSTMENT(equalize_adj)->value;
}

static void gamma1_cb(GtkWidget *w, gpointer data) {
    value3 = GTK_ADJUSTMENT(gamma1_adj)->value;
}
static void gamma2_cb(GtkWidget *w, gpointer data) {
    value4 = GTK_ADJUSTMENT(gamma2_adj)->value;
}
static void gamma3_cb(GtkWidget *w, gpointer data) {
    value5 = GTK_ADJUSTMENT(gamma3_adj)->value;
}

static void level1_cb(GtkWidget *w, gpointer data) {
    value6 = GTK_ADJUSTMENT(level1_adj)->value;
}
static void level2_cb(GtkWidget *w, gpointer data) {
    value7 = GTK_ADJUSTMENT(level2_adj)->value;
}
static void level3_cb(GtkWidget *w, gpointer data) {
    value8 = GTK_ADJUSTMENT(level3_adj)->value;
}

static void levelchannel1_cb(GtkWidget *w, gpointer data) {
    value9 = GTK_ADJUSTMENT(levelchannel1_adj)->value;
}
static void levelchannel2_cb(GtkWidget *w, gpointer data) {
    value10 = GTK_ADJUSTMENT(levelchannel2_adj)->value;
}
static void levelchannel3_cb(GtkWidget *w, gpointer data) {
    value11 = GTK_ADJUSTMENT(levelchannel3_adj)->value;
}
static void levelchannel4_cb(GtkWidget *w, gpointer data) {
    value12 = GTK_ADJUSTMENT(levelchannel4_adj)->value;
}

static void modulate1_cb(GtkWidget *w, gpointer data) {
    value13 = GTK_ADJUSTMENT(modulate1_adj)->value;
}
static void modulate2_cb(GtkWidget *w, gpointer data) {
    value14 = GTK_ADJUSTMENT(modulate2_adj)->value;
}
static void modulate3_cb(GtkWidget *w, gpointer data) {
    value15 = GTK_ADJUSTMENT(modulate3_adj)->value;
}

static void negate_cb(GtkWidget *w, gpointer data) {
    value16 = GTK_ADJUSTMENT(negate_adj)->value;
}

static void normalize_cb(GtkWidget *w, gpointer data) {
    value62 = GTK_ADJUSTMENT(normalize_adj)->value;
}

static void adaptivethreshold1_cb(GtkWidget *w, gpointer data) {
    value17 = GTK_ADJUSTMENT(adaptivethreshold1_adj)->value;
}
static void adaptivethreshold2_cb(GtkWidget *w, gpointer data) {
    value18 = GTK_ADJUSTMENT(adaptivethreshold2_adj)->value;
}
static void adaptivethreshold3_cb(GtkWidget *w, gpointer data) {
    value19 = GTK_ADJUSTMENT(adaptivethreshold3_adj)->value;
}

static void addnoise_cb(GtkWidget *w, gpointer data) {
    value20 = GTK_ADJUSTMENT(addnoise_adj)->value;
}

static void blur1_cb(GtkWidget *w, gpointer data) {
    value21 = GTK_ADJUSTMENT(blur1_adj)->value;
}
static void blur2_cb(GtkWidget *w, gpointer data) {
    value22 = GTK_ADJUSTMENT(blur2_adj)->value;
}

static void despeckle_cb(GtkWidget *w, gpointer data) {
    value63 = GTK_ADJUSTMENT(despeckle_adj)->value;
}

static void edge_cb(GtkWidget *w, gpointer data) {
    value23 = GTK_ADJUSTMENT(edge_adj)->value;
}

static void emboss1_cb(GtkWidget *w, gpointer data) {
    value24 = GTK_ADJUSTMENT(emboss1_adj)->value;
}
static void emboss2_cb(GtkWidget *w, gpointer data) {
    value25 = GTK_ADJUSTMENT(emboss2_adj)->value;
}

static void enhance_cb(GtkWidget *w, gpointer data) {
    value64 = GTK_ADJUSTMENT(enhance_adj)->value;
}

static void gaussianblur1_cb(GtkWidget *w, gpointer data) {
    value26 = GTK_ADJUSTMENT(gaussianblur1_adj)->value;
}
static void gaussianblur2_cb(GtkWidget *w, gpointer data) {
    value27 = GTK_ADJUSTMENT(gaussianblur2_adj)->value;
}

static void median_cb(GtkWidget *w, gpointer data) {
    value28 = GTK_ADJUSTMENT(median_adj)->value;
}

static void motionblur1_cb(GtkWidget *w, gpointer data) {
    value29 = GTK_ADJUSTMENT(motionblur1_adj)->value;
}
static void motionblur2_cb(GtkWidget *w, gpointer data) {
    value30 = GTK_ADJUSTMENT(motionblur2_adj)->value;
}
static void motionblur3_cb(GtkWidget *w, gpointer data) {
    value31 = GTK_ADJUSTMENT(motionblur3_adj)->value;
}

static void reducenoise_cb(GtkWidget *w, gpointer data) {
    value32 = GTK_ADJUSTMENT(reducenoise_adj)->value;
}

static void shade1_cb(GtkWidget *w, gpointer data) {
    value33 = GTK_ADJUSTMENT(shade1_adj)->value;
}
static void shade2_cb(GtkWidget *w, gpointer data) {
    value34 = GTK_ADJUSTMENT(shade2_adj)->value;
}
static void shade3_cb(GtkWidget *w, gpointer data) {
    value35 = GTK_ADJUSTMENT(shade3_adj)->value;
}

static void sharpen1_cb(GtkWidget *w, gpointer data) {
    value36 = GTK_ADJUSTMENT(sharpen1_adj)->value;
}
static void sharpen2_cb(GtkWidget *w, gpointer data) {
    value37 = GTK_ADJUSTMENT(sharpen2_adj)->value;
}

static void spread_cb(GtkWidget *w, gpointer data) {
    value38 = GTK_ADJUSTMENT(spread_adj)->value;
}

static void threshold_cb(GtkWidget *w, gpointer data) {
    value39 = GTK_ADJUSTMENT(threshold_adj)->value;
}

static void thresholdchannel1_cb(GtkWidget *w, gpointer data) {
    value40 = GTK_ADJUSTMENT(thresholdchannel1_adj)->value;
}
static void thresholdchannel2_cb(GtkWidget *w, gpointer data) {
    value41 = GTK_ADJUSTMENT(thresholdchannel2_adj)->value;
}
static void thresholdchannel3_cb(GtkWidget *w, gpointer data) {
    value42 = GTK_ADJUSTMENT(thresholdchannel3_adj)->value;
}

static void unsharpmask1_cb(GtkWidget *w, gpointer data) {
    value43 = GTK_ADJUSTMENT(unsharpmask1_adj)->value;
}
static void unsharpmask2_cb(GtkWidget *w, gpointer data) {
    value44 = GTK_ADJUSTMENT(unsharpmask2_adj)->value;
}
static void unsharpmask3_cb(GtkWidget *w, gpointer data) {
    value45 = GTK_ADJUSTMENT(unsharpmask3_adj)->value;
}
static void unsharpmask4_cb(GtkWidget *w, gpointer data) {
    value46 = GTK_ADJUSTMENT(unsharpmask4_adj)->value;
}

static void charcoal1_cb(GtkWidget *w, gpointer data) {
    value47 = GTK_ADJUSTMENT(charcoal1_adj)->value;
}
static void charcoal2_cb(GtkWidget *w, gpointer data) {
    value48 = GTK_ADJUSTMENT(charcoal2_adj)->value;
}

static void implode_cb(GtkWidget *w, gpointer data) {
    value55 = GTK_ADJUSTMENT(implode_adj)->value;
}

static void oilpaint_cb(GtkWidget *w, gpointer data) {
    value56 = GTK_ADJUSTMENT(oilpaint_adj)->value;
}

static void solarize_cb(GtkWidget *w, gpointer data) {
    value57 = GTK_ADJUSTMENT(solarize_adj)->value;
}

static void swirl_cb(GtkWidget *w, gpointer data) {
    value58 = GTK_ADJUSTMENT(swirl_adj)->value;
}

static void wave1_cb(GtkWidget *w, gpointer data) {
    value59 = GTK_ADJUSTMENT(wave1_adj)->value;
}
static void wave2_cb(GtkWidget *w, gpointer data) {
    value60 = GTK_ADJUSTMENT(wave2_adj)->value;
}




/* Function which implements a GtkPlug to let user configure this plugin */
G_MODULE_EXPORT GtkWidget* magickfilter_gui(void) {
    static GtkWidget *hbox;
    static GtkWidget *scrolledwindow;
    static GtkWidget *viewport;
    static GtkWidget *gui;
    static GtkWidget *main;
    static GtkWidget *label,*hscale;
    static GtkTooltips *tooltips;

    #ifdef DEBUG
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter gui");
    #endif

    /* Build the gtk user interface for this plugins here. Also implement the callbacks */
    // gtk_adjustment_new(value, lower, upper, step_increment, page_increment, page_size);
    rotate_adj = gtk_adjustment_new(value1, -180.0, 180.0, 1, 10, 0);                 // Rotate
    contrast_adj = gtk_adjustment_new(value2, -1.0, 1.0, 1, 1, 0);                    // Contrast
    equalize_adj = gtk_adjustment_new(value61, 0.0, 1.0, 1, 1, 0);                    // Equalize
    gamma1_adj = gtk_adjustment_new(value3, 0.0, 5.0, 0.1, 1, 0);                     // Gamma
        gamma2_adj = gtk_adjustment_new(value4, 0.0, 5.0, 0.1, 1, 0);
        gamma3_adj = gtk_adjustment_new(value5, 0.0, 5.0, 0.1, 1, 0);
    level1_adj = gtk_adjustment_new(value6, 0.0, 5.0, 0.1, 1, 0);                     // Level
        level2_adj = gtk_adjustment_new(value7, 0.0, 5.0, 0.1, 1, 0);
        level3_adj = gtk_adjustment_new(value8, 0.0, 5.0, 0.1, 1, 0);
    levelchannel1_adj = gtk_adjustment_new(value9, 0.0, 6.0, 0.1, 1, 0);              // LevelChannel
        levelchannel2_adj = gtk_adjustment_new(value10, 0.0, 5.0, 0.1, 1, 0);
        levelchannel3_adj = gtk_adjustment_new(value11, 0.0, 5.0, 0.1, 1, 0);
        levelchannel4_adj = gtk_adjustment_new(value12, 0.0, 5.0, 0.1, 1, 0);
    modulate1_adj = gtk_adjustment_new(value13, 0.0, 200.0, 1, 10, 0);                // Modulate
        modulate2_adj = gtk_adjustment_new(value14, 0.0, 200.0, 1, 10, 0);
        modulate3_adj = gtk_adjustment_new(value15, 0.0, 200.0, 1, 10, 0);
    negate_adj = gtk_adjustment_new(value16, -1.0, 1.0, 1, 1, 0);                     // Negate
    normalize_adj = gtk_adjustment_new(value62, 0.0, 1.0, 1, 1, 0);                   // Normalize
    adaptivethreshold1_adj = gtk_adjustment_new(value17, 0.0, 1000.0, 1, 10, 0);      // AdaptiveThreshold
        adaptivethreshold2_adj = gtk_adjustment_new(value18, 0.0, 1000.0, 1, 10, 0);
        adaptivethreshold3_adj = gtk_adjustment_new(value19, 0.0, 1000.0, 1, 10, 0);
    addnoise_adj = gtk_adjustment_new(value20, 0.0, 6.0, 1, 1, 0);                    // AddNoise
    blur1_adj = gtk_adjustment_new(value21, -1.0, 10.0, 1, 1, 0);                     // Blur
        blur2_adj = gtk_adjustment_new(value22, 1.0, 10.0, 1, 1, 0);
    despeckle_adj = gtk_adjustment_new(value63, 0.0, 1.0, 1, 1, 0);                   // Despeckle
    edge_adj = gtk_adjustment_new(value23, -1.0, 10.0, 1, 10, 0);                     // Edge
    emboss1_adj = gtk_adjustment_new(value24, 0.0, 100.0, 1, 10, 0);                  // Emboss
        emboss2_adj = gtk_adjustment_new(value25, 1.0, 100.0, 1, 10, 0); 
    enhance_adj = gtk_adjustment_new(value64, 0.0, 1.0, 1, 1, 0);                     // Enhance
    gaussianblur1_adj = gtk_adjustment_new(value26, 0.0, 100.0, 1, 10, 0);            // GaussianBlur
        gaussianblur2_adj = gtk_adjustment_new(value27, 1.0, 100.0, 1, 10, 0);
    median_adj = gtk_adjustment_new(value28, 0.0, 100.0, 1, 10, 0);                   // Median
    motionblur1_adj = gtk_adjustment_new(value29, 0.0, 100.0, 1, 10, 0);              // MotionBlur
        motionblur2_adj = gtk_adjustment_new(value30, 1.0, 100.0, 1, 10, 0);
        motionblur3_adj = gtk_adjustment_new(value31, -180.0, 180.0, 1, 10, 0);
    reducenoise_adj = gtk_adjustment_new(value32, 0.0, 10.0, 0.05, 0.1, 0);           // ReduceNoise
    shade1_adj = gtk_adjustment_new(value33, 0.0, 100.0, 1, 10, 0);                   // Shade
        shade2_adj = gtk_adjustment_new(value34, -180.0, 180.0, 1, 10, 0);
        shade3_adj = gtk_adjustment_new(value35, -180.0, 180.0, 1, 10, 0);
    sharpen1_adj = gtk_adjustment_new(value36, 0.0, 100.0, 1, 10, 0);                 // Sharpen
        sharpen2_adj = gtk_adjustment_new(value37, 1.0, 100.0, 1, 10, 0);
    spread_adj = gtk_adjustment_new(value38, 0.0, 100.0, 1, 10, 0);                   // Spread
    threshold_adj = gtk_adjustment_new(value39, 0.0, 255.0, 1, 10, 0);                // Threshhold
    thresholdchannel1_adj = gtk_adjustment_new(value40, 0.0, 255.0, 1, 10, 0);        // ThreshholdChannel
        thresholdchannel2_adj = gtk_adjustment_new(value41, 0.0, 255.0, 1, 10, 0);
        thresholdchannel3_adj = gtk_adjustment_new(value42, 0.0, 255.0, 1, 10, 0);
    unsharpmask1_adj = gtk_adjustment_new(value43, 0.0, 100.0, 1, 10, 0);              // UnsharpMask
        unsharpmask2_adj = gtk_adjustment_new(value44, 1.0, 100.0, 1, 10, 0);
        unsharpmask3_adj = gtk_adjustment_new(value45, 0.0, 100.0, 1, 10, 0);
        unsharpmask4_adj = gtk_adjustment_new(value46, 0.0, 100.0, 1, 10, 0);
    charcoal1_adj = gtk_adjustment_new(value47, 0.0, 100.0, 1, 10, 0);                 // Charcoal
        charcoal2_adj = gtk_adjustment_new(value48, 1.0, 100.0, 1, 10, 0);
    implode_adj = gtk_adjustment_new(value55, 0.0, 100.0, 1, 10, 0);                   // Implode
    oilpaint_adj = gtk_adjustment_new(value56, 0.0, 100.0, 1, 10, 0);                  // OilPaint
    solarize_adj = gtk_adjustment_new(value57, 0.0, 255.0, 1, 10, 0);                  // Solarize
    swirl_adj = gtk_adjustment_new(value58, 1.0, 360.0, 1, 10, 0);                     // Swirl
    wave1_adj = gtk_adjustment_new(value59, 1.0, 1000.0, 1, 10, 0);                     // Wave
        wave2_adj = gtk_adjustment_new(value60, 1.0, 1000.0, 1, 10, 0);
    tooltips = gtk_tooltips_new ();

    // Main container widget
    hbox = gtk_hbox_new(TRUE, 0);
    gtk_widget_ref(hbox);
    gtk_widget_show(hbox);
    gtk_widget_set_usize(hbox,604,286);

    scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_ref(scrolledwindow);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_widget_show(scrolledwindow);
    gtk_box_pack_start (GTK_BOX (hbox), scrolledwindow, TRUE, TRUE, 0);

    viewport = gtk_viewport_new(NULL, NULL);
    gtk_widget_ref(viewport);
    gtk_widget_show(viewport);
    gtk_container_add(GTK_CONTAINER(scrolledwindow), viewport);

    gui = gtk_table_new(2, 70, FALSE);
    gtk_widget_ref(gui);
    gtk_widget_show(gui);
    gtk_container_add(GTK_CONTAINER(viewport), gui);


    // Rotate
    label = gtk_label_new("Rotate : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 0, 1);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(rotate_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 0, 1);
    gtk_tooltips_set_tip (tooltips, hscale, " Rotate creates a new image that is a rotated copy of an existing one. Positive angles rotate counter-clockwise ( right-hand rule ), while negative angles rotate clockwise. Rotated images are usually larger than the originals and have 'empty' triangular corners. (Set to 0 to disable)  ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(rotate_cb), NULL);
    gtk_widget_show(hscale);

    // Contrast
    label = gtk_label_new("Contrast : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 1, 2);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(contrast_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 1, 2);
    gtk_tooltips_set_tip (tooltips, hscale, " Contrast enhances the intensity differences between the lighter and darker elements of the image. Set sharpen to a value other than 0 to increase the image contrast otherwise the contrast is reduced. (-1 disables this effect, 0 reduces contrast and 1 increases) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(contrast_cb), NULL);
    gtk_widget_show(hscale);

    // Equalize
    label = gtk_label_new("Equalize : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(equalize_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 2, 3);
    gtk_tooltips_set_tip (tooltips, hscale, " Equalize applies a histogram equalization to the image. (O disables, 1 enables) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(equalize_cb), NULL);
    gtk_widget_show(hscale);

    // Gamma RGB
    label = gtk_label_new("Gamma Red   : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 3, 4);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(gamma1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 3, 4);
    gtk_tooltips_set_tip (tooltips, hscale, " Use Gamma to gamma-correct an image. The same image viewed on different devices will have perceptual differences in the way the image's intensities are represented on the screen. Specify individual gamma levels for the red, green, and blue channels, or adjust all three with the gamma parameter. Values typically range from 0.8 to 2.3. (set to 0 to disable) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(gamma1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Gamma Green : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 4, 5);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(gamma2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 4, 5);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(gamma2_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " Use Gamma to gamma-correct an image. The same image viewed on different devices will have perceptual differences in the way the image's intensities are represented on the screen. Specify individual gamma levels for the red, green, and blue channels, or adjust all three with the gamma parameter. Values typically range from 0.8 to 2.3. (set to 0 to disable) ", NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Gamma Blue  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 5, 6);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(gamma3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 5, 6);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(gamma3_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " Use Gamma to gamma-correct an image. The same image viewed on different devices will have perceptual differences in the way the image's intensities are represented on the screen. Specify individual gamma levels for the red, green, and blue channels, or adjust all three with the gamma parameter. Values typically range from 0.8 to 2.3. (set to 0 to disable) ", NULL);
    gtk_widget_show(hscale);

    // Level
    label = gtk_label_new("Level Black : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 6, 7);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(level1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 6, 7);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(level1_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " Level adjusts the levels of an image by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Mid point specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. (100% black=0, 100% white=255) ", NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Level White : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 7, 8);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(level2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 7, 8);
    gtk_tooltips_set_tip (tooltips, hscale, " Level adjusts the levels of an image by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Mid point specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. (100% black=0, 100% white=255) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(level2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Level Gamma : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 8, 9);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(level3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 8, 9);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(level3_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " Level adjusts the levels of an image by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Mid point specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. (100% black=0, 100% white=255) ", NULL);
    gtk_widget_show(hscale);

    // LevelChannel
    label = gtk_label_new("LevelChannel Channel : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1, 9,10);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(levelchannel1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2, 9,10);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(levelchannel1_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " LevelChannel adjusts the levels of a particular image channel by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Gamma specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. ", NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("LevelChannel Black : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,10,11);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(levelchannel2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,10,11);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(levelchannel2_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " LevelChannel adjusts the levels of a particular image channel by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Gamma specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. ", NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("LevelChannel White : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,11,12);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(levelchannel3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,11,12);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(levelchannel3_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " LevelChannel adjusts the levels of a particular image channel by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Gamma specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. ", NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("LevelChannel Gamma : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,12,13);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(levelchannel4_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,12,13);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(levelchannel4_cb), NULL);
    gtk_tooltips_set_tip (tooltips, hscale, " LevelChannel adjusts the levels of a particular image channel by scaling the colors falling between specified white and black points to the full available quantum range. The parameters provided represent the black, mid, and white points. The black point specifies the darkest color in the image. Colors darker than the black point are set to zero. Gamma specifies a gamma correction to apply to the image. White point specifies the lightest color in the image. Colors brighter than the white point are set to the maximum quantum value. ", NULL);
    gtk_widget_show(hscale);

    // Modulate
    label = gtk_label_new("Modulate Brightness : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,13,14);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(modulate1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,13,14);
    gtk_tooltips_set_tip (tooltips, hscale, " Modulate lets you control the brightness, saturation, and hue of an image. Modulate represents the brightness, saturation, and hue as one parameter ( e.g. 90, 150, 100 ) . ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(modulate1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Modulate Hue : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,14,15);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(modulate2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,14,15);
    gtk_tooltips_set_tip (tooltips, hscale, " Modulate lets you control the brightness, saturation, and hue of an image. Modulate represents the brightness, saturation, and hue as one parameter ( e.g. 90, 150, 100 ) . ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(modulate2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Modulate Saturation : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,15,16);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(modulate3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,15,16);
    gtk_tooltips_set_tip (tooltips, hscale, " Modulate lets you control the brightness, saturation, and hue of an image. Modulate represents the brightness, saturation, and hue as one parameter ( e.g. 90, 150, 100 ) . ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(modulate3_cb), NULL);
    gtk_widget_show(hscale);

    // Negate  
    label = gtk_label_new("Negate : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,16,17);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(negate_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,16,17);
    gtk_tooltips_set_tip (tooltips, hscale, " Method NegateImage negates the colors in the reference image. The Grayscale option means that only grayscale values within the image are negated. (-1=disable, 0=full negate, 1=negate gray only) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(negate_cb), NULL);
    gtk_widget_show(hscale);

    // Normalize
    label = gtk_label_new("Normalize : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,17,18);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(normalize_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,17,18);
    gtk_tooltips_set_tip (tooltips, hscale, " The Normalize method enhances the contrast of a color image by adjusting the pixels color to span the entire range of colors available. (0=disable, 1=enable) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(normalize_cb), NULL);
    gtk_widget_show(hscale);

    // AdaptiveThreshold
    label = gtk_label_new("AdaptiveThreshold Width  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,18,19);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(adaptivethreshold1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,18,19);
    gtk_tooltips_set_tip (tooltips, hscale, " AdaptiveThreshold selects an individual threshold for each pixel based on the range of intensity values in its local neighborhood. This allows for thresholding of an image whose global intensity histogram doesn't contain distinctive peaks. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(adaptivethreshold1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("AdaptiveThreshold Height : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,19,20);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(adaptivethreshold2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,19,20);
    gtk_tooltips_set_tip (tooltips, hscale, " AdaptiveThreshold selects an individual threshold for each pixel based on the range of intensity values in its local neighborhood. This allows for thresholding of an image whose global intensity histogram doesn't contain distinctive peaks. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(adaptivethreshold2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("AdaptiveThreshold Offset : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,20,21);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(adaptivethreshold3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,20,21);
    gtk_tooltips_set_tip (tooltips, hscale, " AdaptiveThreshold selects an individual threshold for each pixel based on the range of intensity values in its local neighborhood. This allows for thresholding of an image whose global intensity histogram doesn't contain distinctive peaks. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(adaptivethreshold3_cb), NULL);
    gtk_widget_show(hscale);

    // Add Noise
    label = gtk_label_new("Add Noise  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,21,22);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(addnoise_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,21,22);
    gtk_tooltips_set_tip (tooltips, hscale, " AddNoise adds random noise to the image. (0=Disable, 1=Uniform Noise, 2=Gaussian Noise, 3=Multiplicative Noise, 4=Impulse Noise, 5=Laplacian Noise, 6=Poisson Noise) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(addnoise_cb), NULL);
    gtk_widget_show(hscale);

    // Blur              
    label = gtk_label_new("Blur Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,22,23);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(blur1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,22,23);
    gtk_tooltips_set_tip (tooltips, hscale, " Blur blurs an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, the radius should be larger than sigma. Use a radius of 0 and Blur selects a suitable radius for you. (-1=disable, 0=auto, >0=radius of blur) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(blur1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Blur Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,23,24);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(blur2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,23,24);
    gtk_tooltips_set_tip (tooltips, hscale, " Blur blurs an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, the radius should be larger than sigma. Use a radius of 0 and Blur selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(blur2_cb), NULL);
    gtk_widget_show(hscale);

    // Despeckle
    label = gtk_label_new("Despeckle : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,24,25);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(despeckle_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,24,25);
    gtk_tooltips_set_tip (tooltips, hscale, " Despeckle reduces the speckle noise in an image while perserving the edges of the original image. (0=disable, 1=enable) ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(despeckle_cb), NULL);
    gtk_widget_show(hscale);

    // Edge
    label = gtk_label_new("Edge : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,25,26);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(edge_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,25,26);
    gtk_tooltips_set_tip (tooltips, hscale, " EdgeImage finds edges in an image. Radius defines the radius of the convolution filter. Use a radius of 0 and Edge selects a suitable radius for you. (-1=disable, 0=auto, >0=radius)", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(edge_cb), NULL);
    gtk_widget_show(hscale);

    // Emboss
    label = gtk_label_new("Emboss Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,26,27);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(emboss1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,26,27);
    gtk_tooltips_set_tip (tooltips, hscale, " Emboss returns a grayscale image with a three-dimensional effect. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and Emboss selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(emboss1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Emboss Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,27,28);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(emboss2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,27,28);
    gtk_tooltips_set_tip (tooltips, hscale, " Emboss returns a grayscale image with a three-dimensional effect. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and Emboss selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(emboss2_cb), NULL);
    gtk_widget_show(hscale);

    // Enhance
    label = gtk_label_new("Enhance : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,28,29);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(enhance_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,28,29);
    gtk_tooltips_set_tip (tooltips, hscale, " Enhance applies a digital filter that improves the quality of a noisy image. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(enhance_cb), NULL);
    gtk_widget_show(hscale);

    // GaussianBlur
    label = gtk_label_new("GaussianBlur Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,29,30);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(gaussianblur1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,29,30);
    gtk_tooltips_set_tip (tooltips, hscale, " GaussianBlur blurs an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, the radius should be larger than sigma. Use a radius of 0 and GaussianBlur selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(gaussianblur1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("GaussianBlur Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,30,31);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(gaussianblur2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,30,31);
    gtk_tooltips_set_tip (tooltips, hscale, " GaussianBlur blurs an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, the radius should be larger than sigma. Use a radius of 0 and GaussianBlur selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(gaussianblur2_cb), NULL);
    gtk_widget_show(hscale);

    // Median
    label = gtk_label_new("Median : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,31,32);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(median_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,31,32);
    gtk_tooltips_set_tip (tooltips, hscale, " MedianFilter applies a digital filter that improves the quality of a noisy image. Each pixel is replaced by the median in a set of neighboring pixels as defined by radius. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(median_cb), NULL);
    gtk_widget_show(hscale);

    // Motion Blur
    label = gtk_label_new("Motion Blur Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,32,33);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(motionblur1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,32,33);
    gtk_tooltips_set_tip (tooltips, hscale, " MotionBlur simulates motion blur. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and MotionBlur selects a suitable radius for you. Angle gives the angle of the blurring motion. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(motionblur1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Motion Blur Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,33,34);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(motionblur2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,33,34);
    gtk_tooltips_set_tip (tooltips, hscale, " MotionBlur simulates motion blur. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and MotionBlur selects a suitable radius for you. Angle gives the angle of the blurring motion. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(motionblur2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Motion Blur Angle  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,34,35);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(motionblur3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,34,35);
    gtk_tooltips_set_tip (tooltips, hscale, " MotionBlur simulates motion blur. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and MotionBlur selects a suitable radius for you. Angle gives the angle of the blurring motion. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(motionblur3_cb), NULL);
    gtk_widget_show(hscale);

    // Reduce Noise
    label = gtk_label_new("Reduce Noise : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,35,36);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(reducenoise_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,35,36);
    gtk_tooltips_set_tip (tooltips, hscale, " ReduceNoise smooths the contours of an image while still preserving edge information. The algorithm works by replacing each pixel with its neighbor closest in value. A neighbor is defined by radius. Use a radius of 0 and ReduceNoise selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(reducenoise_cb), NULL);
    gtk_widget_show(hscale);

    // Shade
    label = gtk_label_new("Shade Grey      : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,36,37);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(shade1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,36,37);
    gtk_tooltips_set_tip (tooltips, hscale, " Shade shines a distant light on an image to create a three-dimensional effect. You control the positioning of the light with azimuth and elevation; azimuth is measured in degrees off the x axis and elevation is measured in pixels above the Z axis. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(shade1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Shade Azimuth   : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,37,38);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(shade2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,37,38);
    gtk_tooltips_set_tip (tooltips, hscale, " Shade shines a distant light on an image to create a three-dimensional effect. You control the positioning of the light with azimuth and elevation; azimuth is measured in degrees off the x axis and elevation is measured in pixels above the Z axis. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(shade2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Shade Elevation : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,38,39);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(shade3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,38,39);
    gtk_tooltips_set_tip (tooltips, hscale, " Shade shines a distant light on an image to create a three-dimensional effect. You control the positioning of the light with azimuth and elevation; azimuth is measured in degrees off the x axis and elevation is measured in pixels above the Z axis. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(shade3_cb), NULL);
    gtk_widget_show(hscale);

    // Shade
    label = gtk_label_new("Sharpen Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,39,40);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(sharpen1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,39,40);
    gtk_tooltips_set_tip (tooltips, hscale, " Sharpen sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation (sigma) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and Sharpen selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(sharpen1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Sharpen Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,40,41);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(sharpen2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,40,41);
    gtk_tooltips_set_tip (tooltips, hscale, " Sharpen sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation (sigma) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and Sharpen selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(sharpen2_cb), NULL);
    gtk_widget_show(hscale);

    // Spread
    label = gtk_label_new("Spread Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,41,42);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(spread_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,41,42);
    gtk_tooltips_set_tip (tooltips, hscale, " Spread is a special effects method that randomly displaces each pixel in a block defined by the radius parameter. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(spread_cb), NULL);
    gtk_widget_show(hscale);

    // Threshold
    label = gtk_label_new("Threshold : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,42,43);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(threshold_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,42,43);
    gtk_tooltips_set_tip (tooltips, hscale, " Threshold changes the value of individual pixels based on the intensity of each pixel compared to threshold. The result is a high-contrast, two color image. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(threshold_cb), NULL);
    gtk_widget_show(hscale);

    // Threshold Channel
    label = gtk_label_new("Threshold Red : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,43,44);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(thresholdchannel1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,43,44);
    gtk_tooltips_set_tip (tooltips, hscale, " ThresholdChannel changes the value of individual pixels based on the intensity of each pixel channel. The result is a high-contrast image. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(thresholdchannel1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Threshold Green : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,44,45);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(thresholdchannel2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,44,45);
    gtk_tooltips_set_tip (tooltips, hscale, " ThresholdChannel changes the value of individual pixels based on the intensity of each pixel channel. The result is a high-contrast image. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(thresholdchannel2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Threshold Blue  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,45,46);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(thresholdchannel3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,45,46);
    gtk_tooltips_set_tip (tooltips, hscale, " ThresholdChannel changes the value of individual pixels based on the intensity of each pixel channel. The result is a high-contrast image. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(thresholdchannel3_cb), NULL);
    gtk_widget_show(hscale);

    // Unsharp Mask
    label = gtk_label_new("Unsharp Mask Radius    : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,46,47);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(unsharpmask1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,46,47);
    gtk_tooltips_set_tip (tooltips, hscale, " UnsharpMask sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and UnsharpMask selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(unsharpmask1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Unsharp Mask Sigma     : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,47,48);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(unsharpmask2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,47,48);
    gtk_tooltips_set_tip (tooltips, hscale, " UnsharpMask sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and UnsharpMask selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(unsharpmask2_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Unsharp Mask Amount    : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,48,49);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(unsharpmask3_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,48,49);
    gtk_tooltips_set_tip (tooltips, hscale, " UnsharpMask sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and UnsharpMask selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(unsharpmask3_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Unsharp Mask Threshold : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,49,50);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(unsharpmask4_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,49,50);
    gtk_tooltips_set_tip (tooltips, hscale, " UnsharpMask sharpens an image. We convolve the image with a Gaussian operator of the given radius and standard deviation ( sigma ) . For reasonable results, radius should be larger than sigma. Use a radius of 0 and UnsharpMask selects a suitable radius for you. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(unsharpmask4_cb), NULL);
    gtk_widget_show(hscale);

    // Charcoal
    label = gtk_label_new("Charcoal Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,50,51);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(charcoal1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,50,51);
    gtk_tooltips_set_tip (tooltips, hscale, " Method Charcoal creates a new image that is a copy of an existing one with the edge highlighted. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(charcoal1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Charcoal Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,51,52);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(charcoal2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,51,52);
    gtk_tooltips_set_tip (tooltips, hscale, " Method Charcoal creates a new image that is a copy of an existing one with the edge highlighted. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(charcoal2_cb), NULL);
    gtk_widget_show(hscale);

    // Implode 
    label = gtk_label_new("Implode : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,52,53);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(implode_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,52,53);
    gtk_tooltips_set_tip (tooltips, hscale, " Implode creates a new image that is a copy of an existing one with the image pixels ``implode'' by the specified percentage. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(implode_cb), NULL);
    gtk_widget_show(hscale);

    // Oil Paint
    label = gtk_label_new("Oil Paint : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,53,54);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(oilpaint_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,53,54);
    gtk_tooltips_set_tip (tooltips, hscale, " OilPaint applies a special effect filter that simulates an oil painting. Each pixel is replaced by the most frequent color occurring in a circular region defined by radius. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(oilpaint_cb), NULL);
    gtk_widget_show(hscale);

    // Solarize
    label = gtk_label_new("Solarize : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,54,55);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(solarize_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,54,55);
    gtk_tooltips_set_tip (tooltips, hscale, " Solarize applies a special effect to the image, similar to the effect achieved in a photo darkroom by selectively exposing areas of photo sensitive paper to light. Threshold ranges from 0 to MaxRGB and is a measure of the extent of the solarization. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(solarize_cb), NULL);
    gtk_widget_show(hscale);

    // Swirl
    label = gtk_label_new("Swirl : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,55,56);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(swirl_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,55,56);
    gtk_tooltips_set_tip (tooltips, hscale, " Swirl swirls the pixels about the center of the image, where degrees indicates the sweep of the arc through which each pixel is moved. You get a more dramatic effect as the degrees move from 1 to 360. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(swirl_cb), NULL);
    gtk_widget_show(hscale);

    // Wave     
    label = gtk_label_new("Wave Radius : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,56,57);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(wave1_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,56,57);
    gtk_tooltips_set_tip (tooltips, hscale, " The Wave filter creates a \"ripple\" effect in the image by shifting the pixels vertically along a sine wave whose amplitude and wavelength is specified by the given parameters. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(wave1_cb), NULL);
    gtk_widget_show(hscale);
    label = gtk_label_new("Wave Sigma  : ");
    gtk_table_attach_defaults(GTK_TABLE(gui), label, 0, 1,57,58);
    gtk_widget_show(label);
    hscale = gtk_hscale_new(GTK_ADJUSTMENT(wave2_adj));
    gtk_widget_set_usize(hscale, 310, 35);
    gtk_table_attach_defaults(GTK_TABLE(gui), hscale, 1, 2,57,58);
    gtk_tooltips_set_tip (tooltips, hscale, " The Wave filter creates a \"ripple\" effect in the image by shifting the pixels vertically along a sine wave whose amplitude and wavelength is specified by the given parameters. ", NULL);
    gtk_signal_connect(GTK_OBJECT(hscale), "motion_notify_event", GTK_SIGNAL_FUNC(wave2_cb), NULL);
    gtk_widget_show(hscale);



    /* Clean & Exit */
    return hbox; //gui;//scrolledwindow;
}


/* This function is called for every video frame.
   Here the actual filtering is done. */
G_MODULE_EXPORT guint8** magickfilter_apply(guint8** src, glong size, gulong SCR, gulong PTS) {
    static Image *ImageBuffer = NULL;
    static Image *ImageBuffer2 = NULL;
    gint result;
    ChannelType channel;
    NoiseType noise;
    GString *str = g_string_new("");
    GString *str2 = g_string_new("");
    #ifdef DEBUG
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter apply (PTS=%lu,SCR=%lu)",PTS,SCR);
    #endif

    /* Prepare frame for ImageMagick usage */
    I420toRGB24((guint8*)ToRGBbuffer,src[0],width,height);                                   // Convert I420 to RGB24
    DestroyConstitute();                                                                     // Destroy IM image env.
    if (ImageBuffer) DestroyImage(ImageBuffer);                                              // Destroy previous image
    ImageBuffer = ConstituteImage(width,height,"RGB",CharPixel,ToRGBbuffer,&exception);      // Create IM image
    CatchException(&exception);

    /* Apply Image Magick effects */
    /* (Fixed list of effects) */
    if (value1 != 0) {
        ImageBuffer2 = RotateImage(ImageBuffer,value1,&exception); // degrees
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Rotate");
        #endif
    }
    if (value2 != -1) {
        result = ContrastImage(ImageBuffer,(unsigned int)value2); //const unsigned int sharpen);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Contrast");
        #endif
    }
    if (value61 != 0) {
        result = EqualizeImage(ImageBuffer); // value61
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Equalize");
        #endif
    }
    if (value3!=0 || value4!=0 || value5!=0) {
        g_string_sprintf(str,"%f/%f/%f",value3,value4,value5); result = GammaImage(ImageBuffer,str->str); //const char *level);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Gamma");
        #endif
    }
    if (value6!=0 || value7!=0 || value8!=0) {
        g_string_sprintf(str,"%f/%f/%f",value6,value7,value8); result = LevelImage(ImageBuffer,str->str); //const char *level);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Level");
        #endif
    }
    if (value10!=0 || value11!=0 || value12!=0) {
        // channel type Red, Cyan, Green, Magenta, Blue, Yellow, or Opacity.
        switch ((gint)value9) {
            case 0: channel = RedChannel;break;
            case 1: channel = CyanChannel;break;
            case 2: channel = GreenChannel;break;
            case 3: channel = MagentaChannel;break;
            case 4: channel = BlueChannel;break;
            case 5: channel = YellowChannel;break;
            case 6: channel = OpacityChannel;break;
            default: channel = RedChannel;break;
        }
        result = LevelImageChannel(ImageBuffer,channel,value10,value11,value12); //const ChannelType channel,const double black_point,const double white_point,const double gamma);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter LevelChannel");
        #endif
    }
    if (value13!=0 || value14!=0 || value15!=0) {
        g_string_sprintf(str,"%f,%f,%f",value13,value14,value15); result = ModulateImage(ImageBuffer,str->str); //const char *modulate);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Modulate");
        #endif
    }
    if (value16 != -1) {
        result = NegateImage(ImageBuffer,(unsigned int)value16); //const unsigned int grayscale);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Negate");
        #endif
    }
    if (value62 != 0) {
        result = NormalizeImage(ImageBuffer); //value62
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Normalize");
        #endif
    }
    if (value17!=0 || value18!=0 || value19!=0) {
        ImageBuffer2 = AdaptiveThresholdImage(ImageBuffer,(unsigned long)value17,(unsigned long)value18,(long)value19,&exception); //const unsigned long width,const unsigned long height,const long offset
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter AdaptiveThreshold");
        #endif
    }
    if (value20 != 0) {
        // Noisetype
        switch ((gint)value20) {
            case 1: noise = UniformNoise;break;
            case 2: noise = GaussianNoise;break;
            case 3: noise = MultiplicativeGaussianNoise;break;
            case 4: noise = ImpulseNoise;break;
            case 5: noise = LaplacianNoise;break;
            case 6: noise = PoissonNoise;break;
            default: noise = GaussianNoise;break;
        }
        ImageBuffer2 = AddNoiseImage(ImageBuffer,noise,&exception); //const NoiseType noise_type
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter AddNoise");
        #endif
    }
    if (value21!=-1 || value22!=1) {
        ImageBuffer2 = BlurImage(ImageBuffer,value21,value22,&exception); //const double radius,const double sigma
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Blur");
        #endif
    }
    if (value63 != 0) {
        ImageBuffer2 = DespeckleImage((const Image*)ImageBuffer,&exception); // value63
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Despeckle");
        #endif
    }
    if (value23 != -1) {
        ImageBuffer2 = EdgeImage(ImageBuffer,value23,&exception); //const double radius
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Edge");
        #endif
    }
    if (value24!=0 || value25!=1) {
        ImageBuffer2 = EmbossImage(ImageBuffer,value24,value25,&exception); //const double radius,const double sigma
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Emboss");
        #endif
    }
    if (value64 != 0) {
        ImageBuffer2 = EnhanceImage(ImageBuffer,&exception); //value64
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Enhance");
        #endif
    }
    if (value26!=0 || value27!=1) {
        ImageBuffer2 = GaussianBlurImage(ImageBuffer,value26,value27,&exception); //const double radius,const double sigma
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter GaussianBlur");
        #endif
    }
    if (value28 != 0) {
        ImageBuffer2 = MedianFilterImage(ImageBuffer,value28,&exception); //const double radius
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Median");
        #endif
    }
    if (value29!=0 || value30!=1 || value31!=0) {
        ImageBuffer2 = MotionBlurImage(ImageBuffer,value29,value30,value31,&exception); //const double radius,const double sigma,const double angle
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter MotionBlur");
        #endif
    }
    if (value32 != 0) {
        ImageBuffer2 = ReduceNoiseImage(ImageBuffer,value32,&exception); //const double radius
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter ReduceNoise");
        #endif
    }
    if (value33!=0 || value34!=0 || value35!=0) {
        ImageBuffer2 = ShadeImage(ImageBuffer,(unsigned int)value33,value34,value35,&exception); //const unsigned int gray,double azimuth,double elevation
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Shade");
        #endif
    }
    if (value36!=0 || value37!=1) {
        ImageBuffer = SharpenImage(ImageBuffer,value36,value37,&exception); //const double radius,const double sigma
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Sharpen");
        #endif
    }
    if (value38 != 0) {
        ImageBuffer = SpreadImage(ImageBuffer,(unsigned int)value38,&exception); //const unsigned int radius
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Spread");
        #endif
    }
    if (value39 != 0) {
        result = ThresholdImage(ImageBuffer,value39); //const double threshold);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Threshold");
        #endif
    }
    if (value40!=0 || value41!=0 || value42!=0) {
        g_string_sprintf(str,"%f,%f,%f",value40,value41,value42); result = ThresholdImageChannel(ImageBuffer,str->str); //const char *threshold);
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter ThresholdChannel");
        #endif
    }
    if (value43!=0 || value44!=1 || value45!=0 || value46!=0) {
        ImageBuffer = UnsharpMaskImage(ImageBuffer,value43,value44,value45,value46,&exception); //const double radius,const double sigma,const double amount,const double threshold
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Unsharp");
        #endif
    }
    if (value47!=0 || value48!=1) {
        ImageBuffer = CharcoalImage(ImageBuffer,value47,value48,&exception); //const double radius,const double sigma
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Charcoal");
        #endif
    }
    if (value55 != 0) {
        ImageBuffer = ImplodeImage(ImageBuffer,value55,&exception); //const double amount
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Implode");
        #endif
    }
    if (value56 != 0) {
        ImageBuffer = OilPaintImage(ImageBuffer,value56,&exception); //const double radius
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter OilPaint");
        #endif
    }
    if (value57 != 0) {
        SolarizeImage(ImageBuffer,value57); //const double threshold
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Solarize");
        #endif
    }
    if (value58 != 0) {
        ImageBuffer = SwirlImage(ImageBuffer,value58,&exception); //double degrees
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Swirl");
        #endif
    }
    if (value59!=0 || value60!=0) {
        ImageBuffer = WaveImage(ImageBuffer,value59,value60,&exception); //const double amplitude,const double wave_length
        CatchException(&exception);
        DestroyImage(ImageBuffer);
        ImageBuffer = ImageBuffer2;
        #ifdef DEBUG
        g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter Wave");
        #endif
    }

    // TODO : Not yet active effects
    //ImageBuffer = ColorizeImage(ImageBuffer,const char *opacity,const PixelPacket target,&exception); v49 - v54
    //ImageBuffer = SteganoImage(ImageBuffer,Image *watermark,&exception);
    //ImageBuffer = StereoImage(ImageBuffer,const Image *offset_image,&exception);
    //ImageBuffer = BorderImage(ImageBuffer,const RectangleInfo *border_info,&exception);
    //ImageBuffer = FrameImage(ImageBuffer,const FrameInfo *frame_info,&exception);
    //result = RaiseImage(ImageBuffer,const RectangleInfo *raise_info,const int raise);
    //result = AnnotateImage(ImageBuffer,DrawInfo *draw_info);
    //result = ColorFloodfillImage(ImageBuffer,const DrawInfo *draw_info,const PixelPacket target,const long x_offset,const long y_offset,const PaintMethod method);
    //result = MatteFloodfillImage(Imagebuffer,const PixelPacket target,const unsigned int opacity,const long x_offset,const long y_offset,const PaintMethod method);
    //result = OpaqueImage(ImageBuffer,const PixelPacket target,const PixelPacket fill);
    //result = TransparentImage(ImageBuffer,const PixelPacket target,const unsigned int opacity);


    /* Return processed data back to Drip format I420 */
    result = DispatchImage(ImageBuffer,0,0,width,height,"RGB",CharPixel,TempBuffer,&exception); // Fetch image
    RGB24toI420(src[0],TempBuffer,width,height);                                                // Conv. back to I420
    /* Clean & Exit */
    g_string_free(str2,TRUE);
    g_string_free(str,TRUE);
    return src; 
}


G_MODULE_EXPORT void magickfilter_init(gint w, gint h,
                                     gint xo, gint yo, gint xl, gint yl,
                                     gdouble fr) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter init (%.1024s)",GetMagickVersion((gulong*)NULL));
    /* Copy values */
    width = w; height = h;
    xoff = xo; yoff = yo; xlen = xl; ylen = yl;
    framerate = fr;
    /* Filter specific initialisation */
    InitializeMagick(NULL);                                                     // Not really needed for proper OS's
    GetExceptionInfo(&exception);
    ToRGBbuffer = (guchar*)malloc(w*h*3);
    TempBuffer = (guchar*)malloc(w*h*3);
    /* Set init flag */
    init_done = TRUE;
    /* Clean & Exit */
    return;
}


/* Called when parameters need tobe reset to default, auto called when plugin used for 1st time */
G_MODULE_EXPORT void magickfilter_default(void) {
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter default");
    /* Set value's to default */
    value1 = 0;  value2 =-1;  value3 = 0;  value4 = 0;  value5 = 0;
    value6 = 0;  value7 = 0;  value8 = 0;  value9 = 0;  value10= 0;
    value11= 0;  value12= 0;  value13= 0;  value14= 0;  value15= 0;
    value16=-1;  value17= 0;  value18= 0;  value19= 0;  value20= 0;
    value21=-1;  value22= 1;  value23=-1;  value24= 0;  value25= 1;
    value26= 0;  value27= 1;  value28= 0;  value29= 0;  value30= 1;
    value31= 0;  value32= 0;  value33= 0;  value34= 0;  value35= 0;
    value36= 0;  value37= 1;  value38= 0;  value39= 0;  value40= 0;
    value41= 0;  value42= 0;  value43= 0;  value44= 1;  value45= 0;
    value46= 0;  value47= 0;  value48= 1;  value49= 0;  value50= 0;
    value51= 0;  value52= 0;  value53= 0;  value54= 0;  value55= 0;
    value56= 0;  value57= 0;  value58= 0;  value59= 0;  value60= 0;
    value61= 0;  value62= 0;  value63= 0;  value64= 0;  value65= 0;
    value66= 0;  value67= 0;  value68= 0;  value69= 0;  value70= 0;
    /* Clean & Exit */
    return;
}

/* Called after encoding has ended. Variable can be reset etc. */
G_MODULE_EXPORT void magickfilter_destruct(void) {
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter destruct");
    if (init_done) {
        DestroyExceptionInfo(&exception);
        DestroyMagick();
        free(ToRGBbuffer);
        free(TempBuffer);
    }
    /* Clean & Exit */
    return;
}



/* Return values of plugin (value1,value2,... value5) */
G_MODULE_EXPORT void magickfilter_values(gdouble* values) {
    values[0]  = value1;  values[1]  = value2;  values[2]  = value3;  values[3]  = value4;  values[4]  = value5;
    values[5]  = value6;  values[6]  = value7;  values[7]  = value8;  values[8]  = value9;  values[9]  = value10;
    values[10] = value11; values[11] = value12; values[12] = value13; values[13] = value14; values[14] = value15;
    values[15] = value16; values[16] = value17; values[17] = value18; values[18] = value19; values[19] = value20;
    values[20] = value21; values[21] = value22; values[22] = value23; values[23] = value24; values[24] = value25;
    values[25] = value26; values[26] = value27; values[27] = value28; values[28] = value29; values[29] = value30;
    values[30] = value31; values[31] = value32; values[32] = value33; values[33] = value34; values[34] = value35;
    values[35] = value36; values[36] = value37; values[37] = value38; values[38] = value39; values[39] = value40;
    values[40] = value41; values[41] = value42; values[42] = value43; values[43] = value44; values[44] = value45;
    values[45] = value46; values[46] = value47; values[47] = value48; values[48] = value49; values[49] = value50;
    values[50] = value51; values[51] = value52; values[52] = value53; values[53] = value54; values[54] = value55;
    values[55] = value56; values[56] = value57; values[57] = value58; values[58] = value59; values[59] = value60;
    values[60] = value61; values[61] = value62; values[62] = value63; values[63] = value64; values[64] = value65;
    values[65] = value66; values[66] = value67; values[67] = value68; values[68] = value69; values[69] = value70;
    return;
}

/* Set plugins values */
G_MODULE_EXPORT void magickfilter_values_function(gdouble *v) {
    value1  = v[0];  value2  = v[1];  value3  = v[2];  value4  = v[3];  value5  = v[4];
    value6  = v[5];  value7  = v[6];  value8  = v[7];  value9  = v[8];  value10 = v[9];
    value11 = v[10]; value12 = v[11]; value13 = v[12]; value14 = v[13]; value15 = v[14];
    value16 = v[15]; value17 = v[16]; value18 = v[17]; value19 = v[18]; value20 = v[19];
    value21 = v[20]; value22 = v[21]; value23 = v[22]; value24 = v[23]; value25 = v[24];
    value26 = v[25]; value27 = v[26]; value28 = v[27]; value29 = v[28]; value30 = v[29];
    value31 = v[30]; value32 = v[31]; value33 = v[32]; value34 = v[33]; value35 = v[34];
    value36 = v[35]; value37 = v[36]; value38 = v[37]; value39 = v[38]; value40 = v[39];
    value41 = v[40]; value42 = v[41]; value43 = v[42]; value44 = v[43]; value45 = v[44];
    value46 = v[45]; value47 = v[46]; value48 = v[47]; value49 = v[48]; value50 = v[49];
    value51 = v[50]; value52 = v[51]; value53 = v[52]; value54 = v[53]; value55 = v[54];
    value56 = v[55]; value57 = v[56]; value58 = v[57]; value59 = v[58]; value60 = v[59];
    value61 = v[60]; value62 = v[61]; value63 = v[62]; value64 = v[63]; value65 = v[64];
    value66 = v[65]; value67 = v[66]; value68 = v[67]; value69 = v[68]; value70 = v[69];
    return;
}

/* g_module_check_init is automatically executed upon loading */
G_MODULE_EXPORT const gchar* g_module_check_init(GModule *module) {
    g_log(DRIP_LD,G_LOG_LEVEL_DEBUG,"Plugin: magickfilter selftest passed");
    return NULL;
}

} //extern "C"


