require 'drb/drb'
require 'drb/extserv'
require 'timeout'

class DRbEx
  include DRbUndumped

  class FooBar
    def initialize
      @foo = 'bar'
    end
  end

  class UError < RuntimeError; end

  def initialize
    @hello = 'hello'
  end
  attr_reader :hello

  def sample(a, b, c)
    a.to_i + b.to_i + c.to_i
  end

  def sum(*a)
    s = 0
    a.each do |e|
      s += e.to_i
    end
    s
  end

  def do_timeout(n)
    timeout(1) do
      n.sleep(2)
    end
  end

  def unknown_obj
    FooBar.new
  end

  def unknown_error
    raise UError
  end

  def test_yield
    yield
    yield([])
    yield(*[])
  end

  def echo_yield(*arg)
    yield(*arg)
    nil
  end

  def echo_yield_0
    yield
    nil
  end

  def echo_yield_1(one)
    yield(one)
    nil
  end

  def echo_yield_2(one, two)
    yield(one, two)
    nil
  end
end

if __FILE__ == $0
  def ARGV.shift
    it = super()
    raise "usage: #{$0} <manager-uri> <name>" unless it
    it
  end

  DRb::DRbServer.default_argc_limit(8)
  DRb::DRbServer.default_load_limit(1024)
  DRb.start_service(nil, DRbEx.new)
  es = DRb::ExtServ.new(ARGV.shift, ARGV.shift)
  DRb.thread.join
end

