/* HP560C Tools */
/* by Michael Janson [michael.janson@stud.uni-karlsruhe.de] */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define VERSION "1.2.3" 

void help(void);
void send(char *escape);
void opts(int argc,char *argv[]);
void promt();
void open_device();

FILE *device;
int  verbose=1;
char *choosen_device=DEVICE;
char *prtvect[256][2] =
	{	
		{"test","z"},{"out","&l0H"},{"back","E"},{"cr","&k2G"},{"lbon","&s0C"},
		{"lboff","&s1C"},{"landscape","&l1O"},{"portrait","&l0O"},
		{"italic","(s1S"},{"upright","(s0S"},{"german","(1G"},
		{"english","(1E"},{"ansi","(0U"},{"prop","(s1P"},{"fix","(s0P"},
		{"cpi5","(s5H"},{"cpi6","(s6H"},{"cpi10","(s10H"},
		{"cpi12","(s12H"},{"cpi16","(s16H"},{"cpi16.67","s16.67"},
		{"cpi20","(s20H"},{"cpi24","(s24H"},{"point4.75","s4.75V"},
		{"point6","(s6V"},{"point7","(s7V"},{"point8","(s8V"},
		{"point9.5","(s9.5V"},{"point10","(s10V"},{"point12","(s12V"},
		{"point14","(s14V"},{"point19","(s19V"},{"point24","(s24V"},
		{"bold","(s3B"},{"normal","(s0B"},{"courier","(s3T"},
		{"times","(s4101T"},{"gothic","(s6T"},{"univers","(s52T"},
		{"point5","(s5V"},{"lpi8","&l8D"},{"lpi6","&l6D"},{"leftright","&k0W"},
		{"rightleft","&k2W"},{"bidirect","&k1W"},{"execon","Z"},{"execoff","Y"},
		{"france","(1F"},{"italian","(0I"},{"spain","(2S"},{"sweden","(3S"},
		{"nice","(s2Q"},{"econo","(s1Q"},{NULL,NULL}
	}; 
	
int main(int argc,char *argv[])
{
	int i;
	
	opts(argc, argv);
	open_device();
	if ( optind >= argc ) promt();
	for(i = optind; i < argc; i++) send(argv[i]);	
	fclose(device);
 	return(0);
}

void help(void)
{
	int i;
	
	printf("hpset version %s\n", VERSION);
	printf("michael.janson@stud.uni-karlsruhe.de\n");
	printf("\nusage: hpset [options] [command1 command2 ....]\n");
	printf("\noptions:\n"
		"	-h		Print this help message\n"
		"	-o name	\tRedirect output into the specified file or device\n"
		"	-c 		Write output to stdout (similar to -o stdout)\n");
	printf("\ncommands:\n");
	i = 0;
	while ( !(prtvect[i][1] == NULL) )
	{
		printf("%s ",prtvect[i][0]);
		i++;
	}
	printf("\n");	
}

void send(char *command)
{
	int ok;
	int j;
	
	j = 0;
	ok = 1;

	while ( ok )
	{
		if ( !strcmp(command,prtvect[j][0]) )
		{
			if (verbose) fprintf(stderr, "sending %s command to %s\n",command, choosen_device);
			fprintf( device, "\033%s", prtvect[j][1] );
			ok = 0;
		}
		j++;
		if ( ( prtvect[j][1] == NULL ) && ( ok ) )
		{
			fprintf(stderr, "unknown command %s\n", command);
			ok = 0;
		}
	}
}

void opts(int argc, char *argv[])
{
	int o;
	
	while( ( o = getopt( argc, argv,"ho:c" ) ) != -1)
	{
		switch(o)
		{
			case 'h':
				help();
				exit(0);
				break;
			case 'o':
				choosen_device = optarg;
				break;
			case 'c':
				choosen_device = "stdout";
				break;					
			default:
				fprintf(stderr, "Option -h gives a list of available commands.\n\n");
				exit(-1);
		}
	}	
}

void promt()
{
	char *t,line[256];
	int file_in;
	
	verbose = 1;
	file_in = isatty(fileno(stdin));
	if (file_in) fprintf(stderr, "hpset>");
	fgets(line, 255, stdin);
        t = line;
	while(!feof(stdin))
	{
		strtok(t," ");
		if ( ( !strcmp(t, "exit")) || (!strcmp(t, "quit")) )
		{
			fclose(device);
			exit(0);
		}
		if ( !strcmp(t, "help") ) 
			help();
		else
			send(t);
		fflush(device);
		while((t=strtok(NULL," ")) != NULL)
		{
			if ( !strcmp(t, "help") ) 
				help();
			else
				send(t);
			if ( ( !strcmp(t, "exit")) || (!strcmp(t, "quit")) )
			{
				fclose(device);
				exit(0);
			}
			fflush(device);
		}
		if (file_in) fprintf(stderr, "hpset>");
		fgets(t=line,255,stdin);
	}
	fclose(device);
	exit(0);
}

void open_device()
{
	if ( !strcmp(choosen_device, "stdout") )
	{
		device = fdopen(dup(fileno(stdout)),"w");
		verbose = 0;
	}
	else
		device = fopen( choosen_device,"a" );
	if(device == 0)
			{
				fprintf(stderr, " could not open device %s \n\n", DEVICE);
				exit(-1);
			}
}
