#!/bin/sh
### BEGIN INIT INFO
# Provides:          distcc
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Should-Start:      $network
# Should-Stop:       $network
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: simple distributed compiler client and server
### END INIT INFO
#
# distccd Debian init.d script contributed by Jason Thomas.  (Debian #161136)
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.9.1  08-Apr-2002  miquels@cistron.nl
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/distccd
NAME=distccd
DESC="Distributed Compiler Daemon"
DAEMON_ARGS="--pid-file=/var/run/$NAME.pid --log-file=/var/log/$NAME.log --daemon"
# please change those variables by overriding them in /etc/defaults/distcc
ALLOWEDNETS=""
LISTENER=""
NICE=""
ZEROCONF=""
JOBS=""

# unset TMPDIR before starting the daemon to avoid problems with
# root's value for this being unwritable by the distccd user; to
# provide distccd with a sensible TMPDIR set it in /etc/default/distcc
unset TMPDIR

set -e

. /lib/lsb/init-functions

# Reads config file (will override defaults above)
[ -r /etc/default/distcc ] && . /etc/default/distcc

test -x $DAEMON || exit 0

# construct access list
ALLOW=""
for net in $ALLOWEDNETS
do
	ALLOW="$ALLOW --allow $net"
done

if test -n "$ALLOW"; then
	DAEMON_ARGS="$DAEMON_ARGS $ALLOW"
fi

if test -n "$LISTENER"; then
	DAEMON_ARGS="$DAEMON_ARGS --listen $LISTENER"
fi

if test -n "$NICE"; then
	if [ "$NICE" -ge 0 ] && [ "$NICE" -le 20 ]; then
		DAEMON_ARGS="$DAEMON_ARGS --nice $NICE"
	fi
fi

if test -n "$JOBS"; then
	DAEMON_ARGS="$DAEMON_ARGS --jobs $JOBS"
fi

if [ "$ZEROCONF" = "true" ] || [ "$ZEROCONF" = "YES" ]; then
	DAEMON_ARGS="$DAEMON_ARGS --zeroconf"
fi

should_start() {
	if [ "$STARTDISTCC" != "true" ] && [ "$STARTDISTCC" != "YES" ]; then
		log_warning_msg "STARTDISTCC is set to false in /etc/default/distcc"
		log_warning_msg "$DAEMON not starting"
		exit 0
	fi
	# we need permission to write to the pid file
	touch /var/run/$NAME.pid
	chown distccd /var/run/$NAME.pid
}

case "$1" in
  start)
	should_start
	log_begin_msg "Starting $DESC: $NAME"
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
	--chuid distccd --oknodo \
	--exec $DAEMON -- $DAEMON_ARGS ||
	{
	    code=$?
	    log_warning_msg "$0: start failed with error code $code" >&2
	    log_end_msg $code
	    exit $code
	}
	log_end_msg 0
	;;
  stop)
	log_begin_msg "Stopping $DESC: $NAME"
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
		--oknodo \
		--exec $DAEMON ||
	{
	    code=$?
	    log_warning_msg "$0: stop failed with error code $code" >&2
	    log_end_msg $code
	    exit $code
	}
	rm -f /var/run/$NAME.pid >/dev/null 2>&1
	log_end_msg 0
	;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	log_begin_msg "Restarting $DESC: $NAME"
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
		--oknodo \
		--exec $DAEMON
	sleep 1
	should_start
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--chuid distccd \
		--exec $DAEMON -- $DAEMON_ARGS ||
	{
	    code=$?
	    rm -f /var/run/$NAME.pid >/dev/null 2>&1
	    log_warning_msg "$0: restart failed with error code $code" >&2
	    log_end_msg $code
	    exit $code
	}
	log_end_msg 0
	;;
  status)
	status_of_proc $DAEMON $NAME
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload|status}" >&2
	exit 1
	;;
esac

exit 0
