package imagedir;
use strict;
use error;
use diskless;
1;

# create a new object
sub new {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self = {
		imagedir => undef,
        };
        bless($self,$class);
        return $self;
}

# Create object if it doesn't exist
sub create
{
	my $class=$_[0];
	my $imagedir=$_[1];
	my $error=$_[2];
	my $rc;

	die if (!ref($error) or defined ($$error));

	if ( !($imagedir =~ /^\//) or $imagedir eq "/" )
	{
		$$error="error"->new("error"->general,
			"Paranoid check: Attempt to create NFS-Root image with relative or root path");
		return undef;
	}

	if ( -d $imagedir )
	{
		$$error="error"->new("error"->alreadyexists,
			"Attempt to create NFS-Root image when directory already exists");
		return undef;
	}

	if ( ! -f "base.tgz")
	{
		$$error="error"->new("error"->general,
			"Cannot find base.tgz");
		return undef;
	}

	my @imagedeb = <diskless-image-*.deb>;
	if ($#imagedeb < 0)
	{
		$$error="error"->new("error"->general,
			"diskless-image-*.deb cannot be found");
		return undef;
	}
	if ($#imagedeb >= 1)
	{
		$$error="error"->new("error"->general,
			"more then one diskless-image-*.deb found");
		return undef;
	}
	my $imagedeb = $imagedeb[0];
	print "Will use base.tgz and $imagedeb\n";
	
#	$rc = "diskless"->mymkdir("$imagedir",$error);
#	return undef if (!$rc);

	$rc=system("mkdir","-p",$imagedir);
	if ($rc)
	{
		$$error = "error"->process("Error executing mkdir",$?);
		return(0);
	}

	my $isbuffered = $|; $| = 1;
	print "Extracting base.tgz to $imagedir...";
	$| = $isbuffered;
	$rc=system("tar","-C",$imagedir,"-xzf","base.tgz");
	if ($rc)
	{
		$$error = "error"->process("Error executing tar",$?);
		return(0);
	}
	print "done.\n";

	$rc = "diskless"->mymkdir("$imagedir/etc/diskless-image",$error);
	return undef if (!$rc);

	$rc=system("dpkg","--root",$imagedir,"-i",$imagedeb);
	if ($? != 0)
	{
		$$error = "error"->process("Error executing dpkg",$?);
		return(0);
	}

	my $self=$class->get($imagedir,$error);
	return $self;
}


sub config
{
	my $self=$_[0];
	my $options = shift;
	my $error=$_[1];

	die if (!ref($error) or defined ($$error));

	my $imagedir = $self->get_dirname_imagedir;

	# !!!FIXME!!! package is not called diskless-image!
	# How to fix? I don't know...

	system("chroot",$imagedir,"/usr/sbin/configure-diskless-image");
	if ($? != 0)
	{
		$$error = "error"->process("Error executing chroot",$?);
	}

	return(1);
}

# get non-usable settable option that is frequently required
sub get_dirname_usrtemplate
{
        my $self=shift;
        return $self->{"imagedir"}."/usr/lib/diskless-image/template";
}

sub get_filename_usrtemplaterules
{
        my $self=shift;
        return $self->{"imagedir"}."/usr/lib/diskless-image/rules-template";
}

sub get_dirname_imagedir
{
        my $self=shift;
        return $self->{"imagedir"};
}

sub get_filename_imagedirrules
{
        my $self=shift;
        return $self->{"imagedir"}."/usr/lib/diskless-image/rules-image";
}

sub get_filename_config
{
        my $self=shift;
        return $self->{"imagedir"}."/etc/diskless-image/config";
}

sub get_filename_configm4
{
        my $self=shift;
        return $self->{"imagedir"}."/etc/diskless-image/config.m4";
}

sub get_dirname_host
{
        my $self=shift;
	my $ip=shift;
        return $self->{"nfshostsdir"}."/$ip";
}


# Get object, if it exists
sub get
{
	my $class=$_[0];
	my $imagedir=$_[1];
	my $error=$_[2];

	die if (!ref($error) or defined ($$error));

	my $rc;

	if ( ! -d $imagedir )
	{
		$$error="error"->new("error"->notfound,
			"Group directory $imagedir does not exist");
		return undef;
	}

	if ( ! -d "$imagedir/etc/diskless-image" )
	{
		$$error="error"->new("error"->general,
			"Not an NFS-root image directory: $imagedir/etc/diskless-image doesn't exist or isn't a directory");
		return undef;
	}

	my $self=$class->new;
	$self->{"imagedir"} = $imagedir;

	my $config = $self->get_filename_config;
	if ( ! -f $config )
	{
		return $self;
	}

	$rc = open(FILE,$config);
	if (!$rc)
	{
		$$error="error"->new("error"->general,
			"Cannot open $config for reading: $!");
		return undef;
	}
	while (<FILE>)
	{
		if (!(/^([A-Za-z_0-9]+)=(.*)/))
		{
			$$error="error"->new("error"->general,
				"$config contains an invalid entry");
			return undef;
		}
		$self->{$1} = $2;
	}

	$rc = close(FILE);
	if (!$rc)
	{
		$$error="error"->new("error"->general,
			"Cannot close $config: $!");
		return undef;
	}
	return $self;
}
