/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "serial.h"
#include "utils.h"


/* Copyrigt (c) RedHat Sotfware */
int find_legacy_mouse(int fd){
  int modem_lines;
  int temp;
  int done;
  int starttime;
  unsigned char resp[2];
  struct timeval timo;
  struct termios portattr;

  temp = get_serial_attr(fd, &portattr);
  if(temp < 0){
    return 1;
  }/*endif*/
  temp = setup_serial_port(fd, 7, &portattr);
  if(temp < 0){
    return 1;
  }/*endif*/

  modem_lines = get_serial_lines(fd);
  modem_lines &= ~(TIOCM_RTS | TIOCM_DTR);
  set_serial_lines(fd, modem_lines);
  usleep(200000);

  modem_lines |= TIOCM_DTR | TIOCM_RTS;
  set_serial_lines(fd, modem_lines);

  done = 0;
  starttime = time(NULL);
  while(!done){
    timo.tv_sec = 0;
    timo.tv_usec = 250000;
    if(wait_for_input(fd, &timo) > 0){
      temp = read(fd, resp, 1);
      if(temp < 0){
        if(errno != EAGAIN){
          return 1;
	}/*endif*/
      }else{
        done = 1;
      }/*endif*/
    }else{
      done = 1;
    }/*endif*/
    if(time(NULL) - starttime > 2){
      done = 1;
    }/*endif*/
  }/*endwhile*/

  if(*resp == 'M'){
    return 3;
  }else{
    return 2;
  }/*endif*/
}/*endfunc find_legacy_mouse*/


struct mouse_info *mouse_detect(struct bus_lst *bus){
  struct mouse_info *result = (struct mouse_info *)NULL;
  struct serial_info *serial = (struct serial_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  static struct mouse_info *first = (struct mouse_info *)NULL;
  int fd, temp;
  struct termios origattr;

  if(first){
    return first;
  }/*endif*/

  if(debug)
    fprintf(stdout, "\nProbing mouse...\n");

 /********************************************************************/
 /************************** USB MOUSE  ******************************/
 /********************************************************************/
 if(debug)
   fprintf(stdout, "\tProbing USB mouse...\n");

  for(usb = bus->usb; usb; usb = usb->next){
    if(usb->type == MOUSE){
      if(!first){
        first = result = (struct mouse_info *)
                                   my_malloc(sizeof(struct mouse_info));
      }else{
        result->next = (struct mouse_info *)
                                   my_malloc(sizeof(struct mouse_info));
        result = result->next;
      }/*endif*/
      result->next = (struct mouse_info *)NULL;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->device = s_not_available;
      result->module = usb->modulename;
      result->bus = USB;
      if(debug)
	fprintf(stdout, "\t\tFound %s", result->model);
    }/*endif*/
  }/*next usb*/
  
  
  /********************************************************************/
  /******************** PS/2 MOUSE DETECTION **************************/
  /********************************************************************/

  if(debug)
    fprintf(stdout, "\tProbing PS/2 mouse...\n");

  fd = open("/dev/psaux", O_RDONLY | O_NONBLOCK);

  if(fd >= 0){
    close(fd);
    if(!first){
      first = result = (struct mouse_info *) 
                                   my_malloc(sizeof(struct mouse_info));
    }else{
      result->next = (struct mouse_info *) 
                                   my_malloc(sizeof(struct mouse_info));
      result = result->next;
    }/*endif*/
    result->next = (struct mouse_info *)NULL;
    result->vendor = s_unknown;
    result->model = s_unknown;
    result->device = "/dev/psaux";
    result->module = s_ignore;
    result->bus = PS2;
    if(debug)
      fprintf(stdout, "\t\tFound on %s\n", result->device);
  }/*endif*/
  
  
  /********************************************************************/
  /******************** SERIAL MOUSE DETECTION ************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing serial mouse...\n");
  
  for(serial = bus->serial; serial; serial = serial->next){
    if((fd = open_serial_port(serial->device)) < 0){
      continue;
    }/*endif*/
    temp = get_serial_attr(fd, &origattr);
    if(temp < 0){
      continue;
    }/*endif*/
    temp = find_legacy_mouse(fd);
    if(temp == 3){
      if(!first){
        first = result = (struct mouse_info *) 
                                   my_malloc(sizeof(struct mouse_info));
      }else{
       	result->next = (struct mouse_info *) 
                                   my_malloc(sizeof(struct mouse_info));
        result = result->next;
      }/*endif*/
      result->next = (struct mouse_info *)NULL;
      result->vendor = s_unknown;
      result->model = s_unknown;
      result->device = serial->device;
      result->module = s_ignore;
      result->bus = SERIAL;
      if(debug)
	fprintf(stdout, "\t\tFound on %s\n", result->device);
    }/*endif*/
    set_serial_attr(fd, &origattr);
    close_serial_port(fd);
  }/*next serial*/
  return first;
}/*endfunc mouse_detect*/
