/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <sys/ioctl.h>
#include <linux/fd.h>

#include "discover.h"
#include "utils.h"


extern struct floppy_info *floppy_detect(struct bus_lst *bus){
  struct ide_info *ide = (struct ide_info *)NULL;
  struct scsi_info *scsi = (struct scsi_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  struct floppy_info *result = (struct floppy_info *)NULL;
  static struct floppy_info *first = (struct floppy_info *)NULL;
  char drivtyp[17];
  int fid;
  int tmp;
  char *floppy_dev[] = {
    "/dev/fd0",
    "/dev/fd1",
    NULL
  };
 
#if defined(__PPC__)
  FILE *fd;
  char *line;
  char *file;
  char *folder;
  size_t len = 0;
  char *ppc_dev;
  int i;

  char *ppc_fd_dev[] = {
    "/proc/device-tree/aliases/fd",
    NULL
  };
#endif


  if (first){
    return first;
  }/*endif*/

  if(debug)
    printf(_("\nProbing floppy drive...\n"));


  /********************************************************************/
  /*********************** FDC FLOPPY DRIVE ***************************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing FDC floppy drive...\n"));

  for(tmp = 0; floppy_dev[tmp] != NULL; tmp++){
    fid = open(floppy_dev[tmp], O_ACCMODE | O_RDONLY);
    if(fid < 0){
      fprintf(stderr, FOPEN_READ_ERROR, floppy_dev[tmp]);
    }else{
      if(ioctl(fid, FDGETDRVTYP, (void *)drivtyp)){
        fprintf(stderr, IOCTL_ERROR);
      }else{
        if(strcmp(drivtyp, "(null)")) {
          if(!first){
            first = result = (struct floppy_info *)
                                  my_malloc(sizeof(struct floppy_info));
      	  }else{
            result->next = (struct floppy_info *)
                                  my_malloc(sizeof(struct floppy_info));
            result = result->next;
      	  }/*endif*/
      	  result->next = (struct floppy_info *)NULL;

          result->vendor = s_unknown;
          result->device = floppy_dev[tmp]; 
          result->bus=FDC;

          if(!strcmp(drivtyp, "H1440")){
            result->model="1.44MB 3.5\"";
          }else{
            result->model = s_unknown;
          }/*endif*/
	  if(debug)
	    fprintf(stdout, _("\t\tFound %s on %s\n"), 
		    result->model, result->device);

        }/*endif*/
      }/*endif*/
      close(fid);
    }/*endif*/
  }/*next tmp*/



 /********************************************************************/
 /*********************** USB FLOPPY DRIVE ***************************/
 /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing USB floppy drive...\n");

	
    for(usb = bus->usb; usb; usb = usb->next) {
      if(usb->type == FLOPPY) {
	if(!first){
	  first = result = (struct floppy_info *)
	                         my_malloc(sizeof(struct floppy_info));
	}else{
	  result->next = (struct floppy_info *)
	                         my_malloc(sizeof(struct floppy_info));
	  result = result->next;
	}/*endif*/
	result->next = (struct floppy_info *)NULL;
        result->vendor = usb->vendor;
	result->device = s_not_available;
	result->model = usb->model;
	result->bus = USB;
	if(debug)
	  printf(_("\t\tFound %s"), result->model);
      }/*endif*/
    }/*next usb*/
		

		
  /********************************************************************/
  /********************** ATAPI FLOPPY DRIVE **************************/
  /********************************************************************/
    if(debug)
      printf(_("\tProbing IDE floppy drive...\n"));

    for(ide = bus->ide; ide; ide = ide->next) {
      if(ide->type == FLOPPY) {
        if(!first){
          first = result = (struct floppy_info *)
                                  my_malloc(sizeof(struct floppy_info));
        }else{
            result->next = (struct floppy_info *)
                                  my_malloc(sizeof(struct floppy_info));
            result = result->next;
        }/*endif*/
        result->next = (struct floppy_info *)NULL;

        /* IDE Floppy drive can be ZIP, LS120 etc ... */
        if(strstr(ide->model, "IOMEGA ZIP")){
          result->vendor = "IOMEGA";
        }else{
          result->vendor = s_unknown;			
        }/*endif*/
        result->model = ide->model;
        result->device = ide->device;
        result->bus = IDE;
	if(debug)
	  printf(_("\t\tFound %s on %s\n"), 
		  result->model, result->device);
      }/*endif*/
    }/*next usb*/

  /********************************************************************/
  /*********************** SCSI FLOPPY DRIVE **************************/
  /********************************************************************/
    if(debug)
      printf(_("\tProbing SCSI floppy drive...\n"));

    for(scsi = bus->scsi; scsi; scsi = scsi->next){
      if(scsi->type == FLOPPY){
        if(!first){
          first = result = (struct floppy_info *) 
                                  my_malloc(sizeof(struct floppy_info));
        }else{
          result->next = (struct floppy_info *)
                                  my_malloc(sizeof(struct floppy_info));
          result = result->next;
        }/*endif*/
        result->next = (struct floppy_info *)NULL;
        result->vendor = scsi->vendor;
        result->model = scsi->model;
        result->device = scsi->device;
        result->bus = SCSI;
	if(debug)
	  printf(_("\t\tFound %s on %s\n"), 
		 result->model, result->device);
      }/*endif*/
    }/*next scsi*/

#if defined(__PPC__)
  /********************************************************************/
  /****************** PowerPC FLOPPY-INTERFACE DETECTION **************/
  /********************************************************************/
    if(debug)
      printf(_("\tProbing PowerPC interface...\n"));

    i = 0;
  for(ppc_dev = ppc_fd_dev[i]; ppc_dev != NULL;
                                          i++, ppc_dev = ppc_fd_dev[i]){
    fd = fopen(ppc_dev, "r");
    if(fd == (FILE *)NULL){
      if(debug)
	fprintf(stderr, FOPEN_READ_ERROR, ppc_dev);
    }else{
      line = 0; len = 0;
      getline(&line, &len, fd);
      fclose(fd);
      folder = my_malloc((sizeof(line) * strlen(line) + 20));
      sprintf(folder, "%s%s", "/proc/device-tree", line);
      if(!first){
        first = result = (struct floppy_info *)
                                my_malloc((sizeof(struct floppy_info)));
      }else{
        result->next = (struct floppy_info *)
                                my_malloc((sizeof(struct floppy_info)));
        result = result->next;
      }/*endif*/
      result->next = (struct floppy_info *)NULL;

      result->vendor = "Apple";
      result->bus = UNKNOWN_BUS;
      result->device = floppy_dev[i];

      file = my_malloc(sizeof(folder) * strlen(folder) + 15);
      sprintf(file, "%s/model", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->model = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->model = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->model, line);
        fclose(fd);
      }/*endif*/
      sprintf(file, "%s/name", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->module = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->module = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->module, line);
        fclose(fd);
      }/*endif*/

      if(debug)
	fprintf(stdout, _("\t\tFound %s %s\n"),
		result->vendor, result->model);
      free(line); line=0;
      free(file); file=0;
    }/*endif*/
  }/*next ppc_dev*/
#endif

  return first;
}/*endfunc floppy_detect*/
