/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/major.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <scsi/scsi.h>
#include <scsi/scsi_ioctl.h>
#include <string.h>
#include <unistd.h>
#include <linux/hdreg.h>
#include <linux/genhd.h>

#include "discover.h"
#include "utils.h"


extern struct disk_info *disk_detect(struct bus_lst *bus){
  struct ide_info *ide = (struct ide_info *)NULL;
  struct scsi_info *scsi = (struct scsi_info *)NULL;
  struct disk_info *result = (struct disk_info *)NULL;
  static struct disk_info *first = (struct disk_info *)NULL;
  int fd;
  unsigned char idlun[8];
  struct hd_geometry geometry;
   
  if(first){
    return first;
  }/*endif*/
  
  if(debug){
    printf("\nProbing disk and partitions...\n");
  }/*endif*/
  /********************************************************************/
  /********************** Probing IDE disk ****************************/
  /********************************************************************/
  if(debug){
    printf("\tProbing IDE disk...\n");
  }/*endif*/
  for(ide = bus->ide; ide; ide = ide->next){
    if(ide->type == DISK){
      if(!first){
        first = result = (struct disk_info *) 
                                    my_malloc(sizeof(struct disk_info));
      }else{
        result->next = (struct disk_info *) 
                                    my_malloc(sizeof(struct disk_info));
        result = result->next;
      }/*endif*/
      result->next = (struct disk_info *)NULL;
      result->vendor = s_unknown;
      result->model = ide->model;
      result->device = ide->device;
      result->bus = IDE;
      result->heads = ide->heads;
      result->sectors = ide->sectors;
      result->cylinders = ide->cylinders;
      result->size = result->sectors * result->cylinders * 
                                                          result->heads;
      if(debug){
        printf(_("\t\tFound %s %s on %s\n"), 
                         result->vendor, result->model, result->device);
      }/*endif*/
    }/*endif*/
  }/*next ide*/

  /********************************************************************/
  /********************** Probing SCSI disk ***************************/
  /********************************************************************/
  if(debug){
    printf("\tProbing SCSI disk...\n");
  }/*endif*/
  for(scsi = bus->scsi; scsi; scsi = scsi->next){
    if(scsi->type == DISK){
      if(!first){
        first = result = (struct disk_info *) 
                                    my_malloc(sizeof(struct disk_info));
      }else{
        result->next = (struct disk_info *) 
                                    my_malloc(sizeof(struct disk_info));
        result = result->next;
      }/*endif*/
      result->next = (struct disk_info *)NULL;
      result->vendor = scsi->vendor;
      result->model = scsi->model;
      result->device = scsi->device;
      result->bus = SCSI;
      result->heads = -1;
      result->sectors = -1;
      result->cylinders = -1;
      result->size = -1; 
      result->did = -1;
      result->host = -1;
      result->path = strdup(scsi->device);
      if((fd = open(scsi->device, O_RDONLY))){
        if((!ioctl(fd, SCSI_IOCTL_GET_IDLUN, idlun)) &&
           (!ioctl(fd, HDIO_GETGEO, &geometry))){
          result->heads = geometry.heads;
          result->sectors = geometry.sectors;
          result->cylinders = geometry.cylinders;
          result->size = result->sectors * result->cylinders * 
                                                          result->heads;
          result->did = idlun[0];
          result->host = *((unsigned long *) (idlun + 4));
        }/*endif*/
        close(fd);
      }/*endif*/
      if(debug){
        printf("\t\tFound %s %s on %s\n", 
                         result->vendor, result->model, result->device);
      }/*endif*/
    }/*endif*/
  }/*next scsi*/
  return first;
}/*endifunc disk_detect*/
