/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/marshaling.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::internal::read and @ref
 * ::diagnostics::internal::write -- is only used internally. Do not
 * use directly. This methods are used to read and write some data
 * structures platform-independently.
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UTIL__MARSHALING_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__MARSHALING_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

// used in the interface by reference
#include <iostream>

// used in the interface by reference
#include <string>

// used in the interface by reference
#include <map>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

bool read(::std::istream & stream, unsigned long & target);
void write(::std::ostream & stream, unsigned long source);

bool read(::std::istream & stream, ::std::string & target);
void write(::std::ostream & stream, ::std::string const & source);

bool read(::std::istream & stream, ::std::map< ::std::string, ::std::string> & target);
void write(::std::ostream & stream, ::std::map< ::std::string, ::std::string> const & source);


INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
