/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/assert_record.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief @ref TEST_ASSERT_RECORD and @ref TEST_ASSERT_RECORD1
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__ASSERT_RECORD_TS___INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__ASSERT_RECORD_TS___INCLUDE_GUARD

#include <diagnostics/frame/record.hpp>

#define TEST_ASSERT_RECORD(LEVEL,TYPE,NR_WHAT,STR_WHAT,BASE,FILE,LINE) do {\
    TEST_ASSERT(current->level()==(LEVEL)); \
    TEST_ASSERT(current->type()==(TYPE)); \
    TEST_ASSERT(current->nr_what()==(NR_WHAT)); \
    TEST_ASSERT(current->str_what()==(STR_WHAT)); \
    TEST_ASSERT(current->base_file_name()==(BASE)); \
    TEST_ASSERT(current->file_name()==(FILE)); \
    TEST_ASSERT(current->line()==(LINE)); } while(false)

#define TEST_ASSERT_RECORD1(LEVEL,TYPE,NR_WHAT,STR_WHAT) do {\
    TEST_ASSERT(current->level()==(LEVEL)); \
    TEST_ASSERT(current->type()==(TYPE)); \
    TEST_ASSERT(current->nr_what()==(NR_WHAT)); \
    TEST_ASSERT(current->str_what()==(STR_WHAT)); } while(false)

#endif
// vim:ts=4:sw=4
