#include "includes.h"
#include "dhcp_options.h"


void option_handler (DHCO dhc, DHC_Option* o, void *value, int length, char *prefix, void *param)
{
    char *output=0L;
    printf("Option Handler: Got option %s prefix:%s code:%d type:%s length:%d v:%p\n", 
	   o->name, prefix, o->code, o->type, length, value
	  );
    
    if( dhco_output_option(dhc, o, value, length, &output, 0 ) && output )
	printf("OUTPUT option: %s\n",output);
}

uint8_t type_mapping[    DHC_N_ATOMIC_TYPES ] =
{   /*   DHC_M_NONE        */  '\0',
    /*   DHC_M_IP_ADDRESS  */  'u',
    /*   DHC_M_HEX_STRING  */  'S',
    /*   DHC_M_TEXT        */  's',
    /*   DHC_M_DOMAIN_NAME */  's',
    /*   DHC_M_INT32       */  'u',
    /*   DHC_M_UINT32      */  'u',
    /*   DHC_M_INT16       */  'n',
    /*   DHC_M_UINT16      */  'q',
    /*   DHC_M_CHAR        */  'y',
    /*   DHC_M_UCHAR       */  'y',
    /*   DHC_M_BOOL        */  'y',
    /*   DHC_M_IMPLICIT_BOOL*/ 'y'
};

void mapping_handler( uint8_t code, uint8_t dhc_code , void *value, unsigned length, void *arg )
{
    printf("Map: code: %c value: %p length: %d\n", code, value,length);
}

int main(int argc, char **argv, char **envp)
{
    DHC_Option *opt;
    DHC_Universe *u;
    DHCO dhc = dhco_new( printf );
    void *value=0L;
    char data[]="172.16.83.254 172.16.80.118 172.16.80.119", a1[16],a2[16],a3[16];
    char route_str[]="172.16.80.0 22 172.16.83.254 0x100 0x200 1 0x12345678";
    char jo_str[]="jvdsibm 6a:61:73:6f:6e:01:02:03:04:05:06:07";
    unsigned olen;
    char *output=0L;
    DHCP_Option_Type_Mapping mapping = 0L;
    unsigned r;    
    char settings[]="interface=eth0\n"
	            "reason=BOUND\n"
	            "old_ip_address=172.16.80.40\n"
	            "new_ip_address=172.16.80.40\n"
	            "old_subnet_mask=255.255.252.0\n"
	            "new_subnet_mask=255.255.252.0\n"
	            "old_routers=172.16.83.254 172.16.80.118\n"
	            "new_routers=172.16.83.254 172.16.80.118\n"
	            "old_domain_name=boston.redhat.com\n"
	            "new_domain_name=boston.redhat.com\n"
                    "old_dhcp.domain_name_servers=172.16.76.10 172.16.52.28\n"
                    "new_dhcp.domain_name_servers=172.16.76.10 172.16.52.28\n"
	            "new_redhat.dhcp_type=3\n"
	            "new_redhat._universe_.dhcp_type=1:l\n"
	            "new_redhat.servers=172.16.80.118 172.16.80.119\n"
	            "new_redhat._universe_.servers=2:IA\n"
   ;

    struct my_s 
    {
	struct in_addr i1;
	struct in_addr i2;
	struct in_addr i3;	
    } s;

    struct new_route
    {
	struct   in_addr net;
	uint8_t  mask_bits;
	struct   in_addr router;
	uint16_t priority;
	uint16_t other;
	uint8_t  table;	
	uint32_t flags;
    } route;
    
    struct jo{ struct in_addr ip; uint8_t s[0]; };
    struct jo *jop;
    void *jvpp[1]={&jop};

    if ( dhc == 0L )
    {
	printf("dhco_new failed\n");
	return(1);
    }
    
    if( (u = dhco_find_universe_by_name(dhc, "dhcp")) != 0L)
    {
	printf("DHCP universe: %p %s\n", u, u->name);
    }

    if ( (opt = dhco_find_by_name(dhc, "routers")) == 0L)
    {
	printf("dhco find failed\n");
	return(1);
    }
    printf("routers option: %d %s\n", opt->code, opt->type);
    if ( dhco_find_by_code(dhc, opt->code, DHC_O_Universe) != opt )
    {
	printf("dhco find by code failed\n");
	return (1);
    }
    
    mapping = dhco_new_mapping(dhc, type_mapping);

    value = &s;
    if( ((r=dhco_input_option(dhc, opt, data , &value, sizeof(struct my_s) )) == sizeof(struct my_s) )
      &&(value == &s )
      )
    {
	printf("%s %s %s\n", 
	       inet_ntop(AF_INET, (struct in_addr*)&(s.i1), &a1[0], 16),
	       inet_ntop(AF_INET, (struct in_addr*)&(s.i2), &a2[0], 16),
	       inet_ntop(AF_INET, (struct in_addr*)&(s.i3), &a3[0], 16)
	    );

	output=0L;
	if( ( (olen = dhco_output_option(dhc, opt, &s, r, &output, 0)) > 0 )
	  &&( output != 0L )
	  )
	    printf( "OUTPUT: %d %s\n", olen, output);
	
	dhco_map_option(dhc,opt,value,r,mapping,mapping_handler,0L);

    }else
	printf("Unexpected return value: %d %p\n", r, value);

    opt = dhco_new_option(dhc, (char*)"new_route", 0, "IbIssbL");
    if( opt == 0L )
    {
	printf("dhco_new_option failed\n");
	return 1;
    }
    printf("New Option: %d %d %d\n", opt->code, 
	   dhco_find_by_name(dhc,"new_route")==opt,
	   dhco_find_by_code(dhc,opt->code,DHC_O_Universe) == opt
	);
    printf("&route: %p\n&route.bits:\t%p\n&route.router:\t%p\n&route.priority:\t%p\n&route.table:\t%p\n&route.flags:%p\nsize: %d\n", &route, &route.mask_bits, &route.router,&route.priority, &route.table, &route.flags, sizeof(struct new_route));
    value=&route;    
    if(  ((r=dhco_input_option(dhc, opt, route_str, &value, sizeof(struct new_route))) == sizeof(struct new_route))
       &&(value == &route)
      ) 
    {
	printf("New Route Option: %s %u %s %hx %hx %x %x\n",
	       inet_ntop(AF_INET, (struct in_addr*)&(route.net), &a1[0], 16),
	       route.mask_bits,
	       inet_ntop(AF_INET, (struct in_addr*)&(route.router), &a2[0], 16),
	       route.priority,
	       route.other,
	       route.table,
	       route.flags
	    );

	output=0L;
	if( ( (olen = dhco_output_option(dhc, opt, &route, r, &output, 0)) > 0 )
	  &&( output != 0L )
	  )
	    printf( "OUTPUT: %d %s\n", olen, output);

	dhco_map_option(dhc,opt,(uint8_t*)&route, sizeof(route), mapping, mapping_handler, 0L);

    }else
	printf("Unexpected return value: (%d != %d):%d (%p != %p):%d\n", 
	       r, sizeof(struct new_route), r != sizeof(struct new_route), value, &route, value != &route);

    opt = dhco_new_option(dhc, (char*)"jasons_option", 0, "IX");
    if( opt == 0L )
    {
	printf("dhco_new_option failed\n");
	return 1;
    }
    printf("New Option: %d %d %d\n", opt->code, 
	   dhco_find_by_name(dhc,"jasons_option")==opt,
	   dhco_find_by_code(dhc,opt->code,DHC_O_Universe) == opt
	);
    if(((r=dhco_input_option(dhc, opt, jo_str, jvpp, 0)) > 0 ) && (jop != 0L))
    {
	printf("JO: ip:%s\n", inet_ntop(AF_INET, (struct in_addr*)&(jop->ip), &(a1[0]), 16));
	output=0L;
	if( ( (olen = dhco_output_option(dhc, opt, jop, r, &output, 0)) > 0 )
	  &&( output != 0L )
	  )
	    printf( "OUTPUT: %d %s\n", olen, output);
    }else
	printf("r: %d jop: %p\n",r,jop);

    printf("option settings: %u\n",
	   dhco_parse_option_settings
	   ( dhc, 
	     &(settings[0]),
	     option_handler, 0L
	   )
	);

    printf("\n-\nsettings string:\n%s\n",settings);
    return 0;	    
}
