/* Dynamic Host Configuration Client manager D-BUS Daemon  
 *
 * Copyright © 2006 Red Hat, Inc.  All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions of
 * the GNU General Public License v.2.  This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY expressed or
 * implied, including the implied warranties of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.  You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA. Any Red Hat trademarks that are incorporated in the source code or
 * documentation are not subject to the GNU General Public License and may
 * only be used or replicated with the express permission of Red Hat, Inc.
 *
 * Red Hat Author(s):  Jason Vas Dias
 *                     David Cantrell
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>

#include "dhcdbd.h"

void usage(void) {
    fprintf(stderr,
            "Usage:\n[\t[(-s | -S | --system)\t\t   : use system bus]\n"
            "\t[(-u | -U | --session)             : use session bus]\n"
            "\t[(-n | -N | --no-daemon)]          : don't daemonize if --(system|session) argument given\n"
            "\t[(-d | -D | --dest=) <destination> : set connection destination - default: com.redhat.dhcp]\n"
            "\t[(-o | -O | --path=) <path>        : set object path prefix     - default: /com/redhat/dhcp]\n"
            "\t[(-i | -I | --prefix=) <prefix>    : set interface prefix       - default: com.redhat.dhcp]\n]\n");
}

char dhcdbd_default_dest[] = DHCDBD_DESTINATION;
char *dhcdbd_destination = &(dhcdbd_default_dest[0]);
char dhcdbd_default_path[] = DHCDBD_OBJECT_PATH;
char *dhcdbd_object_path = &(dhcdbd_default_path[0]);
char dhcdbd_default_prefix[] = DHCDBD_INTERFACE_PREFIX;
char *dhcdbd_interface_prefix = &(dhcdbd_default_prefix[0]);
int dhcdbd_daemonize = -1;

int main(int argc, char **argv, char **envp) {
    D_BUS_TYPE bus = D_BUS_STARTER;
    int r;
    char opt_str[] = "UuSsnND:d:O:o:P:p:I:i:", arg;
    struct option options[] = { {"session",0, 0, 'u'},
                                {"system", 0, 0, 's'},
                                {"no-daemon", 0, 0, 'n'},
                                {"dest", 1, 0, 'd'},
                                {"path", 1, 0, 'o'},
                                {"prefix", 1, 0, 'i'},
                                {0L, 0, 0,  0}
                              };

    if (argc > 1) {
        while (((r = getopt_long(argc, argv, opt_str, &(options[0]), 0L)) != -1)
               && ((arg = r) != '\0')) {
            switch (arg) {
                case '?':
                    fprintf(stderr,"Missing option argument.\n");
                    usage();
                    return (1);
                case ':':
                    fprintf(stderr,"Unrecognized option.\n");
                    usage();
                    return (1);
                case 'u':
                case 'U':
                    bus = D_BUS_SESSION;
                    if (dhcdbd_daemonize == -1)
                        dhcdbd_daemonize=1;
                    break;
                case 's':
                case 'S':
                    bus = D_BUS_SYSTEM;
                    if (dhcdbd_daemonize == -1)
                        dhcdbd_daemonize=1;
                    break;
                case 'n':
                    dhcdbd_daemonize=0;
                    break;
                case 'd':
                case 'D':
                    if (optarg == 0L) {
                        fprintf(stderr, "Missing argument for -d option.\n");
                        usage();
                        return (1);
                    }

                    dhcdbd_destination = (char*) malloc(strlen(optarg) + 1);
                    if (dhcdbd_destination == 0L) {
                        fprintf(stderr,"out of memory\n");
                        return (1);
                    }

                    strcpy(dhcdbd_destination, optarg);
                    break;
                case 'o':
                case 'O':
                case 'p':
                case 'P':
                    if (optarg == 0L) {
                        fprintf(stderr, "Missing argument for -o option.\n");
                        usage();
                        return (1);
                    }

                    dhcdbd_object_path = (char*) malloc(strlen(optarg) + 1);
                    if (dhcdbd_object_path == 0L) {
                        fprintf(stderr, "out of memory\n");
                        return (1);
                    }
                    strcpy(dhcdbd_object_path, optarg);
                    break;
                case 'i':
                case 'I':
                    if (optarg == 0L) {
                        fprintf(stderr, "Missing argument for -i option.\n");
                        usage();
                        return (1);
                    }

                    dhcdbd_interface_prefix = (char*)malloc(strlen(optarg) + 1);
                    if (dhcdbd_interface_prefix == 0L) {
                        fprintf(stderr, "out of memory\n");
                        return (1);
                    }

                    strcpy(dhcdbd_interface_prefix, optarg);
                    break;
	     
                default:
                    fprintf(stderr, "Unhandled getopt_long return value: %d\n",
                            r);
                    return (1);
            }
        }
    }

    if (dhcdbd_daemonize == -1)
        dhcdbd_daemonize = 0;
    return dhcdbd_run(bus);
}
