/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef GDK_IMLIB
#include <gdk_imlib.h>
#endif

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include "gtkhelp.h"
#include "string.h"
#include "options.h"
#include "MwmUtil.h"
#include "iconmanager.h"
#include "filemanager.h"
#include <X11/Xatom.h>
#include "shell.h"
#include <stdio.h>
#include "global.h"
#include "stringfunctions.h"
#include "positiontext.h"
#include "iwc.h"
#include <stdlib.h>

#include <time.h>

#include <grp.h>
#include <pwd.h>


char *name;
char **filearray;
int gargc;
char **gargv;
char* winame;
char* defaultback=NULL;
char *position=NULL,*icon=NULL,*start=NULL;
GtkWidget *pixmapwid;
GtkWidget *mainform;
GtkWidget *iconobj;
GtkWidget *wininfobj;
GtkWidget *icoinfobj;
GtkWidget *objname;
GtkWidget *objtime;
GtkWidget *objsize;
GtkWidget *objmode;
GtkWidget *objdesk;
GtkWidget *objtimer;
GtkWidget *objcache;
GtkWidget *objsave;
GtkWidget *objlink;
GtkWidget *objfont;
GtkWidget *objdefback;
GtkWidget *winhide;
GtkWidget *objow,*objor,*objox;
GtkWidget *objgw,*objgr,*objgx;
GtkWidget *objww,*objwr,*objwx;
GtkWidget *objren;
GtkWidget *objax,*objs;
GtkWidget *objay,*obja;
GtkWidget *objbx,*objb;
GtkWidget *objby,*objc;
GtkWidget *objgrid;
GtkWidget *objbottom;
GtkWidget *objright;
GtkWidget *objchangei;
GtkWidget *objchanges;
GtkWidget *objchangeo;
GtkWidget *objchangep;
GtkWidget *objchangem;
GtkWidget *objmforcol;
GtkWidget *objmbaccol;
GtkWidget *objwforcol;
GtkWidget *objwbaccol;
char *mbackcol,*wbackcol;
char *mforecol,*wforecol;

void OptionsExitCallback(GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

void DestroyThis(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(data);
}

void FileselCallbackv(GtkWidget *widget, gpointer data)
{
  GdkPixmap *pixmap=NULL;
  GdkBitmap *mask;
  GtkStyle *style;
  char* zw;
  
  zw=gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
  if (zw!=NULL && zw[0]!=0 && zw[strlen(zw)-1]!='/') {
    free(icon);
    icon=strdup(zw);
    gtk_entry_set_text( GTK_ENTRY(iconobj), icon );
    style = gtk_widget_get_style( mainform );
#ifdef GDK_IMLIB
    gdk_imlib_load_file_to_pixmap(icon, &pixmap, &mask);   
#else
    pixmap = gdk_pixmap_create_from_xpm( mainform->window,  &mask,
                                         &style->bg[GTK_STATE_NORMAL],
                                         (const gchar*)icon );
#endif    
    if (pixmap==NULL) {
      pixmap=gdk_pixmap_new(mainform->window,1,1,XDefaultDepth(GetDisplay(),XDefaultScreen(GetDisplay())));
      mask=gdk_pixmap_new(mainform->window,1,1,1);
    }
    gtk_pixmap_set( GTK_PIXMAP(pixmapwid),pixmap, mask );
    gtk_widget_set_usize(pixmapwid,85,85);
    gdk_pixmap_unref(pixmap);
    if (mask)
    gdk_bitmap_unref(mask);
  }
  gtk_widget_destroy(data);
}

void FileselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *filesel;
  filesel=mygtk_fileselect_new("Select Pixmap",icon);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION(filesel));
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button), 
              "clicked",
              (GtkSignalFunc)FileselCallbackv, (gpointer)filesel);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)filesel);
}

void DefaultFileselCallbackv(GtkWidget *widget, gpointer data)
{
  char* zw;
  
  zw=gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
  if (zw!=NULL && zw[0]!=0 && zw[strlen(zw)-1]!='/') {
    free(defaultback);
    defaultback=strdup(zw);
    gtk_entry_set_text( GTK_ENTRY(objdefback), defaultback );
  }
  gtk_widget_destroy(data);
}

void DefaultFileselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *filesel;
  filesel=mygtk_fileselect_new("Select Default Pixmap",defaultback);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION(filesel));
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button), 
              "clicked",
              (GtkSignalFunc)DefaultFileselCallbackv, (gpointer)filesel);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)filesel);
}

void ColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&icon);
  gtk_entry_set_text( GTK_ENTRY(iconobj),icon);
  gtk_widget_destroy(data);
}

void ColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(icon,"Background Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)ColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void DefaultColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&defaultback);
  gtk_entry_set_text( GTK_ENTRY(objdefback),defaultback);
  gtk_widget_destroy(data);
}

void DefaultColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(defaultback,"Default Background Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)DefaultColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void MFColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&mforecol);
  gtk_label_set( GTK_LABEL(GTK_BUTTON(objmforcol)->child),mforecol);
  gtk_widget_destroy(data);
}

void MFColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(mforecol,"Desktop Font Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)MFColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void WFColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&wforecol);
  gtk_label_set( GTK_LABEL(GTK_BUTTON(objwforcol)->child),wforecol);
  gtk_widget_destroy(data);
}

void WFColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(wforecol,"Window Font Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)WFColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void MBColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&mbackcol);
  gtk_label_set( GTK_LABEL(GTK_BUTTON(objmbaccol)->child),mbackcol);
  gtk_widget_destroy(data);
}

void MBColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(mbackcol,"Desktop Font Background Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)MBColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void WBColorselCallbackv(GtkWidget *widget, gpointer data)
{
  mygtk_getcolor(data,&wbackcol);
  gtk_label_set( GTK_LABEL(GTK_BUTTON(objwbaccol)->child),wbackcol);
  gtk_widget_destroy(data);
}

void WBColorselCallback(GtkWidget *widget, gpointer data)
{
  GtkWidget *colorsel;
  colorsel=mygtk_colorselect_new(wbackcol,"Window Font Background Color");
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->ok_button), 
              "clicked",
              (GtkSignalFunc)WBColorselCallbackv, (gpointer)colorsel);
  gtk_signal_connect(GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colorsel)->cancel_button), 
              "clicked",
              (GtkSignalFunc)DestroyThis, (gpointer)colorsel);
}

void EraseCallback(GtkWidget *widget, gpointer data)
{
  free(icon);
  icon=NULL;
  gtk_entry_set_text( GTK_ENTRY(iconobj), "" );
}

void WindowApplyCallback(GtkWidget *widget, gpointer data)
{
  Window updwin;
  char *text;
  char *pos,*dummy,*endpos;

  GetFileInfoFromDesktop(winame,&pos,&dummy,&endpos);
  free(dummy);
  if (pos!=NULL) {
  if (GTK_TOGGLE_BUTTON(winhide)->active)
    pos[0]=' ';
  else
    pos[0]='a';
  }
  EraseFileInfoInDesktop(winame);  
  SendFileInfoToDesktop(winame,pos,icon,endpos);
  free(pos);
  free(endpos);
  
  if (GTK_TOGGLE_BUTTON(wininfobj)->active)
    SetWindowSaveStatus(name,True);
  else
    SetWindowSaveStatus(name,False);
  if (GTK_TOGGLE_BUTTON(icoinfobj)->active)
    SetIconSaveStatus(name,True);
  else
    SetIconSaveStatus(name,False);

  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(winame);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);

  text=GenerateWindowName(name,DETAIL);
  /*XGrabServer(GetDisplay()); 2x grabserver doesn't work with gtk ?!*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);

  text=GenerateWindowName(name,STRUCTURE);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);
}

void WindowOptions(int argc,char *argv[])
{
  GtkWidget *obj;
  GtkWidget *table;
  char* text;

  GdkPixmap *pixmap=NULL;
  GdkBitmap *mask;
  GtkStyle *style;
  
#ifdef GDK_IMLIB
  gdk_imlib_init();
#endif

  text=CutHomeDir(argv[2]);
  name=malloc(strlen(text)+2);
  strcpy(name,text);
  free(text);
  if (name[strlen(name)-1]!='/')
    strcat(name,"/");
  if (name[0]=='.' && name[1]=='/')
    name[0]='~';
  text=malloc(strlen("Window:")+strlen(name)+1);
  strcpy(text,"Window:");
  strcat(text,name);

  winame=GenerateWindowName(name,NORMAL);
  GetFileInfoFromDesktop(winame,&position,&icon,
			       &start);
  
  mainform = gtk_window_new (GTK_WINDOW_DIALOG);
  table=mygtk_setwindowsize(mainform,370,280);
  gtk_window_position(GTK_WINDOW(mainform),GTK_WIN_POS_CENTER);
  gtk_widget_show( mainform ); /*nessesary because style*/

  obj = gtk_button_new();
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (FileselCallback), (gpointer) "FSelect");
  mygtk_setposition(table,obj,270,60,90,90);

  style = gtk_widget_get_style( mainform );
  if (icon)
#ifdef GDK_IMLIB
  gdk_imlib_load_file_to_pixmap(icon, &pixmap, &mask);   
#else
  pixmap = gdk_pixmap_create_from_xpm( mainform->window,  &mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (const gchar*)icon );
#endif
  if (pixmap==NULL) {
    pixmap=gdk_pixmap_new(mainform->window,1,1,XDefaultDepth(GetDisplay(),XDefaultScreen(GetDisplay())));
    mask=gdk_pixmap_new(mainform->window,1,1,1);
  }
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_set_usize(pixmapwid,85,85);
  gtk_widget_show( pixmapwid );
  gtk_container_add( GTK_CONTAINER(obj), pixmapwid );
  gdk_pixmap_unref(pixmap);
  if (mask)
  gdk_bitmap_unref(mask);

  /*obj = fl_add_frame(FL_ENGRAVED_FRAME,10,200,350,30,"");FIXME*/

  obj = gtk_button_new_with_label ("Close");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (OptionsExitCallback), (gpointer) "Close");
  mygtk_setposition(table,obj,190,240,170,30);

  obj = gtk_button_new_with_label ("Apply");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (WindowApplyCallback), (gpointer) "Apply");
  mygtk_setposition(table,obj,10,240,170,30);

  obj = gtk_label_new ("Background(pixmap)");
  mygtk_setposition(table,obj,3,70,140,20);

  obj = gtk_label_new ("Window-Folder");
  mygtk_setposition(table,obj,3,0,110,20);

  obj = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(obj), name );
  gtk_entry_set_editable( GTK_ENTRY(obj),False);
  mygtk_setposition(table,obj,10,20,350,30);

  winhide = gtk_check_button_new_with_label ("Show hidden \".*\" files");
  mygtk_setposition(table,winhide,10,160,160,30);
  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(winhide),True);
  if (position==NULL) {
    gtk_widget_set_sensitive(winhide,False);
  } else if (position[0]=='a')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(winhide),False);

  wininfobj = gtk_check_button_new_with_label ("Windowinfo'll be saved");
  mygtk_setposition(table,wininfobj,10,200,170,30);
  if (GetWindowSaveStatus(name)==True)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(wininfobj),True);

  icoinfobj = gtk_check_button_new_with_label ("Iconinfo'll be saved");
  mygtk_setposition(table,icoinfobj,200,200,160,30);
  if (GetIconSaveStatus(name)==True)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(icoinfobj),True);

  iconobj = gtk_entry_new ();
  if (icon!=NULL)
    gtk_entry_set_text( GTK_ENTRY(iconobj), icon );
  gtk_entry_set_editable( GTK_ENTRY(iconobj),False);
  mygtk_setposition(table,iconobj,10,90,258,30);

  obj = gtk_button_new_with_label ("Erase");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (EraseCallback), (gpointer) "Erase");
  mygtk_setposition(table,obj,90,120,90,30);

  obj = gtk_button_new_with_label ("Color");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (ColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,obj,180,120,90,30);

  gtk_signal_connect (GTK_OBJECT (mainform), "delete_event",
                      GTK_SIGNAL_FUNC (OptionsExitCallback), NULL);
  mygtk_show_window(mainform,table,text);

  gtk_main();
  _exit(0);
}

void MainWindowApplyCallback(GtkWidget *widget, gpointer data)
{
  Window updwin;
  char text1[30],text2[30];
  char *test;
  int i;
  int r1;int g1;int b1;
  int r2;int g2;int b2;
  int r3;int g3;int b3;
  int r4;int g4;int b4;

  if (GTK_TOGGLE_BUTTON(obja)->active)
    strcpy(text1,"a");
  else if (GTK_TOGGLE_BUTTON(objb)->active)
    strcpy(text1,"b");
  else if (GTK_TOGGLE_BUTTON(objc)->active)
    strcpy(text1,"c");
  else 
    strcpy(text1," ");
  if (GTK_TOGGLE_BUTTON(objdesk)->active)  
    SetMainBackground(False);
  else
    SetMainBackground(True);    
  if (GTK_TOGGLE_BUTTON(objsave)->active)  
    SetAutoSave(True);
  else {
    SetAutoSave(False);
  }  
  if (GTK_TOGGLE_BUTTON(objlink)->active)  
    SetLinkIcon(True);
  else {
    SetLinkIcon(False);
  }  
  test = gtk_entry_get_text(GTK_ENTRY(objax));
  if (test[0]==0)   
    strcat(text1,"5");
  else
    strcat(text1,test);
  strcat(text1," ");
  test = gtk_entry_get_text(GTK_ENTRY(objay));
  if (test[0]==0)   
    strcat(text1,"5");
  else
    strcat(text1,test);
  strcat(text1," ");
  test = gtk_entry_get_text(GTK_ENTRY(objgrid));
  if (test[0]==0)   
    strcat(text1,"0");
  else
    strcat(text1,test);

  if (GTK_TOGGLE_BUTTON(objbottom)->active==False && GTK_TOGGLE_BUTTON(objright)->active)
    strcpy(text2,"a");
  else if (GTK_TOGGLE_BUTTON(objbottom)->active==False && GTK_TOGGLE_BUTTON(objright)->active==False)
    strcpy(text2,"b");
  else if (GTK_TOGGLE_BUTTON(objbottom)->active && GTK_TOGGLE_BUTTON(objright)->active)
    strcpy(text2,"c");
  else 
    strcpy(text2," ");
  test = gtk_entry_get_text(GTK_ENTRY(objbx));
  if (test[0]==0)   
    strcat(text2,"5");
  else
    strcat(text2,test);
  strcat(text2," ");
  test = gtk_entry_get_text(GTK_ENTRY(objby));
  if (test[0]==0)   
    strcat(text2,"5");
  else
    strcat(text2,test);
  SetDefaultBackground(defaultback);
  EraseFileInfoInDesktop(".dfmdesk --- dfm:~/.dfmdesk/");  
  SendFileInfoToDesktop(".dfmdesk --- dfm:~/.dfmdesk/",text1,icon,text2);

  test = gtk_entry_get_text(GTK_ENTRY(objfont));
  if (test[0]==0)
    SendFontName("8x13");
  else
    SendFontName(test);

  test = gtk_entry_get_text(GTK_ENTRY(objcache));
  if (test[0]==0)   
    i=0;
  else
    sscanf(test,"%d",&i);
  SetWindowCache(i);

  test = gtk_entry_get_text(GTK_ENTRY(objtimer));
  if (test[0]==0)   
    i=40;
  else
    sscanf(test,"%d",&i);
  SendTimer(i);
  sscanf(mforecol,"# %d %d %d",&r1,&g1,&b1);
  sscanf(mbackcol,"# %d %d %d",&r2,&g2,&b2);
  sscanf(wforecol,"# %d %d %d",&r3,&g3,&b3);
  sscanf(wbackcol,"# %d %d %d",&r4,&g4,&b4);
  SendColors(r1,g1,b1,
	     r2,g2,b2,
	     r3,g3,b3,
	     r4,g4,b4);

  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(".dfmdesk --- dfm:~/.dfmdesk/");
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(".dfmdesk -d- dfm:~/.dfmdesk/");
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(".dfmdesk -s- dfm:~/.dfmdesk/");
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
}

void MainWindowOptions(int argc,char *argv[])
{
  GtkWidget *obj;
  GtkWidget *table;
  GSList *group;

  GdkPixmap *pixmap=NULL;
  GdkBitmap *mask;
  GtkStyle *style;
  
  int ax,ay,bx,by,grid;
  char text[10];  
  int r1;int g1;int b1;
  int r2;int g2;int b2;
  int r3;int g3;int b3;
  int r4;int g4;int b4;

#ifdef GDK_IMLIB
  gdk_imlib_init();
#endif

  GetFileInfoFromDesktop(".dfmdesk --- dfm:~/.dfmdesk/",&position,&icon,
			       &start);

  UpdateFontName();
  UpdateTimer();
  UpdateColors();

  defaultback=GetDefaultBackground();  
  if (defaultback == NULL) {
    defaultback=malloc(1);
    defaultback[0] = 0;
  }
  
  mainform = gtk_window_new (GTK_WINDOW_DIALOG);
  table=mygtk_setwindowsize(mainform,600,430);
  gtk_window_position(GTK_WINDOW(mainform),GTK_WIN_POS_CENTER);
  gtk_widget_show( mainform ); /*nessesary because style*/

  obj = gtk_button_new();
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (FileselCallback), (gpointer) "FSelect");
  mygtk_setposition(table,obj,270,10,90,90);

  style = gtk_widget_get_style( mainform );
  if (icon)
#ifdef GDK_IMLIB
  gdk_imlib_load_file_to_pixmap(icon, &pixmap, &mask);   
#else
  pixmap = gdk_pixmap_create_from_xpm( mainform->window,  &mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (const gchar*)icon );
#endif
  if (pixmap==NULL) {
    pixmap=gdk_pixmap_new(mainform->window,1,1,XDefaultDepth(GetDisplay(),XDefaultScreen(GetDisplay())));
    mask=gdk_pixmap_new(mainform->window,1,1,1);
  }
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_set_usize(pixmapwid,85,85);
  gtk_widget_show( pixmapwid );
  gtk_container_add( GTK_CONTAINER(obj), pixmapwid );
  gdk_pixmap_unref(pixmap);
  if (mask)
  gdk_bitmap_unref(mask);

  obj = gtk_label_new ("Icon placement");
  mygtk_setposition(table,obj,3,110,110,20);

  obj = gtk_label_new ("Windowmanager context");
  mygtk_setposition(table,obj,3,300,165,20);

  obj = gtk_label_new ("Icontext color (desktop)");
  mygtk_setposition(table,obj,170,300,180,20);

  obj = gtk_label_new ("Icontext color (windows)");
  mygtk_setposition(table,obj,370,250,180,20);

  obj = gtk_label_new ("Background(pixmap)");
  mygtk_setposition(table,obj,3,20,140,20);

  /*obj = fl_add_frame(FL_ENGRAVED_FRAME,10,150,350,180,"");
  obj = fl_add_frame(FL_ENGRAVED_FRAME,370,50,220,370,"");FIXME*/
  
  obj = gtk_button_new_with_label ("Close");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (OptionsExitCallback), (gpointer) "Close");
  mygtk_setposition(table,obj,305,390,285,30);

  obj = gtk_button_new_with_label ("Apply");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (MainWindowApplyCallback), (gpointer) "Apply");
  mygtk_setposition(table,obj,10,390,285,30);

  objs = gtk_radio_button_new_with_label (NULL, "left->right, top->down");
  mygtk_setposition(table,objs,10,130,170,20);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON (objs));
  obja = gtk_radio_button_new_with_label (group, "top->down, left->right");
  mygtk_setposition(table,obja,10,150,170,20);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON (obja));
  objb = gtk_radio_button_new_with_label (group, "left->right, bottom->up");
  mygtk_setposition(table,objb,195,130,175,20);

  group = gtk_radio_button_group (GTK_RADIO_BUTTON (objb));
  objc = gtk_radio_button_new_with_label (group, "top->down, right->left");
  mygtk_setposition(table,objc,195,150,170,20);

  if (position[0]=='a')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(obja),True);
  else if (position[0]=='b')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objb),True);
  else if (position[0]=='c')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objc),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objs),True);

  GetPositionFromText(position,&ax,&ay,&grid);
  GetPositionFromText(start,&bx,&by,NULL);

  obj = gtk_label_new ("Left");
  mygtk_setposition(table,obj,40,215,30,20);
  objax = gtk_entry_new ();
  sprintf(text,"%d",ax);
  gtk_entry_set_text( GTK_ENTRY(objax), text );
  mygtk_setposition(table,objax,70,210,70,30);

  obj = gtk_label_new ("Top");
  mygtk_setposition(table,obj,170,170,30,20);
  objay = gtk_entry_new ();
  sprintf(text,"%d",ay);
  gtk_entry_set_text( GTK_ENTRY(objay), text );
  mygtk_setposition(table,objay,150,190,70,30);

  obj = gtk_label_new ("Right");
  mygtk_setposition(table,obj,303,215,30,20);
  objbx = gtk_entry_new ();
  sprintf(text,"%d",bx);
  gtk_entry_set_text( GTK_ENTRY(objbx), text );
  mygtk_setposition(table,objbx,230,210,70,30);

  obj = gtk_label_new ("Bottom");
  mygtk_setposition(table,obj,162,260,50,20);
  objby = gtk_entry_new ();
  sprintf(text,"%d",by);
  gtk_entry_set_text( GTK_ENTRY(objby), text );
  mygtk_setposition(table,objby,150,230,70,30);

  obj = gtk_label_new ("Grid tight");
  mygtk_setposition(table,obj,7,255,60,20);
  objgrid = gtk_entry_new ();
  sprintf(text,"%d",grid);
  gtk_entry_set_text( GTK_ENTRY(objgrid), text );
  mygtk_setposition(table,objgrid,70,250,70,30);


  /*obj = fl_add_text(FL_NORMAL_TEXT,10,10,350,30,"Desktop");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);
  obj = fl_add_text(FL_NORMAL_TEXT,370,10,220,30,"Global");
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_ENGRAVED_STYLE);*/

  objbottom = gtk_check_button_new_with_label ("bottom");
  mygtk_setposition(table,objbottom,70,320,75,30);
  
  objright = gtk_check_button_new_with_label ("right");
  mygtk_setposition(table,objright,10,320,60,30);
  
  objdesk = gtk_check_button_new_with_label ("whole desktop");
  mygtk_setposition(table,objdesk,10,350,120,30);
  if (GetMainBackground()==False)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objdesk),True);
  if (start[0]=='c'){
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objbottom),True);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objright),True);
  } else if (start[0]=='a')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objright),True);
  else if (start[0]!='b')
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objbottom),True);
  
  obj = gtk_label_new ("Cache time(sec)");
  mygtk_setposition(table,obj,420,10,120,20);
  objcache = gtk_entry_new ();
  sprintf(text,"%d",GetWindowCache());
  gtk_entry_set_text( GTK_ENTRY(objcache), text );
  mygtk_setposition(table,objcache,445,30,70,30);

  obj = gtk_label_new ("Icon Font");
  mygtk_setposition(table,obj,370,60,70,20);
  objfont = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objfont), GetFontName() );
  mygtk_setposition(table,objfont,380,80,200,30);

  obj = gtk_label_new ("Smart update time (sec) (0=off)");
  mygtk_setposition(table,obj,380,200,200,20);
  objtimer = gtk_entry_new ();
  sprintf(text,"%d",(int)GetTimer());
  gtk_entry_set_text( GTK_ENTRY(objtimer), text );
  mygtk_setposition(table,objtimer,445,220,70,30);

  obj = gtk_label_new ("Default Background(pixmap)");
  mygtk_setposition(table,obj,370,115,185,20);
  objdefback = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objdefback), defaultback );
  gtk_entry_set_editable( GTK_ENTRY(objdefback),False);
  mygtk_setposition(table,objdefback,380,135,200,30);

  obj = gtk_button_new_with_label ("Color");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (DefaultColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,obj,400,165,90,25);

  obj = gtk_button_new_with_label ("Pixmap");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (DefaultFileselCallback), (gpointer) "Pixmap");
  mygtk_setposition(table,obj,490,165,90,25);

  GetColorsRGB(&r1,&g1,&b1,
	       &r2,&g2,&b2,
	       &r3,&g3,&b3,
	       &r4,&g4,&b4);
  mbackcol=malloc(16);
  wbackcol=malloc(16);
  mforecol=malloc(16);
  wforecol=malloc(16);
  sprintf(mforecol,"# %d %d %d",r1,g1,b1);
  sprintf(mbackcol,"# %d %d %d",r2,g2,b2);
  sprintf(wforecol,"# %d %d %d",r3,g3,b3);
  sprintf(wbackcol,"# %d %d %d",r4,g4,b4);
  
  objsave = gtk_check_button_new_with_label ("Save positions/info continously");
  mygtk_setposition(table,objsave,370,335,225,30);
  if (GetAutoSave()==True) {
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objsave),True);
  }
  
  objlink = gtk_check_button_new_with_label ("Show link arrow in icons");
  mygtk_setposition(table,objlink,370,360,225,30);
  if (GetLinkIcon()==True) {
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objlink),True);
  }

  obj = gtk_label_new ("Background");
  mygtk_setposition(table,obj,280,325,80,20);

  obj = gtk_label_new ("Foreground");
  mygtk_setposition(table,obj,280,355,80,20);

  obj = gtk_label_new ("Background");
  mygtk_setposition(table,obj,483,275,80,20);

  obj = gtk_label_new ("Foreground");
  mygtk_setposition(table,obj,483,305,80,20);

  objmbaccol = gtk_button_new_with_label (mbackcol);
  gtk_signal_connect (GTK_OBJECT (objmbaccol), "clicked",
                    GTK_SIGNAL_FUNC (MBColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,objmbaccol,180,320,100,30);

  objmforcol = gtk_button_new_with_label (mforecol);
  gtk_signal_connect (GTK_OBJECT (objmforcol), "clicked",
                    GTK_SIGNAL_FUNC (MFColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,objmforcol,180,350,100,30);

  objwbaccol = gtk_button_new_with_label (wbackcol);
  gtk_signal_connect (GTK_OBJECT (objwbaccol), "clicked",
                    GTK_SIGNAL_FUNC (WBColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,objwbaccol,380,270,100,30);

  objwforcol = gtk_button_new_with_label (wforecol);
  gtk_signal_connect (GTK_OBJECT (objwforcol), "clicked",
                    GTK_SIGNAL_FUNC (WFColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,objwforcol,380,300,100,30);

  iconobj = gtk_entry_new ();
  if (icon!=NULL)
    gtk_entry_set_text( GTK_ENTRY(iconobj), icon );
  gtk_entry_set_editable( GTK_ENTRY(iconobj),False);
  mygtk_setposition(table,iconobj,10,40,258,30);

  obj = gtk_button_new_with_label ("Erase");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (EraseCallback), (gpointer) "Erase");
  mygtk_setposition(table,obj,90,70,90,30);

  obj = gtk_button_new_with_label ("Color");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (ColorselCallback), (gpointer) "Color");
  mygtk_setposition(table,obj,180,70,90,30);

  gtk_signal_connect (GTK_OBJECT (mainform), "delete_event",
                      GTK_SIGNAL_FUNC (OptionsExitCallback), NULL);
  mygtk_show_window(mainform,table,"Desktop Options");
  gtk_main();
  _exit(0);
}


void FileApplyCallback(GtkWidget *widget, gpointer data)
{
  Window updwin;
  char *pos,*dummy1,*dummy2;
  char *oldname;
  char *text;
  char *text2;
  char *textn;
  int x,y;
  char* text3;
  char linktext[1024];
  char* ren;
  struct stat info;
  struct passwd *username;
  struct group *groupname;
  char *number;
  int j;

  ren=GenerateLastNameWithoutSlash(name);
  GetFileInfoFromDesktop(name,&pos,&dummy1,&dummy2);
  free(dummy1);
  free(dummy2);
  text = gtk_entry_get_text(GTK_ENTRY(objren));
  if (strcmp(text,ren)!=0) {
    oldname=malloc(strlen(name)+1);
    strcpy(oldname,name);
    if (oldname[strlen(oldname)-1]=='/')
      oldname[strlen(oldname)-1]=0;
    text2=malloc(strlen(oldname)+strlen(text)+1);
    strcpy(text2,oldname);
    strcpy(text2+strlen(oldname)-strlen(ren),text);
    if (oldname[0]=='~' && oldname[1]=='/')
      oldname[0]='.';
    if (text2[0]=='~' && text2[1]=='/')
      text2[0]='.';
    if (FileExist(text2)==False && rename(oldname,text2)==0) {
      if (text2[0]=='.' && text2[1]=='/')
	text2[0]='~';
      if (name[strlen(name)-1]=='/')
       	strcat(text2,"/");
      EraseFileInfoInDesktop(name);
      free(name);
      name=text2;
    } else
      free(text2);
    free(oldname);
  }
  free(ren);
  if (pos!=NULL) {
    GetPositionFromText(pos,&x,&y,NULL);
    if (GTK_TOGGLE_BUTTON(obja)->active)
      SetPositionToText(&position,x,y,'a');
    else
      SetPositionToText(&position,x,y,' ');
  } else {
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(obja),False);
    position=NULL;
  }
  free(pos);
  pos=strdup(gtk_entry_get_text(GTK_ENTRY(objs)));
  j=0;
  while (pos[j]!=0) {
    if (pos[j]==';')
       pos[j]=' ';
    j++;
  }
  SendFileInfoToDesktop(name,position,icon,pos/*shellcommand*/);
  free(pos);
  free(position);
  textn=GenerateBackslashName(name);
  text=malloc(strlen("chown  ")+strlen(textn)+strlen(gtk_entry_get_text(GTK_ENTRY(objax)))+1);
  strcpy(text,"chown ");
  strcat(text,gtk_entry_get_text(GTK_ENTRY(objax)));
  strcat(text," ");
  strcat(text,textn);
  usershellsystem(text,NULL);
  free(text);
  text=malloc(strlen("chgrp  ")+strlen(textn)+strlen(gtk_entry_get_text(GTK_ENTRY(objbx)))+1);
  strcpy(text,"chgrp ");
  strcat(text,gtk_entry_get_text(GTK_ENTRY(objbx)));
  strcat(text," ");
  strcat(text,textn);
  usershellsystem(text,NULL);
  free(text);
  text3=malloc(strlen(name)+1);
  strcpy(text3,name);
  if (text3[0]=='~' && text3[1]=='/')
    text3[0]='.';
  if (text3[strlen(text3)-1]=='/')
    text3[strlen(text3)-1]=0;
  text2=malloc(strlen("File:")+strlen(name)+1);
  strcpy(text2,"File:");
  strcat(text2,name);
  ren=GenerateLastNameWithoutSlash(name);
  gtk_entry_set_text( GTK_ENTRY(objname), name );
  gtk_entry_set_text( GTK_ENTRY(objren), ren );
  if (GTK_TOGGLE_BUTTON(icoinfobj)->active)
    SetIconSaveStatus(winame,True);
  else
    SetIconSaveStatus(winame,False);
  lstat(text3,&info);
  if ((info.st_mode&S_IFMT)!=S_IFLNK) {
    if ((info.st_mode&S_ISUID)==0 &&
	(info.st_mode&S_ISGID)==0 ) {
      text=malloc(strlen("chmod XXX ")+strlen(textn)+1);
      strcpy(text,"chmod 000 ");
      strcat(text,textn);
      if (GTK_TOGGLE_BUTTON(objor)->active)
	text[6]=text[6]+4;
      if (GTK_TOGGLE_BUTTON(objow)->active)
	text[6]=text[6]+2;
      if (GTK_TOGGLE_BUTTON(objox)->active)
	text[6]++;
      if (GTK_TOGGLE_BUTTON(objgr)->active)
	text[7]=text[7]+4;
      if (GTK_TOGGLE_BUTTON(objgw)->active)
	text[7]=text[7]+2;
      if (GTK_TOGGLE_BUTTON(objgx)->active)
	text[7]++;
      if (GTK_TOGGLE_BUTTON(objwr)->active)
	text[8]=text[8]+4;
      if (GTK_TOGGLE_BUTTON(objww)->active)
	text[8]=text[8]+2;
      if (GTK_TOGGLE_BUTTON(objwx)->active)
	text[8]++;
      usershellsystem(text,NULL);
      free(text);
    }
    sprintf(linktext,"%ld",info.st_size);
    gtk_entry_set_text( GTK_ENTRY(objsize), linktext );
  }
  free(textn);
  sprintf(linktext,"%s",ctime(&(info.st_ctime)));
  if (linktext[strlen(linktext)-1]==10)
    linktext[strlen(linktext)-1]=0;
  gtk_entry_set_text( GTK_ENTRY(objtime), linktext );

  username=getpwuid(info.st_uid);
  if (username!=NULL)
    gtk_entry_set_text( GTK_ENTRY(objax), username->pw_name );
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_uid);
    gtk_entry_set_text( GTK_ENTRY(objax), number );
    free(number);
  }

  groupname=getgrgid(info.st_gid);
  if (groupname!=NULL) 
    gtk_entry_set_text( GTK_ENTRY(objbx), groupname->gr_name );
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_gid);
    gtk_entry_set_text( GTK_ENTRY(objbx), number );
    free(number);
  }

  stat(text3,&info);
  if ((info.st_mode&S_IRUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objor),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objor),False);
  if ((info.st_mode&S_IWUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objow),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objow),False);
  if ((info.st_mode&S_IXUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objox),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objox),False);
  if ((info.st_mode&S_IRGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgr),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgr),False);
  if ((info.st_mode&S_IWGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgw),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgw),False);
  if ((info.st_mode&S_IXGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgx),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgx),False);
  if ((info.st_mode&S_IROTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwr),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwr),False);
  if ((info.st_mode&S_IWOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objww),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objww),False);
  if ((info.st_mode&S_IXOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwx),True);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwx),False);

  gtk_window_set_title(GTK_WINDOW(mainform),text2);
  text=GenerateWindowName(winame,NORMAL);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);
  text=GenerateWindowName(winame,DETAIL);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);
  free(text3);
  free(text2);
  free(ren);
}

void NormalCallback(GtkWidget *widget, gpointer data)
{
  gtk_entry_set_text( GTK_ENTRY(objs),"dfm !0!");
}

void DetailCallback(GtkWidget *widget, gpointer data)
{
  gtk_entry_set_text( GTK_ENTRY(objs),"dfm !0! -detail");
}

void StructureCallback(GtkWidget *widget, gpointer data)
{
  gtk_entry_set_text( GTK_ENTRY(objs),"dfm !0! -structure");
}

void FileOptions(int argc,char *argv[])
{
  GtkWidget *obj;
  GtkWidget *table;

  GdkPixmap *pixmap=NULL;
  GdkBitmap *mask;
  GtkStyle *style;

  int status;
  char* text2;
  char* text3;
  char linktext[1024];
  char* ren;
  struct stat info;
  struct passwd *username;
  struct group *groupname;
  char *number;

#ifdef GDK_IMLIB
  gdk_imlib_init();
#endif

  name=CutHomeDir(argv[2]);
  if (name[0]=='.' && name[1]=='/')
    name[0]='~';
    
  text3=malloc(strlen(argv[2])+1);
  strcpy(text3,argv[2]);
  if (text3[strlen(text3)-1]=='/')
    text3[strlen(text3)-1]=0;
    
  text2=malloc(strlen("File:")+strlen(name)+1);
  strcpy(text2,"File:");
  strcat(text2,name);
  
  ren=GenerateLastNameWithoutSlash(name);
  winame=malloc(strlen(name)+1);
  strcpy(winame,name);
  winame[strlen(text3)-strlen(ren)]=0;

  GetLinkName(&winame);
  
  GetFileInfoFromDesktop(name,&position,&icon,
			       &start);
  lstat(text3,&info);

  mainform = gtk_window_new (GTK_WINDOW_DIALOG);
  table=mygtk_setwindowsize(mainform,370,480);
  gtk_window_position(GTK_WINDOW(mainform),GTK_WIN_POS_CENTER);
  gtk_widget_show( mainform ); /*nessesary because style*/

  obj = gtk_button_new();
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (FileselCallback), (gpointer) "FSelect");
  mygtk_setposition(table,obj,270,110,90,90);

  style = gtk_widget_get_style( mainform );
  if (icon)
#ifdef GDK_IMLIB
    gdk_imlib_load_file_to_pixmap(icon, &pixmap, &mask);   
#else
  pixmap = gdk_pixmap_create_from_xpm( mainform->window,  &mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (const gchar*)icon );
#endif
  if (pixmap==NULL) {
    pixmap=gdk_pixmap_new(mainform->window,1,1,XDefaultDepth(GetDisplay(),XDefaultScreen(GetDisplay())));
    mask=gdk_pixmap_new(mainform->window,1,1,1);
  }
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_set_usize(pixmapwid,85,85);
  gtk_widget_show( pixmapwid );
  gtk_container_add( GTK_CONTAINER(obj), pixmapwid );
  gdk_pixmap_unref(pixmap);
  if (mask)
  gdk_bitmap_unref(mask);

  obj = gtk_button_new_with_label ("Close");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (OptionsExitCallback), (gpointer) "Close");
  mygtk_setposition(table,obj,190,440,170,30);

  obj = gtk_button_new_with_label ("Apply");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (FileApplyCallback), (gpointer) "Apply");
  mygtk_setposition(table,obj,10,440,170,30);

  obj = gtk_label_new ("File");
  mygtk_setposition(table,obj,0,0,40,20);
  
  if (name[strlen(name)-1]=='/') {

  obj = gtk_button_new_with_label ("normal");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (NormalCallback), (gpointer) "normal");
  mygtk_setposition(table,obj,120,250,80,20);

  obj = gtk_button_new_with_label ("detail");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (DetailCallback), (gpointer) "detail");
  mygtk_setposition(table,obj,200,250,80,20);

  obj = gtk_button_new_with_label ("structure");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (StructureCallback), (gpointer) "structure");
  mygtk_setposition(table,obj,280,250,80,20);
  }

  obj = gtk_label_new ("Icon");
  mygtk_setposition(table,obj,0,120,40,20);

  obj = gtk_label_new ("Rights");
  mygtk_setposition(table,obj,0,300,90,20);

  obj = gtk_label_new ("Shellcommand");
  mygtk_setposition(table,obj,0,250,100,20);
  objs = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objs), start );
  mygtk_setposition(table,objs,10,270,350,30);

  obj = gtk_label_new ("Rename to");
  mygtk_setposition(table,obj,0,50,75,20);
  objren = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objren), ren );
  mygtk_setposition(table,objren,10,70,350,30);

  obj = gtk_label_new ("Owner");
  mygtk_setposition(table,obj,0,320,40,30);

  obj = gtk_label_new ("Group");
  mygtk_setposition(table,obj,0,360,40,30);

  obj = gtk_label_new ("World");
  mygtk_setposition(table,obj,0,400,40,30);

  objax = gtk_entry_new ();
  username=getpwuid(info.st_uid);
  if (username!=NULL)
    gtk_entry_set_text( GTK_ENTRY(objax),username->pw_name);
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_uid);
    gtk_entry_set_text( GTK_ENTRY(objax),number);
    free(number);
  }
  mygtk_setposition(table,objax,40,320,140,30);
  
  objbx = gtk_entry_new ();
  groupname=getgrgid(info.st_gid);
  if (groupname!=NULL) 
    gtk_entry_set_text( GTK_ENTRY(objbx),groupname->gr_name);
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_gid);
    gtk_entry_set_text( GTK_ENTRY(objbx),number);
    free(number);
  }
  mygtk_setposition(table,objbx,40,360,140,30);
 
  obj = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(obj),"All");
  gtk_entry_set_editable( GTK_ENTRY(obj),False);
  mygtk_setposition(table,obj,40,400,140,30);

  if ((info.st_mode&S_IFMT)==S_IFLNK) {

    obj = gtk_label_new ("Mode of the linked file:");
    mygtk_setposition(table,obj,180,300,150,20);

    obj = gtk_label_new ("Link to");
    mygtk_setposition(table,obj,0,195,90,20);

    status=readlink(text3,linktext,1023);
    linktext[status]=0;
  } else {
    if ((info.st_mode&S_ISUID)!=0 ||
	(info.st_mode&S_ISGID)!=0 ) {
      obj = gtk_label_new ("Please use the chmod command:");
      mygtk_setposition(table,obj,180,300,180,20);
    }
    obj = gtk_label_new ("Size");
    mygtk_setposition(table,obj,0,195,40,20);
    
    sprintf(linktext,"%ld",info.st_size);
  }
  
  objsize = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objsize),linktext);
  gtk_entry_set_editable( GTK_ENTRY(objsize),False);
  mygtk_setposition(table,objsize,10,215,175,30);

  obj = gtk_label_new ("Time");
  mygtk_setposition(table,obj,185,195,40,20);

  sprintf(linktext,"%s",ctime(&(info.st_mtime)));
  if (linktext[strlen(linktext)-1]==10)
    linktext[strlen(linktext)-1]=0;

  objtime = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objtime),linktext);
  gtk_entry_set_editable( GTK_ENTRY(objtime),False);
  mygtk_setposition(table,objtime,195,215,165,30);

  obja = gtk_check_button_new_with_label ("Prevent moving");
  mygtk_setposition(table,obja,10,170,110,20);
  if (position!=NULL && position[0]=='a') 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(obja),True);

  icoinfobj = gtk_check_button_new_with_label ("Iconinfo'll be saved");
  mygtk_setposition(table,icoinfobj,130,170,130,20);
  if (GetIconSaveStatus(winame)==True)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(icoinfobj),True);
  if (strcmp(winame,"~/.dfmdesk/")==0) {
    gtk_widget_set_sensitive(icoinfobj,False);
  }

  objname = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objname),name);
  gtk_entry_set_editable( GTK_ENTRY(objname),False);
  mygtk_setposition(table,objname,10,20,350,30);

  iconobj = gtk_entry_new ();
  if (icon!=NULL)
    gtk_entry_set_text( GTK_ENTRY(iconobj), icon );
  gtk_entry_set_editable( GTK_ENTRY(iconobj),False);
  mygtk_setposition(table,iconobj,10,140,258,30);
  
  objox = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objox,310,320,50,30);

  objgx = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objgx,310,360,50,30);

  objwx = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objwx,310,400,50,30);

  objow = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objow,250,320,50,30);

  objgw = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objgw,250,360,50,30);

  objww = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objww,250,400,50,30);

  objor = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objor,190,320,50,30);

  objgr = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objgr,190,360,50,30);

  objwr = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objwr,190,400,50,30);

  if ((info.st_mode&S_IFMT)==S_IFLNK ||
      (info.st_mode&S_ISUID)!=0 ||
      (info.st_mode&S_ISGID)!=0 ) {
    gtk_widget_set_sensitive(objox,False);
    gtk_widget_set_sensitive(objgx,False);
    gtk_widget_set_sensitive(objwx,False);
    gtk_widget_set_sensitive(objow,False);
    gtk_widget_set_sensitive(objgw,False);
    gtk_widget_set_sensitive(objww,False);
    gtk_widget_set_sensitive(objor,False);
    gtk_widget_set_sensitive(objgr,False);
    gtk_widget_set_sensitive(objwr,False);
  }
  
  stat(text3,&info);
  if ((info.st_mode&S_IRUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objor),True);
  if ((info.st_mode&S_IWUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objow),True);
  if ((info.st_mode&S_IXUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objox),True);
  if ((info.st_mode&S_IRGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgr),True);
  if ((info.st_mode&S_IWGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgw),True);
  if ((info.st_mode&S_IXGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgx),True);
  if ((info.st_mode&S_IROTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwr),True);
  if ((info.st_mode&S_IWOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objww),True);
  if ((info.st_mode&S_IXOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwx),True);
  free(position);

  gtk_signal_connect (GTK_OBJECT (mainform), "delete_event",
                      GTK_SIGNAL_FUNC (OptionsExitCallback), NULL);
  mygtk_show_window(mainform,table,text2);
  gtk_widget_grab_focus(objren);
  gtk_main();
  _exit(0);
}

void MultipleFileApplyCallback(GtkWidget *widget, gpointer data)
{
  Window updwin;
  char *pos,*dummy1,*dummy2;
  int x,y,i,j;
  char* text;
  char* textn;
  
  if (GTK_TOGGLE_BUTTON(icoinfobj)->active)
    SetIconSaveStatus(winame,True);
  else
    SetIconSaveStatus(winame,False);

  for (i=0;i<gargc-2;i++) {
    GetFileInfoFromDesktop(filearray[i],&pos,&dummy1,&dummy2);
    free(dummy1);
    free(dummy2);
    if (pos!=NULL) {
      GetPositionFromText(pos,&x,&y,NULL);
      if (GTK_TOGGLE_BUTTON(obja)->active)
        SetPositionToText(&position,x,y,'a');
      else
        SetPositionToText(&position,x,y,' ');
    } else {
      position=NULL;
    }
    free(pos);
    pos=strdup(gtk_entry_get_text(GTK_ENTRY(objs)));
    j=0;
    while (pos[j]!=0) {
      if (pos[j]==';')
        pos[j]=' ';
      j++;
    }
    if (GTK_TOGGLE_BUTTON(objchangep)->active)
      SendFileInfoToDesktop(filearray[i],position,NULL,NULL);
    if (GTK_TOGGLE_BUTTON(objchangei)->active)
      SendFileInfoToDesktop(filearray[i],NULL,icon,NULL);
    if (GTK_TOGGLE_BUTTON(objchanges)->active)
      SendFileInfoToDesktop(filearray[i],NULL,NULL,pos/*shellcommand*/);
    free(pos);
    free(position);
    
    textn=GenerateBackslashName(filearray[i]);
    if (GTK_TOGGLE_BUTTON(objchangeo)->active) {
      text=malloc(strlen("chown  ")+strlen(textn)+strlen(gtk_entry_get_text(GTK_ENTRY(objax)))+1);
      strcpy(text,"chown ");
      strcat(text,gtk_entry_get_text(GTK_ENTRY(objax)));
      strcat(text," ");
      strcat(text,textn);
      usershellsystem(text,NULL);
      free(text);
      text=malloc(strlen("chgrp  ")+strlen(textn)+strlen(gtk_entry_get_text(GTK_ENTRY(objbx)))+1);
      strcpy(text,"chgrp ");
      strcat(text,gtk_entry_get_text(GTK_ENTRY(objbx)));
      strcat(text," ");
      strcat(text,textn);
      usershellsystem(text,NULL);
      free(text);
    }

    if (GTK_TOGGLE_BUTTON(objchangem)->active) {
      text=malloc(strlen("chmod XXX ")+strlen(textn)+1);
      strcpy(text,"chmod 000 ");
      strcat(text,textn);
      if (GTK_TOGGLE_BUTTON(objor)->active)
	text[6]=text[6]+4;
      if (GTK_TOGGLE_BUTTON(objow)->active)
	text[6]=text[6]+2;
      if (GTK_TOGGLE_BUTTON(objox)->active)
	text[6]++;
      if (GTK_TOGGLE_BUTTON(objgr)->active)
	text[7]=text[7]+4;
      if (GTK_TOGGLE_BUTTON(objgw)->active)
	text[7]=text[7]+2;
      if (GTK_TOGGLE_BUTTON(objgx)->active)
	text[7]++;
      if (GTK_TOGGLE_BUTTON(objwr)->active)
	text[8]=text[8]+4;
      if (GTK_TOGGLE_BUTTON(objww)->active)
	text[8]=text[8]+2;
      if (GTK_TOGGLE_BUTTON(objwx)->active)
	text[8]++;
      usershellsystem(text,NULL);
      free(text);
    }
    free(textn);
  }
  text=GenerateWindowName(winame,NORMAL);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);
  text=GenerateWindowName(winame,DETAIL);
  /*XGrabServer(GetDisplay());*/
  updwin=GetWindowNamed(text);
  /*XUngrabServer(GetDisplay());*/
  if (updwin!=None) 
    SendWindow(updwin,UPDATE);
  free(text);
}

void MultipleFileOptions(int argc,char *argv[])
{
  GtkWidget *obj;
  GtkWidget *table;

  GdkPixmap *pixmap=NULL;
  GdkBitmap *mask;
  GtkStyle *style;
#ifdef GTK_HAVE_FEATURES_1_1_4
  GtkWidget *scrolledwindow1;
#endif
  int i;
  char *text;
  struct stat info;
  struct passwd *username;
  struct group *groupname;
  char *number;
  gchar *titles[1] = {"Files"};
  
#ifdef GDK_IMLIB
  gdk_imlib_init();
#endif

  gargc=argc;
  gargv=argv;

  filearray=malloc(sizeof(char*)*(argc-2));
  for (i=2;i<argc;i++) {
    filearray[i-2]=CutHomeDir(argv[i]);
    if (filearray[i-2][0]=='.' && filearray[i-2][1]=='/')
      filearray[i-2][0]='~';
  }
  text=GenerateLastName(filearray[0]);
  winame=malloc(strlen(filearray[0])+1);
  strcpy(winame,filearray[0]);
  winame[strlen(filearray[0])-strlen(text)]=0;
  GetLinkNameWithoutLast(&winame);
  free(text);
  GetFileInfoFromDesktop(filearray[0],&position,&icon,
			 &start);
  lstat(argv[2],&info);

  mainform = gtk_window_new (GTK_WINDOW_DIALOG);
  table=mygtk_setwindowsize(mainform,370,460);
  gtk_window_position(GTK_WINDOW(mainform),GTK_WIN_POS_CENTER);
  gtk_widget_show( mainform ); /*nessesary because style*/

  obj = gtk_button_new();
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (FileselCallback), (gpointer) "FSelect");
  mygtk_setposition(table,obj,270,110,90,90);

  style = gtk_widget_get_style( mainform );
  if (icon)
#ifdef GDK_IMLIB
  gdk_imlib_load_file_to_pixmap(icon, &pixmap, &mask);   
#else
  pixmap = gdk_pixmap_create_from_xpm( mainform->window,  &mask,
                                       &style->bg[GTK_STATE_NORMAL],
                                       (const gchar*)icon );
#endif
  if (pixmap==NULL) {
    pixmap=gdk_pixmap_new(mainform->window,1,1,XDefaultDepth(GetDisplay(),XDefaultScreen(GetDisplay())));
    mask=gdk_pixmap_new(mainform->window,1,1,1);
  }
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_set_usize(pixmapwid,85,85);
  gtk_widget_show( pixmapwid );
  gtk_container_add( GTK_CONTAINER(obj), pixmapwid );
  gdk_pixmap_unref(pixmap);
  if (mask)
  gdk_bitmap_unref(mask);

  obj = gtk_button_new_with_label ("Close");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (OptionsExitCallback), (gpointer) "Close");
  mygtk_setposition(table,obj,190,420,170,30);

  obj = gtk_label_new ("Files");
  mygtk_setposition(table,obj,0,0,40,20);
  
  obj = gtk_button_new_with_label ("Apply");
  gtk_signal_connect (GTK_OBJECT (obj), "clicked",
                    GTK_SIGNAL_FUNC (MultipleFileApplyCallback), (gpointer) "Apply");
  mygtk_setposition(table,obj,10,420,170,30);

  obj = gtk_label_new ("Owner");
  mygtk_setposition(table,obj,0,300,40,30);

  obj = gtk_label_new ("Group");
  mygtk_setposition(table,obj,0,340,40,30);

  obj = gtk_label_new ("World");
  mygtk_setposition(table,obj,0,380,40,30);

  objax = gtk_entry_new ();
  username=getpwuid(info.st_uid);
  if (username!=NULL)
    gtk_entry_set_text( GTK_ENTRY(objax),username->pw_name);
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_uid);
    gtk_entry_set_text( GTK_ENTRY(objax),number);
    free(number);
  }
  mygtk_setposition(table,objax,40,300,140,30);

  objbx = gtk_entry_new ();
  groupname=getgrgid(info.st_gid);
  if (groupname!=NULL) 
    gtk_entry_set_text( GTK_ENTRY(objbx),groupname->gr_name);
  else {
    number=malloc(13);
    sprintf(number,"%d",info.st_gid);
    gtk_entry_set_text( GTK_ENTRY(objbx),number);
    free(number);
  }
  mygtk_setposition(table,objbx,40,340,140,30);

  obj = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(obj),"All");
  gtk_entry_set_editable( GTK_ENTRY(obj),False);
  mygtk_setposition(table,obj,40,380,140,30);

  objox = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objox,310,300,50,30);

  objgx = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objgx,310,340,50,30);

  objwx = gtk_toggle_button_new_with_label("exec");
  mygtk_setposition(table,objwx,310,380,50,30);

  objow = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objow,250,300,50,30);

  objgw = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objgw,250,340,50,30);

  objww = gtk_toggle_button_new_with_label("write");
  mygtk_setposition(table,objww,250,380,50,30);

  objor = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objor,190,300,50,30);

  objgr = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objgr,190,340,50,30);

  objwr = gtk_toggle_button_new_with_label("read");
  mygtk_setposition(table,objwr,190,380,50,30);

  obj = gtk_clist_new_with_titles( 1, titles );
  for (i=2;i<argc;i++) {
    text=GenerateLastName(argv[i]);
    gtk_clist_append( GTK_CLIST(obj), &text ); 
    free(text);
  }

#ifdef GTK_HAVE_FEATURES_1_1_4
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL); // scrolledwindow for clist
  gtk_widget_show (scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC);
  mygtk_setposition(table,scrolledwindow1,10,20,350,85);
#endif

  gtk_widget_show(obj);

#ifdef GTK_HAVE_FEATURES_1_1_4
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwindow1), obj);
#endif

  gtk_clist_column_titles_hide(GTK_CLIST(obj));
  /*gtk_clist_set_border(GTK_CLIST(obj), GTK_SHADOW_IN);*/

#ifndef GTK_HAVE_FEATURES_1_1_4
  mygtk_setposition(table,obj,10,20,350,85);
  gtk_clist_set_policy(GTK_CLIST(obj), GTK_POLICY_ALWAYS,
                                       GTK_POLICY_AUTOMATIC);
#endif


  objs = gtk_entry_new ();
  gtk_entry_set_text( GTK_ENTRY(objs), start );
  mygtk_setposition(table,objs,10,240,350,30);

  objchangei = gtk_check_button_new_with_label ("Change icon");
  mygtk_setposition(table,objchangei,0,120,90,20);

  objchanges = gtk_check_button_new_with_label ("Change startcall");
  mygtk_setposition(table,objchanges,0,220,120,20);

  objchangeo = gtk_check_button_new_with_label ("Change owners");
  mygtk_setposition(table,objchangeo,0,280,110,20);

  objchangep = gtk_check_button_new_with_label ("Change preventing");
  mygtk_setposition(table,objchangep,0,180,130,20);

  objchangem = gtk_check_button_new_with_label ("Change mode");
  mygtk_setposition(table,objchangem,180,280,100,20);

  for (i=2;i<argc;i++) {
    lstat(argv[i],&info);
    if ((info.st_mode&S_IFMT)==S_IFLNK ||
	(info.st_mode&S_ISUID)!=0 ||
	(info.st_mode&S_ISGID)!=0 ) {
      gtk_widget_set_sensitive(objchangem,False);
      gtk_widget_set_sensitive(objox,False);
      gtk_widget_set_sensitive(objgx,False);
      gtk_widget_set_sensitive(objwx,False);
      gtk_widget_set_sensitive(objow,False);
      gtk_widget_set_sensitive(objgw,False);
      gtk_widget_set_sensitive(objww,False);
      gtk_widget_set_sensitive(objor,False);
      gtk_widget_set_sensitive(objgr,False);
      gtk_widget_set_sensitive(objwr,False);
    }
  }

  stat(argv[2],&info);
  if ((info.st_mode&S_IRUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objor),True);
  if ((info.st_mode&S_IWUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objow),True);
  if ((info.st_mode&S_IXUSR)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objox),True);
  if ((info.st_mode&S_IRGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgr),True);
  if ((info.st_mode&S_IWGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgw),True);
  if ((info.st_mode&S_IXGRP)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objgx),True);
  if ((info.st_mode&S_IROTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwr),True);
  if ((info.st_mode&S_IWOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objww),True);
  if ((info.st_mode&S_IXOTH)!=0) 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(objwx),True);

  iconobj = gtk_entry_new ();
  if (icon!=NULL)
    gtk_entry_set_text( GTK_ENTRY(iconobj), icon );
  gtk_entry_set_editable( GTK_ENTRY(iconobj),False);
  mygtk_setposition(table,iconobj,10,140,258,30);
  
  obja = gtk_check_button_new_with_label ("Prevent moving");
  mygtk_setposition(table,obja,10,200,110,20);
  if (position!=NULL && position[0]=='a') 
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(obja),True);

  icoinfobj = gtk_check_button_new_with_label ("Iconinfo'll be saved");
  mygtk_setposition(table,icoinfobj,220,210,110,30);
  if (GetIconSaveStatus(winame)==True)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(icoinfobj),True);
  if (strcmp(winame,"~/.dfmdesk/")==0) {
    gtk_widget_set_sensitive(icoinfobj,False);
  }

  mygtk_show_window(mainform,table,winame);
  gtk_widget_grab_focus(objs);
  gtk_main();
  _exit(0);
}
