/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "detect.h"
#include "utils.h"


extern struct scsintf_info *scsiinterface_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL; 
  struct isa_info *isa = (struct isa_info *)NULL;
  struct pcmcia_info *pcmcia = (struct pcmcia_info *)NULL;
  static struct scsintf_info *first = (struct scsintf_info *)NULL;
  struct scsintf_info *result = (struct scsintf_info *)NULL;
  
#if defined(__PPC__)
  FILE *fd;
  char *line;
  char *file;
  char *folder;
  size_t len = 0;
  char *ppc_dev;
  int i;

  char *ppc_scsi_dev[] = {
    "/proc/device-tree/aliases/scsi-int",
    "/proc/device-tree/aliases/scsi",
    NULL
  };
#endif
  
  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    fprintf(stdout, "\nProbing SCSI interface...\n");

  /********************************************************************/
  /******************** PCI SCSI-INTERFACE DETECTION ******************/
  /********************************************************************/
 if(debug)
   fprintf(stdout, "\tProbing PCI SCSI interface...\n");
    for(pci = bus->pci; pci; pci = pci->next){
      if(pci->type == SCSIINTERFACE){
        if(!first){
          first = result = (struct scsintf_info *) 
                                 my_malloc(sizeof(struct scsintf_info));
        }else {
          result->next = (struct scsintf_info *) 
                                 my_malloc(sizeof(struct scsintf_info));
          result = result->next;
        }/*endif*/
        result->next = (struct scsintf_info *)NULL;
        
        result->vendor = pci->vendor;
        result->model = pci->model;
        result->module = pci->modulename;
	result->long_id = pci->id;
        result->bus = PCI;
	if(debug)
	  fprintf(stdout, "\t\tFound %s %s\n", 
		  result->vendor, result->model);
      }/*endif*/
    }/*next pci*/

  /********************************************************************/
  /******************** ISA SCSI-INTERFACE DETECTION ******************/
  /********************************************************************/
    if(debug)
      fprintf(stdout, "\tProbing ISA SCSI interface...\n");
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == SCSIINTERFACE){
      if(!first){
	first = result = (struct scsintf_info *)
	  my_malloc(sizeof(struct scsintf_info));
      }else{
	result->next = (struct scsintf_info *)
	  my_malloc(sizeof(struct scsintf_info));
	result = result->next;
      }/*endif*/
      result->next = (struct scsintf_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id = isa->board_id;
      result->dev_num = isa->dev_num;
      result->dev_id = isa->dev_id;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->module = isa->modulename;
      result->bus = ISA;
      result->io = isa->io;
      result->irq = isa->irq;
      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
      }/*endif*/
  }/*next isa*/

  /********************************************************************/
  /****************** PCMCIA SCSI-INTERFACE DETECTION *****************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing PCMCIA interface...\n");
  for(pcmcia = bus->pcmcia; pcmcia; pcmcia = pcmcia->next){
    if(pcmcia->type == SCSIINTERFACE){
      if(!first){
        first = result = (struct scsintf_info *) 
                                 my_malloc(sizeof(struct scsintf_info));
      }else{
        result->next = (struct scsintf_info *)
                                 my_malloc(sizeof(struct scsintf_info));
        result = result->next;
      }/*endif*/
      result->next = (struct scsintf_info *)NULL;
      
      result->vendor = pcmcia->vendor;
      result->model = pcmcia->model;
      result->module = pcmcia->modulename;
      result->long_id = pcmcia->id;
      result->bus = PCMCIA;
      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
    }/*endif*/
  }/*next pcmcia*/
  
#if defined(__PPC__)
  /********************************************************************/
  /****************** PowerPC SCSI-INTERFACE DETECTION ****************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing PowerPC interface...\n");
  i = 0;
  for(ppc_dev = ppc_scsi_dev[i]; ppc_dev != NULL; 
                                        i++, ppc_dev = ppc_scsi_dev[i]){
    fd = fopen(ppc_dev, "r");
    if(fd == (FILE *)NULL){
      if(debug)
	fprintf(stderr, FOPEN_READ_ERROR, ppc_dev);
    }else{
      line = 0; len = 0;
      getline(&line, &len, fd);
      fclose(fd);
      folder = my_malloc((sizeof(line) * strlen(line) + 20));
      sprintf(folder, "%s%s", "/proc/device-tree", line);
      if(!first){
        first = result = (struct scsintf_info *)
                               my_malloc((sizeof(struct scsintf_info)));
      }else{
        result->next = (struct scsintf_info *)
                               my_malloc((sizeof(struct scsintf_info)));
        result = result->next;
      }/*endif*/
      result->next = (struct scsintf_info *)NULL;

      result->vendor = "Apple";
      result->id = 0;
      result->bus = UNKNOWN_BUS;

      file = my_malloc(sizeof(folder) * strlen(folder) + 15);
      sprintf(file, "%s/model", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->model = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->model = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->model, line);
        fclose(fd);
      }/*endif*/
      sprintf(file, "%s/name", folder);
      fd = fopen(file, "r");
      if(fd == (FILE *)NULL){
	if(debug)
	  fprintf(stderr, FOPEN_READ_ERROR, file);
        result->module = s_unknown;
      }else{
        getline(&line, &len, fd);
        result->module = my_malloc(sizeof(line) * strlen(line) + 1);
        strcpy(result->module, line);
        fclose(fd);
      }/*endif*/

      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n",
		result->vendor, result->model);
      free(line); line=0;
      free(file); file=0;
    }/*endif*/
  }/*next ppc_dev*/
#endif

  return first;
}/*endfunc scsiinterface_detect*/


extern struct scsi_info *scsi_detect(void){
  struct scsi_info *first;	/* "first" scsi device in the list    */
  struct scsi_info *result;	/* current device                     */
  FILE *file;
  char *line2, *line3;
  char *vendor; char *device; char *model; char *type;
  int sd;			/* DISK                               */
  int scd;			/* CDROM                              */
  int sg;			/* generic SCSI devices, e.g. SCANNER */
  int st;			/* SCSI tape (e.g. streamer)          */

  line2 = (char *)my_malloc(1024);  
  line3 = (char *)my_malloc(1024);  
  type = (char *)my_malloc(18);  
  first = result = (struct scsi_info *)NULL;

  sd = 'a';
  scd = sg = st = 0;

  /********************************************************************/
  /* Length of text fields in `/proc/scsi/scsi'                       */
  /*   - Type  17 chars                                               */
  /*   - Vendor 8 chars                                               */
  /*   - Model 16 chars                                               */
  /********************************************************************/

  if((file = fopen(PATH_PROC_SCSI, "r")) == NULL){
    if(debug)
      fprintf(stderr, FOPEN_READ_ERROR, PATH_PROC_SCSI);
    free(line2);
    free(line3);
    return first;
  }/*endif*/

  if(debug)
    fprintf(stdout, "\nProbing SCSI devices...\n");

  fgets(line2, 500, file);
  if(strstr(line2, "Attached devices:") == NULL){
    fclose(file);
    free(line2);
    free(line3);
    return first;
  }/*endif*/
  while((fgets(line2, 500, file) != NULL) && 
        (fgets(line2, 500, file) != NULL) && 
        (fgets(line3, 500, file) != NULL)){
    line2[18]='\0';
    line2[42]='\0';
    line3[27]='\0';
    if(result != NULL){
      result->next = (struct scsi_info *)
                                    my_malloc(sizeof(struct scsi_info));
      result = result->next;
    }else{
      first = result = (struct scsi_info *)
                                    my_malloc(sizeof(struct scsi_info));
    }/*endif*/
    vendor = (char *)my_malloc(9);
    device = (char *)my_malloc(25);
    model = (char *)my_malloc(17);
    strcpy(vendor, line2+10);
    device[0] = '\0';
    strcpy(model, line2+26);
    strcpy(type, line3+10);
    result->next = (struct scsi_info *)NULL;
    result->vendor = trim(vendor);
    result->model = trim(model);
    if(strncmp(type, "Direct-Access", 13) == 0){
      if(strncmp(result->model, "ZIP", 3) == 0){
        result->type = FLOPPY;
      }else{
        result->type = DISK;
      }/*endif*/
      sprintf(device, "/dev/sd%c", sd);
      sd+=1;
      result->device = trim(device);
    }else if(strncmp(type, "Sequential-Access", 17) == 0){
      result->type = TAPE;
      sprintf(device, "/dev/st%i", st);
      st+=1;
      result->device = trim(device);
    }else if(strncmp(type, "Printer", 7) == 0){
      result->type = PRINTER;
    }else if(strncmp(type, "CD-ROM", 6) == 0){
      result->type = CDROM;
      sprintf(device, "/dev/scd%i", scd);
      scd+=1;
      result->device = trim(device);
    }else if(strncmp(type, "Scanner", 7) == 0){
      result->type = SCANNER;
      result->device = s_unknown;
      /* TODO correct device                  */
      /* sprintf(device, "/dev/sg%i", sg);    */
      /* sg+=1;                               */
      /* result->device = trim(device);       */
    }else{
      result->type = UNKNOWN_DEVICE;
    }/*endif*/
    if(debug)
      fprintf(stdout, "\t\tFound %s %s (%d)\n", 
	      result->vendor, result->model, result->type);
  }/*end while*/
  free(line2);
  free(line3);
  free(type);
  fclose(file);
  return first;
}/*endfunc scsi_detect*/
