/*
 * Detect a Library for hardware detection
 *
 * Detect modification's are Copyright (C) 1998-2000 MandrakeSoft
 *
 * This part is Based on the pcmcia-cs 3.0.9 cardctl tool:
 *
 * PCMCIA device control program
 *
 * cardctl.c 1.43 1998/12/07 06:04:32
 *
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The initial developer of the original code is David A. Hinds
 * <dhinds@hyper.stanford.edu>.  Portions created by David A. Hinds
 * are Copyright (C) 1998 David A. Hinds.  All Rights Reserved.
 */


#include "detect.h"
#include "utils.h"

#ifndef __linux__
#include <pcmcia/u_compat.h>
#endif

#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <sys/stat.h>

#include <pcmcia/version.h>
#include <pcmcia/config.h>
#include <pcmcia/cs_types.h>
#include <pcmcia/cs.h>
#include <pcmcia/cistpl.h>
#include <pcmcia/ds.h>

/*====================================================================*/

#ifdef __linux__

static int major = 0;

static int lookup_dev(char *name){
  FILE *f;
  int n;
  char s[32], t[32];
    
  f = fopen("/proc/devices", "r");
  if(f == NULL){
    return -errno;
  }/*endif*/
  while(fgets(s, 32, f) != NULL){
    if(sscanf(s, "%d %s", &n, t) == 2){
      if(strcmp(name, t) == 0){
        break;
      }/*endif*/
    }/*endif*/
  }/*endwhile*/
  fclose(f);
  if (strcmp(name, t) == 0){
    return n;
  }else{
    return -ENODEV;
  }/*endif*/
}/*endfunc lookup_dev*/

#endif /* __linux__ */

/*====================================================================*/

static int open_sock(int sock){
#ifdef __linux__
  int fd;
  char *fn;
  dev_t dev = (major<<8) + sock;
  if((fn = tmpnam(NULL)) == NULL){
    return -1;
  }/*endif*/
  if(mknod(fn, (S_IFCHR|S_IREAD|S_IWRITE), dev) != 0){
    return -1;
  }/*endif*/
  fd = open(fn, O_RDONLY);
  unlink(fn);
  return fd;
#endif
#ifdef __BEOS__
  char fn[B_OS_NAME_LENGTH];
  sprintf(fn, "/dev/pcmcia/sock%d", sock);
  return open(fn, O_RDONLY);
#endif
}/*endfunc  open_sock*/

/*====================================================================*/

static int get_tuple(int fd, cisdata_t code, ds_ioctl_arg_t *arg){
  arg->tuple.DesiredTuple = code;
  arg->tuple.Attributes = TUPLE_RETURN_COMMON;
  arg->tuple.TupleOffset = 0;
  if((ioctl(fd, DS_GET_FIRST_TUPLE, arg) == 0) &&
     (ioctl(fd, DS_GET_TUPLE_DATA, arg) == 0) &&
     (ioctl(fd, DS_PARSE_TUPLE, arg) == 0)){
    return 0;
  }else{
    return -1;
  }/*endif*/
}/*endfunc get_tuple*/

/**********************************************************************/
/* A utility function to scan /var/run/stab and apply a specified     */
/* action to each device, in turn. If any command returns a non-zero  */
/* exit code, execute() returns -1.                                   */
/**********************************************************************/

typedef struct stab_t{
  int  status;
  char class[33];
  char dev[33];
}stab_t;

#define MAX_SOCKS 8

struct pcmcia_info *pcmcia_detect(struct cards_lst *lst){
  int fd[MAX_SOCKS], ns;
  int found;
  unsigned long id;

  struct cards_lst *bkup_lst;
  struct pcmcia_info *result = (struct pcmcia_info *)NULL;
  struct pcmcia_info *first = (struct pcmcia_info *) NULL;

#ifdef __linux__
  major = lookup_dev("pcmcia");
  if(major < 0){                     /* We don't have a pcmcia driver */
    return NULL;
  }/*endif*/
#endif

  if(first){
    return first;
  }/*endif*/

  if(debug){
    fprintf(stdout, "\tProbing PCIMCIA cards...\n");
  }/*endif*/
  for(ns = 0; ns < MAX_SOCKS; ns++){
    fd[ns] = open_sock(ns);
    if (fd[ns] < 0) break;
  }/*endif*/
  if(ns == 0){
    perror("open_sock()");
    return NULL;
  }/*endif*/
  for(ns = 0; (ns < MAX_SOCKS) && (fd[ns] >= 0); ns++){
    ds_ioctl_arg_t arg;
    cistpl_manfid_t *manfid = &arg.tuple_parse.parse.manfid;
    cistpl_funcid_t *funcid = &arg.tuple_parse.parse.funcid;
      
    if(get_tuple(fd[ns], CISTPL_MANFID, &arg) == 0){
      id = (manfid->manf * 0x10000) + manfid->card;
      if(!first){
        first = result = (struct pcmcia_info *)
                                  my_malloc(sizeof(struct pcmcia_info));
      }else{
        result->next = (struct pcmcia_info *)
                                  my_malloc(sizeof(struct pcmcia_info));
        result = result->next;
      }/*endif*/
      if(get_tuple(fd[ns], CISTPL_FUNCID, &arg) == 0){
        result->type = pcmciaclass2device(funcid->func);
      }else{
        result->type = UNKNOWN_DEVICE;
      }/*endif*/
      result->next = 0;
      found = 0;
      for(bkup_lst=lst; bkup_lst; bkup_lst=bkup_lst->next){
        if((id == bkup_lst->long_id) && (bkup_lst->bus == PCMCIA)){
          result->id = bkup_lst->long_id;
          result->vendor = bkup_lst->vendor;
          result->model = bkup_lst->model;
          result->type = bkup_lst->type;
          result->modulename = bkup_lst->modulename;
          if(bkup_lst->type != UNKNOWN_DEVICE){
            result->type = bkup_lst->type;
          }/*endif*/
          found = 1;
        }/*endif*/
      }/*next bkup_lst*/
      if(!found){
        result->id = id;
        result->vendor = s_unknown;
        result->model = s_unknown;
        result->type = UNKNOWN_DEVICE;
        result->modulename = s_unknown;
      }/*endif*/
    }/*endif*/
    if(debug){
      fprintf(stdout, "\tFound %s %s (%s)\n", 
               result->vendor, result->model, device2str(result->type));
    }/*endif*/
  }/*next ns*/
  return first;
}/*endstruct pcmcia_detect*/
