/* print.cpp
 * 
 * basic printing support for GNU Denemo
 * outputs to a dvi file
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2001-2005 Adam Tee
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif

#include <errno.h>

#include "print.h"
#include "prefops.h"
#include "exportmudela.h"
#include "utils.h"


/*  Print function 
 *  Save file in lilypond format
 *  Fork and run lilypond
 *  TODO Add in lpr command
 */
void
print (GtkAction * action, gpointer callback_data)
{
  static GString *filename = NULL;
  GError* err = NULL;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoprint");

    }
  
  gchar* mudelafile = g_strconcat(filename->str, ".ly", NULL);  
  remove(mudelafile);
  exportmudela (mudelafile, si, 0, 0);
   gchar* argv[] = {
    si->prefs->lilypath->str,
    "--pdf",
    "-o",
    filename->str,
    mudelafile,
    NULL
  };

  gint exit_status;
  g_spawn_sync(NULL, /* dir */
	       argv,
	       NULL, /* env */
	       G_SPAWN_SEARCH_PATH,
	       NULL, /* child setup func */
          NULL, /* user data */
	       NULL, /* stdout */
	       NULL, /* stderr */
	       &exit_status,
	       &err);

  if (err != NULL)
    {
      g_warning("%s", err->message);
      g_error_free(err);
    }
  gchar *tmpfile = strstr(filename->str, "denemoprint");
  gchar* pdffile = g_strconcat(tmpfile, ".pdf", NULL);
  gchar *printfile = g_strconcat(filename->str, ".pdf", NULL);
  remove(printfile);
  if (rename(pdffile, printfile) != 0)
  {
    g_warning("Failed to rename %s to %s", (gchar *)pdffile, (gchar *)filename);
  }
  
  gchar* args[] = {
    si->prefs->pdfviewer->str,
    printfile,
    NULL
  };

  exit_status = 0;
  g_spawn_sync(NULL, /* dir */
	       args,
	       NULL, /* env */
	       G_SPAWN_SEARCH_PATH,
	       NULL, /* child setup func */
               NULL, /* user data */
	       NULL, /* stdout */
	       NULL, /* stderr */
	       &exit_status,
	       &err);

  if (err != NULL)
    {
      g_warning("%s", err->message);
      g_error_free(err);
    }
    


}
