/* selectops.h
 * selecting, cutting, copying, and pasting music
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller */

#include "datastructures.h"

#ifndef DENEMO_SELECTOPS
#define DENEMO_SELECTOPS

enum drag_selection_type
{
  NO_DRAG,
  NORMAL_SELECT,
  WHOLE_MEASURES,
  WHOLE_STAFFS
};
 
void clearbuffer ();

void saveselection(struct scoreinfo *si);

void copytobuffer (struct scoreinfo *si);

void cuttobuffer (struct scoreinfo *si);

void pastefrombuffer (struct scoreinfo *si);

void
set_mark (struct scoreinfo *si);

void
unset_mark (struct scoreinfo *si);

void
copywrapper (gpointer data, guint callback_action, GtkWidget *widget);

void
cutwrapper (gpointer data, guint callback_action, GtkWidget *widget);

void
pastewrapper (gpointer data, guint callback_action, GtkWidget *widget);

void
mark_boundaries_helper (struct scoreinfo *si, gint mark_staff,
			gint mark_measure, gint mark_object, gint point_staff,
			gint point_measure, gint point_object,
			enum drag_selection_type type);

void
calcmarkboundaries (struct scoreinfo *si);

void
saveselwrapper(gpointer data, guint callback_action, GtkWidget *widget);
#endif
