/** Generate a header from a context-free grammar.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include "cfg.h"
#include "dictionary.h"
#include "util.h"
#include <ctype.h>
#include <stdio.h>
#include <string.h>


/** Name of this program. */
const char* program = "cfgh";


/** Converts this string to upper-case. */
static char*
strupr( char* str)
{
	char* p;
	for( p = str; *p; p++)
		*p = toupper( *p);
	return str;
}


/** Generates a header for the context-free grammar on stdandard
 * input. */
int
main( int argc, char* argv[])
{
	int i;
	CFG g;
	const char* name;
	const char* NAME;
	assumex( argc == 2, "missing argument");
	name = argv[1];
	NAME = strupr( strdup( name));

	read_cfg( &g, stdin);

	printf( "#ifndef __%s_h__\n"
			"#define __%s_h__\n\n",
			name, name);

	printf( "#define %s_SYMBOLS %d\n\n", NAME, g.symbols.count);

	printf( "Entry %s_entries[] = {\n", name);
	for( i = 0; i < g.symbols.count; i++)
		printf( "\t{\"%s\", %d},\n",
				g.symbols.entries[i].key,
				g.symbols.entries[i].id);
	puts( "};");
	putchar( '\n');

	printf( "const char* %s_keys[] = {\n", name);
	for( i = 1; i <= g.symbols.count; i++) {
		char* key = (char*)get_key( &g.symbols, i);
		printf( "\t\"%s\",\n", key);
		printf( "#define %s %d\n", strupr( key), i);
	}
	puts( "};");
	putchar( '\n');

	printf( "const Dictionary %s_symbols = {\n"
			"\t%s_SYMBOLS, %s_SYMBOLS, %s_entries, %s_keys\n"
			"};\n\n",
			name, NAME, NAME, name, name);

	puts( "#endif");
	return 0;
}
