#ifndef __syscall_h__
#define __syscall_h__

#include "dictionary.h"

#define SYSCALL_STRINGS 5

#define PRINT_INT 1
#define PRINT_STRING 4
#define READ_INT 5
#define READ_STRING 8
#define EXIT 10

static Entry syscall_entries[] = {
	{"\"exit\"", EXIT},
	{"\"print_int\"", PRINT_INT},
	{"\"print_string\"", PRINT_STRING},
	{"\"read_int\"", READ_INT},
	{"\"read_string\"", READ_STRING},
};

static const Dictionary syscall_strings = {
	SYSCALL_STRINGS, SYSCALL_STRINGS, syscall_entries, NULL
};

#endif
