##########################################################################
#
# setup.py: File to build and install the application.
#
#  debpartial-mirror is an application to make easier to build full or
#  partial mirrors from Debian or compatible archives.
#  See http://partial-mirror.alioth.debian.org/ for more information.
#    
# ====================================================================
# Copyright (c) 2002-2005 OS Systems.  All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution.
#
#########################################################################
# Author: Otavio Salvador <otavio@ossystems.com.br>

from os import listdir
from distutils.core import setup

lib_files = []
for f in listdir('debpartial_mirror/'):
    if f[-3:] == '.py':
        lib_files.append(f)

setup(
    name = "debpartial-mirror",
    version = '0.2.99',
    author = "Otavio Salvador",
    author_email = "otavio@debian.org",
    url = "http://partial-mirror.alioth.debian.org",
    license = "GPL",
    description = "tools to create partial Debian mirrors",
    scripts = [ 'debpartial-mirror' ],
    packages = [ 'debpartial_mirror' ]
    )
    

    
    
