# debpartial_mirror - partial debian mirror package tool
# (c) 2004 Otavio Salvador <otavio@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# TODO: Build two classes to be used. One for remote files and other
# for local files.

import os.path

#import pycurl

from cdd import FileSystem

from debpartial_mirror import Download
from debpartial_mirror import DisplayStatus

class Files:
    """
    This class provides methods to manage normal files of partial-mirrors.

    It can be used to get files based on regexp and full paths.
    """

    def __init__ (self, backend):
        self._backend = backend
        self._files = []
        self._filesystem = FileSystem.FileSystem(os.path.join(backend["mirror_dir"], backend["name"]))
        
    def upgrade(self):
        """
        This method is used to implement specific logic.

        You MUST to implement it.
        """
        raise NotImplementedError

class RemoteFiles(Files):
    def upgrade(self):
        download = Download.Download(name = "Files_" + self._backend["name"])
        if self._backend.has_key('files'):
            for file in self._backend['files']:
                download.get(self._backend['server'] + '/' + file,
                      self._backend['mirror_dir'] +  self._backend['name'] + '/' + file)
            download.wait_mine()
