<?xml version="1.0" encoding="utf-8" ?>
<!-- vim: set sts=2 ai expandtab:

Process XML file after the initial changes to raw.xml to address document section 
differences:
 * to add URL attribute to "&url-*;"
 * to fix XML export issues for the list
 * to add XML tags
 * to add ID  attribute to valid name from title for chapter, appendix, section, ...

XML tags and wiki marks:
 * warning:	added for para with /!\
 * caution:	added for para with <!>
 * important:	added for para with {*}
 * tip:		added for para with {i}
 * note:	added for para with (!)
 * note:	added for para with (./)
 * note:	added for para with {OK}

-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="uletters">ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 !#$%()=-~^|\/+*,.?;:@`&quot;&apos;&amp;&gt;&lt;</xsl:variable>
<xsl:variable name="lletters">abcdefghijklmnopqrstuvwxyzabcdefghij</xsl:variable>

<!-- I will use max 32 characters for href references and id references -->

<xsl:output method="xml" indent="yes"/>

<!-- xsl:strip-space elements="*"/ -->

<xsl:template match="ulink">
  <xsl:choose>
    <xsl:when test="starts-with(@url,'/')">
      <xsl:value-of select="node()"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:attribute name="url">
          <xsl:value-of select="'@@@amp@@@'"/>
          <xsl:choose>
            <xsl:when test="string-length(translate(.,$uletters,$lletters)) &lt;= 32">
              <xsl:value-of select="translate(.,$uletters,$lletters)"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat(substring(translate(.,$uletters,$lletters),1,16),substring(translate(.,$uletters,$lletters), string-length(translate(.,$uletters,$lletters))-15,16))"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="';'"/>
        </xsl:attribute>
        <xsl:apply-templates select="node()"/>
      </xsl:copy>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- work around wiki XML export issue with list -->
<xsl:template match="listitem">
  <xsl:choose>
    <xsl:when test=".=text()">
      <xsl:copy>
        <para>
          <xsl:value-of select="node()"/>
        </para>
      </xsl:copy>
    </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- add XML tags -->
<xsl:template match="para">
	<xsl:choose>
		<xsl:when test="inlinemediaobject/textobject/phrase='/!\'">
		    <warning><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></warning>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='&lt;!&gt;'">
		    <caution><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></caution>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='{*}'">
		    <important><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></important>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='{i}'">
		    <tip><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></tip>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='(!)'">
		    <note><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></note>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='{OK}'">
		    <note><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></note>
		</xsl:when>
		<xsl:when test="inlinemediaobject/textobject/phrase='(./)'">
		    <note><para>
		      <xsl:apply-templates select="@*|node()"/>
		    </para></note>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:copy>
		    <xsl:apply-templates select="@*|node()"/>
		  </xsl:copy>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="inlinemediaobject">
</xsl:template>

<!-- add id attribute -->
<xsl:template match="chapter|section|appendix">
  <xsl:copy>
    <xsl:attribute name="id">
      <xsl:choose>
        <xsl:when test="string-length(translate(title,$uletters,$lletters)) &lt;= 32">
          <xsl:value-of select="translate(title,$uletters,$lletters)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(substring(translate(title,$uletters,$lletters),1,16),substring(translate(title,$uletters,$lletters), string-length(translate(title,$uletters,$lletters))-15,16))"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>

<xsl:template match="@*|node()">
  <xsl:copy>
    <xsl:apply-templates select="@*|node()"/>
  </xsl:copy>
</xsl:template>


</xsl:stylesheet>






