#!/bin/bash

OPT=${1:-A4}
if [ "$OPT" != "A5" -a "$OPT" != "A4" -a "$OPT" != "html" ]; then
	echo "Uso: ./remake [A5|A4|html]"
	exit 1
fi

FICHERO="debian-guide-es"

LATEX=latex
# LATEX=pdflatex

./clean.sh || true

[ -e preambulo.tex ] || ln -si preambulo-$OPT.tex preambulo.tex
${LATEX} ${FICHERO}.tex
${LATEX} ${FICHERO}.tex
${LATEX} ${FICHERO}.tex
makeindex ${FICHERO}.idx
${LATEX} ${FICHERO}.tex
${LATEX} ${FICHERO}.tex
${LATEX} ${FICHERO}.tex

if [ "$LATEX" = "pdflatex" ]; then
	exit 0
fi

if [ "$OPT" = "A5" ]; then
	dvips -t a3 -o ${FICHERO}.tmp.ps ${FICHERO}.dvi
	psresize -q -pa4 -Pa3 ${FICHERO}.tmp.ps ${FICHERO}.ps
	rm ${FICHERO}.tmp.ps
	ed -s ${FICHERO}.ps >/dev/null 2>&1 <<EOF
g/^%%BeginPaperSize: a3$/
d
d
i
%%BeginPaperSize: a4
a4
.
6,7c
%%BoundingBox: 0 0 596 842
.
wq
EOF
elif [ "$OPT" = "A4" ]; then
	dvips -o ${FICHERO}.ps ${FICHERO}.dvi
elif [ "$OPT" = "html" ]; then
	latex2html ${FICHERO}.tex
fi
