/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * toolkit.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: toolkit.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __TOOLKIT_H__
#define __TOOLKIT_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#ifdef HAVE_SYS_POLL_H
#include <sys/poll.h>
#else
#include "my_poll.h"
#endif
/*************************************************************************/
/* this function splits the string (in_string) using the given separator */
/* Each part of the splitted string is appended to chunk. The address of */
/* the appended string is appended to the given tbl.                     */
/* if *tbl or *chunk ==NULL, it is created.                              */
/* multiple consecutive separators are ignored (like strtok).            */
/*************************************************************************/
void split_string_into_array(GPtrArray **tbl, GStringChunk **chunk, const char *in_string, const char *separators);

/******************************************************************/
/* adjust the given 'var' to be sure it is always <= to 'max_val' */
/******************************************************************/
#define CLAMP_VAL(var,max_val)		{if((var)>(max_val)) (var)=(max_val);}

/************************************************************************************************/
/* search inside the struct_pollfd_array [low_range:high_range[ for a fd matching the given one */
/************************************************************************************************/
/* NOTE: the returned pointer points inside the Garray*, it is not a copy  */
/*       no test is made to verify if low_range and high_range are indices */
/*       valid in struct_pollfd_array (value must been clamped before)     */
/***************************************************************************/
struct pollfd *pollfd_array_find_fd(GArray *struct_pollfd_array, int fd, int low_range, int high_range);

/***************************************************/
/* compute the size of a NULL terminated ptr array */
/***************************************************/
int size_of_null_array(void **array);

/*********************************************************************/
/* return a static const string with the same value as the given one */
/*********************************************************************/
const char *fnd_static_cnx_type(char *type);
const char *fnd_static_cnx_type_from_str_len(char *type, int type_length);

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ----------------------- memory access macro ------------------------------ */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*****************************************************************************/
/* some CPU accepts to read word not aligned on a word boundary, other don't */
/*****************************************************************************/
#ifndef NO_UNALIGNED_ACCESS
/* lucky, the CPU is not too stupid */

#define GET_UAA_GUINT16(addr)		(*((guint16*)(addr)))
#define GET_UAA_GUINT32(addr)		(*((guint32*)(addr)))
#define GET_UAA_GUINT64(addr)		(*((guint64*)(addr)))

#define GET_UAA_GINT16(addr)		(*((gint16*)(addr)))
#define GET_UAA_GINT32(addr)		(*((gint32*)(addr)))

#else
/* bad luck, the CPU is very stupid */
guint16 get_unaligned_guint16(guint8 *addr);
guint32 get_unaligned_guint32(guint8 *addr);
guint64 get_unaligned_guint64(guint8 *addr);

#define GET_UAA_GUINT16(addr)		get_unaligned_guint16(addr)
#define GET_UAA_GUINT32(addr)		get_unaligned_guint32(addr)
#define GET_UAA_GUINT64(addr)		get_unaligned_guint64(addr)

/* it is not an error, we use the same function as above */
#define GET_UAA_GINT16(addr)		((gint16)get_unaligned_guint16(addr))
#define GET_UAA_GINT32(addr)		((gint32)get_unaligned_guint32(addr))
#endif

#endif
