/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * sema.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __SEMA_H__
#define __SEMA_H__

#ifndef SEMVMX
/* this value comes from linux/sem.h */
/* but I don't know how to get them from the include without compilation errors */
#define SEMVMX 32767
#endif

/******************************************/
/* number of semaphores in the SEMA array */
/***********************************************************/
/* sema 0: to choose which client is the clock master      */
/* sema 1: remaining part of sema 2 for the current second */
/* sema 2: number of 512bytes blocs which can be sent by   */
/*         clients per second.                             */
/* sema 3: remaining part of sema 4 for the current second */
/* sema 4: number of 512bytes blocs which can be downloaded*/
/*         clients per second.                             */
/* sema 5: remaining part of sema 6 for the current second */
/* sema 6: number of 8KBytes blocs which can be read per   */
/*         second when clients gather GDL parts.           */
/***********************************************************/
#define SEMA_ARRAY_LEN (1+2+2+2)

typedef enum
{
	MASTER_SEMA=0,
	UL_SEMA=1,
	UL_SPD_SEMA=2,
	DL_SEMA=3,
	DL_SPD_SEMA=4,
	GATHER_SEMA=5,
	GATHER_SPD_SEMA=6,
} SPD_SEMA;

/******************************/
/* initialize semaphore array */
/*************************************************************************************/
/* input: keyfile : if not exists, it is created and the semaphore key is put inside */
/*                  if exists but the semaphore key inside is invalid, same as above */
/*                  if exists and contains a valid key, nothing is done              */
/*        spd_limit is the default speed limit (in number of 512bytes slice)         */
/*************************************************************************************/
/* output: 0=ok, !=0=error                                              */
/*         on success, *cur_semid is the semaphore id to use with semop */
/************************************************************************/
int do_sema_init(char *keyfile, int *cur_semid, int spd_limit, int dl_spd_limit, int gath_spd_limit);

/******************************************************************************************/
/* to avoid forever hanging of download, we must regularly check if a clock master exists */
/******************************************************************************************/
void check_sema_master(int semid);

/************************/
/* get 1 512Bytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_slice(int semid, SPD_SEMA semnum);

/*************************/
/* get nb 512Bytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_ul_slices(int semid,int nb);

/************************/
/* get nb 1KBytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_dl_slices(int semid,int nb);

/************************/
/* get nb 8KBytes slice */
/*******************************************/
/* the function ends when it has the slice */
/*******************************************/
void get_gather_slices(int semid,int nb);

#endif
